\name{st.2logL.profile}
\alias{st.2logL.profile}
\title{
Profile twice loglikelihood for skew-t models
}
\description{
Computation and plot of 1-dimensional and 2-dimensional profile
(negative) twice log-likelihood function for skew-t regression models.
}
\usage{
st.2logL.profile(X=matrix(rep(1, n)), y, freq, trace=FALSE,
          fixed.comp = c(ncol(X)+2, ncol(X)+3), 
          fixed.values = cbind(c(-4,4), log(c(1,25))),
          npts=51/length(fixed.comp), plot.it=TRUE, ...)
}
\arguments{
\item{X}{
a matrix of explanatory variables; must have \code{nrow(X)} equal to
\code{length(y)}. Missing values (\code{NA}) are not allowed.
If \code{X} is missing, a one-column matrix of 1's is created.
}
\item{y}{
a numeric vector. Missing values (\code{NA}s) are not allowed.
}
\item{freq}{
a vector of weights.
If missing, a vector of 1's is created; otherwise
it must have the same length of \code{y}.
}
\item{trace}{
logical value which controls printing of the algorithm convergence.
If \code{trace=TRUE}, details are printed. Default value is \code{FALSE}.
}
\item{fixed.comp}{
a vector containing the subset of the parameters for which the
profile log-likelihood function is required; it can be of length 1 or 2.
The set of components of the parameters are \code{beta, log(omega), 
alpha, log(df)}, where \code{beta} represents the regression parameters
and has \code{ncol(X)} components.
}
\item{fixed.values}{
a numeric vector of values or a matrix with two columns, giving the
range spanned by the selected parameters. 
}
\item{npts}{
number of points on each parameter interval for which the function
must be evaluated.
}
\item{plot.it}{
logical value; if \code{plot.it=TRUE} (default value) a graphical display
is produced.
}
\item{...}{
graphical parameter passed either to \code{plot} or to \code{contour},
depending on whether \code{lenght(fixed.comp)} is 1 or 2.
}}
\value{
A list containing the following components:
\item{call}{
the matched call.
}
\item{param1}{
vector of values of the first parameters values where the function 
has been evaluated. 
}
\item{param2}{
vectors of the parameters values where the function has been evaluated. 
If \code{length(fixed.comp)=1}, the second vector contains \code{NA}s.
}
\item{deviance}{
a vector or a matrix which represents twice the negative relative 
profile loglikelihood; this is in the "relative" version, i.e.
setting the maximum value to be 0.
}
\item{max.logL}{
a numeric value with the maximum which has been added to
obtain the "relative" version of \code{deviance}.
}
\item{best}{
a list with the output of \code{optim} at the best evaluated point,
that is the one with higher log-likelihood. 
}}
\section{Side Effects}{
If \code{plot.it=TRUE}, a plot of the profile twice relative loglikeliood is
produced on a graphical device. 
If \code{length(fixed.comp)=1}, a plot of the `deviance' is produced
as a function of the chosen parameter component.
If \code{length(fixed.comp)=2}, this plot takes the form of a contour plot 
whose contour lines correspond to confidence regions of approximate
probability levels \code{c(0.25, 0.5,  0.75, 0.90,0.95, 0.99)}.
}
\section{Background}{
The family of skew-t distributions is an extension of the Student's t
family, via the introduction of a \code{shape} parameter which regulates
skewness; when \code{shape=0}, the skew-t distribution reduces to the
usual t distribution. A multivariate version of the distribution exists.
See the reference below for additional information.
}
\references{
Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \emph{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
}
\seealso{
\code{\link{st.mle}}, \code{\link{sn.2logL.profile}}
}
\examples{
data(ais, package="sn")
attach(ais)
a <- st.2logL.profile(y=bmi, xlab="alpha", ylab="log(df)")
a <- st.2logL.profile(y=bmi, fixed.comp=4, fixed.values=log(c(1,25)))
a <- st.2logL.profile(X=cbind(1,lbm), y=bmi, fixed.comp=5,  
         fixed.values=log(c(5,25)), xlab="log(df)", npts=50)
a <- st.2logL.profile(X=cbind(1,Ht), y=Wt, fixed.comp=c(4,5),
         fixed.values=cbind(c(-1,5), log(c(2,25))),
         xlab="alpha", ylab="log(df)")
}
\keyword{distribution}
