% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_exists.R
\name{core_exists}
\alias{core_exists}
\title{Check if a core exists}
\usage{
core_exists(name, callopts = list())
}
\arguments{
\item{name}{(character) The name of the core. If not given, all cores.}

\item{callopts}{curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A single boolean, \code{TRUE} or \code{FALSE}
}
\description{
Check if a core exists
}
\details{
Simply calls \code{\link{core_status}} internally
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg: bin/solr start -e schemaless
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
solr_connect()

# exists
core_exists("gettingstarted")

# doesn't exist
core_exists("hhhhhh")
}
}

