% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.R
\name{unzip}
\alias{unzip}
\title{Uncompress 'zip' Archives}
\usage{
unzip(zipfile, files = NULL, overwrite = TRUE, junkpaths = FALSE, exdir = ".")
}
\arguments{
\item{zipfile}{Path to the zip file to uncompress.}

\item{files}{Character vector of files to extract from the archive.
Files within directories can be specified, but they must use a forward
slash as path separator, as this is what zip files use internally.
If \code{NULL}, all files will be extracted.}

\item{overwrite}{Whether to overwrite existing files. If \code{FALSE} and
a file already exists, then an error is thrown.}

\item{junkpaths}{Whether to ignore all directory paths when creating
files. If \code{TRUE}, all files will be created in \code{exdir}.}

\item{exdir}{Directory to uncompress the archive to. If it does not
exist, it will be created.}
}
\description{
\code{unzip()} always restores modification times of the extracted files and
directories.

\if{html}{\out{<link rel="stylesheet" type="text/css" href="../doc/assets/extra.css">}}

\if{html}{\out{<script src="../doc/assets/rd.js"></script>}}
}
\section{Permissions}{


If the zip archive stores permissions and was created on Unix,
the permissions will be restored.
}

\examples{
## temporary directory, to avoid messing up the user's workspace.
dir.create(tmp <- tempfile())
dir.create(file.path(tmp, "mydir"))
cat("first file", file = file.path(tmp, "mydir", "file1"))
cat("second file", file = file.path(tmp, "mydir", "file2"))

zipfile <- tempfile(fileext = ".zip")
zip::zip(zipfile, "mydir", root = tmp)

## List contents
zip_list(zipfile)

## Extract
tmp2 <- tempfile()
unzip(zipfile, exdir = tmp2)
dir(tmp2, recursive = TRUE)
}
