% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DataGeNET.DGN-class}
\alias{DataGeNET.DGN-class}
\title{Class DataGeNET.DGN}
\description{
Class \code{DataGeNET.DGN} is one of the two objects used in \code{disgenet2r}
package. It is the main data container to using the different functions to
query DisGeNET database and generate their output.
}
\section{Slots}{

\describe{
\item{\code{type}}{type of query: \code{'gene-disease'} or  \code{'variant-disease'}
or \code{'disease-gene'},  or \code{'disease-variant'} or \code{'disease-disease'} or \code{'disease-enrichment'}.}

\item{\code{search}}{Character containing \code{'single'} of \code{'list'}.It is
used to perform the correct query to DisGeNET}

\item{\code{database}}{Character containing the name of the database that will be
queried. It can take the values
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use GENOMICS England;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{\code{scoreRange}}{the disGeNET score range to retrieved the GDAs or VDAs}

\item{\code{term}}{Character with the term(s) to search into the database(s).}

\item{\code{qresult}}{\code{data.frame} with the obtained result}
}}

\seealso{
disease2gene, gene2disease, DataGeNET.DGN-methods
}
