/*
Remote Access Session v0.7 services_info.c -
Code By Angel Ramos <seamus@salix.org>
*/

#include "raccess.h"

void check_dns (int sockfd, char *host)	{
   char iquery[512];
	char query [512];
	HEADER *iqueryh;
	
	srand (time (NULL));
	iqueryh = (HEADER *)iquery;
	memset (iquery, 0, sizeof (iquery));
	memset (query, 0, sizeof (query));
	if (!begin_packet (sockfd, iquery, sizeof iquery, IQUERY))	{
		fprintf (stderr, "Can't make iquery. No named running.\n");
		return;
	}
	if (!begin_packet (sockfd, query, sizeof query, QUERY))	{
		fprintf (stderr, "Can't make query. No named running.\n");
		return;
	}
	version (host, iqueryh->rcode == 0, query);
	return; 	
}

int begin_packet (int sockfd, char *packet, int lpacket, char tpacket)	{
	int packlen;
	
	packlen = make_packet (packet, tpacket);
	if (!write (sockfd, packet, packlen))	{
		return (0);
	}
	siginterrupt (SIGALRM,1);
	signal (SIGALRM, handle_alarm);
	alarm (3);
	packlen = read (sockfd, packet, lpacket);
	if (packlen <= 0)	{
		return (0);
	}
	alarm (0);
	return (1);
}

int make_packet (char *packet, char tpacket)	{
	HEADER *packeth;
	char *ptr;
	int packlen;
	
	ptr = packet;
	packlen = 0;
	packeth = (HEADER *) ptr;
	packeth->id = htons (rand() % 65535);
	packeth->opcode = tpacket;
	packeth->rd = 1;
	packeth->ra = 1;
	if (tpacket == IQUERY)	{
		packeth->ancount = htons(1);
	}
	else	{
		packeth->qdcount = htons(1);
	}
	packlen += sizeof (HEADER);
	ptr += sizeof (HEADER);
	if (tpacket == QUERY)	{
		char qstr[] = "\007version\004bind\000";
		int qlen = strlen(qstr) + 1;
		memcpy (ptr, qstr, qlen);
		ptr += qlen;
		packlen += qlen;
		PUTSHORT (T_TXT, ptr);
		PUTSHORT (C_CHAOS, ptr);
		packlen += sizeof (short) * 2;
	}
	else	{
		unsigned long addr = inet_addr ("1.2.3.4");
		unsigned long ttl = 31337;
		unsigned short addrlen = 4;
		 
		*(ptr++) = '\0';
		packlen++;
		PUTSHORT (T_A, ptr);
		PUTSHORT (C_IN, ptr);
		PUTLONG (ttl, ptr);
		PUTSHORT (addrlen, ptr);
		PUTLONG (addr, ptr);
		packlen += (sizeof (short) *3) + (sizeof (long) *2);
	}
	return packlen;
}

void version (char *host, int status, char *packet)	{
	HEADER *packeth;
	char *ptr;
	int len;
	char *namedver;
	
	packeth = (HEADER *)packet;
	if (packeth->rcode != 0)	{
		printf ("The %s's named doesn't answer to version.\n", host);
		return;
	}
	ptr = (packet + sizeof (HEADER));
	while (*ptr != '\0')	{
		ptr++;
	}
	ptr += 1 + (sizeof (short) * 2);
	while (*ptr != '\0')	{
		ptr++;
	}
	ptr += 1 + (sizeof (long) + (sizeof (short) * 2));
	GETSHORT (len, ptr);
	ptr++;
	namedver = (char *)malloc(len);
	memset (namedver, 0, len);
	memcpy (namedver, ptr, len-1);
	for (ptr = namedver; ptr - namedver != len - 1; ptr++)	{
		if (!isprint(*ptr) && isspace(*ptr))	{
			*ptr = '.';
		}
	}
	printf ("Named version: %s\n\n", namedver);
	if ((filedesc = fopen (host, "a")) == NULL)	{
		printf ("Can't open log file.\n");
	}
	else	{
		fprintf (filedesc, "--Named version:--\n");
		fprintf (filedesc, "%s\n\n", namedver);
		fclose (filedesc);
	}
}
		
void handle_alarm (int sign)	{
	alarm (0);
	signal (SIGALRM, SIG_DFL);
}	  



int extract_banner (int sockfd, int port, char *servicename, char *host)	{
	char buffer[1024];
	char http_request[18];
	ssize_t n, w;
	int r;
	fd_set rset;
	struct timeval time;
	char *http_banner, *tok;
	pid_t pid;
	char *argv;
	
	FD_ZERO (&rset);
	FD_SET (sockfd, &rset);
	time.tv_sec = 10;
	time.tv_usec = 0;
	if (port == 53)	{
		check_dns (sockfd, host);
		return (0);
	}
	if ((port == 80) || (port == 443))	{ 
		snprintf (http_request, sizeof (http_request), 
			"HEAD / HTTP/1.0\n\n");
		if ((w = write (sockfd, http_request, 
		sizeof (http_request))) != sizeof (http_request))	{
			printf ("Can't write http socket.\n");
		}
		if ((r = select (sockfd +1, &rset, NULL, 
			NULL, &time)) == 0)	{
			printf ("No Banner :((\n");
			return (0);
		}
		bzero (buffer, 1024);
		if ((n = read (sockfd, buffer, 1024)) < 0)	{
			printf ("Can't read http socket.\n");
		}
		if (n == 0)	{
			printf ("No Banner :((\n");
			return (0);
		}	
		if (FD_ISSET (sockfd, &rset))	{
			if ((http_banner = strstr (buffer, 
				"Server:")) == NULL)	{
				printf ("No HTTP server info :((\n");
				return (0);
			}
			tok = strtok (http_banner, "\n");
			printf ("%s\n", tok);
			if ((filedesc = fopen (host, "a")) == NULL)	{
				printf ("Can't open file log file.");
			}
			else	{
				fprintf (filedesc, "%s\n\n", tok);
				fclose (filedesc);
			}
			return (0);
		}
	} 	
	do	{
		if ((r = select (sockfd +1, &rset, NULL, NULL, &time)) == 0)	{
			printf ("No Banner :((\n");
			return (0);
		}
		bzero (buffer, 1024);
		if ((n = read (sockfd, buffer, 1024)) < 0)	{
			printf ("Can't read socket.\n");
		}
	} while ((n != 0) && (n < 10));
	if (n == 0)	{
		printf ("No Banner :((\n");
		return (0);
	}	
	buffer[n] = '\0';
	if (FD_ISSET (sockfd, &rset))	{
		printf ("Banner Info: %s", buffer);
		fflush (stdout);
		if ((filedesc = fopen (host, "a")) == NULL)	{
			printf ("Can't open log file.\n");
		}
		else	{
			fprintf (filedesc, "%s\n", buffer);
			fclose (filedesc);
		}
	}
	return (0);
}

	 
 
