/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>

#include "menu_sfx.h"
#include "debug.h"
#include "config.h"

CL_SoundBuffer* MenuSfx::menu_select = NULL;
CL_SoundBuffer* MenuSfx::menu_move	= NULL;

void MenuSfx::init()
{
#ifdef RACE_SOUND
	RaceDebug::print("Resources: MenuSfx: resources/sound.res", 7);
	
	CL_String path = DATADIR;
	path += "resources/sound.res";

	CL_ResourceManager res( path, false );
	
	MenuSfx::menu_select = CL_SoundBuffer::load("menu_select", &res);
	MenuSfx::menu_move	= CL_SoundBuffer::load("menu_move", &res);
#endif
}
  
