#include <ClanLib/core.h>
#include <ClanLib/sound.h>

#include "game_config.h"
#include "debug.h"
#include "car_config.h"
#include "car_sfx.h"
#include "sound_controller.h"

SoundController::SoundController()
{
#ifdef RACE_SOUND
	play_engine_sound = true;

	pitch = 44100;
	doppler_pitch = 0;
	volume = 0.3;
#endif
}

void SoundController::init( int id)
{
#ifdef RACE_SOUND
	this->id = id;

	high = CarSfx::engine_high[id]->prepare();
	low = CarSfx::engine_low[id]->prepare();
#endif
}

void SoundController::update()
{
#ifdef RACE_SOUND
	RaceDebug::print("SoundController::update", 11);

	if( !Config::sfx_on ) return;

	play();
#endif
}

void SoundController::play()
{
#ifdef RACE_SOUND

	RaceDebug::print("SoundController::play", 11);
	
	high.set_volume( volume );
	low.set_volume( volume );
	
	if( play_engine_sound == false )
	{
		high.set_volume( 0.0f );
		low.set_volume( 0.0f );
	}
	
	if( low.is_playing() == false )
	{
		low.set_looping(true);
		low.set_volume( volume );
		low.play();
	}
/*	
 	if( high.get_position_relative() >= 0.70 )
		high.set_position_relative(0);

	if( low.get_position_relative() >= 0.70 )
		low.set_position_relative(0);
*/

	if( high.is_playing() == false )
	{
		high.set_looping(true);
		high.play();
		high.set_volume( 1.0f );
	}
#endif
}


void SoundController::update_frequency( float speed )
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;
	
	RaceDebug::print("SoundController::update_frequency", 11);
	
	
	if( Config::cc->change_pitch_h[id] == true )
	{
		float new_pitch =  30000 + (speed * 4000) + doppler_pitch;
	
		if( new_pitch < 0 ) new_pitch = 30000; // ??
		if( new_pitch > 50000 ) new_pitch = 50000; // ??
		
		high.set_frequency( new_pitch );
	}
//	else
//		high.set_frequency( 44100 );

//	low.set_frequency( 30000 + (speed * 500) + doppler_pitch );

	 RaceDebug::print("SoundController::update_frequency -- done", 11 );


#endif
}

void SoundController::play_start()
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;

	CarSfx::engine_start->play();
#endif
}

void SoundController::increase_pitch( float dist, float old_dist )
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;

	float inc = 1 + ( dist - old_dist );
	doppler_pitch = (( pitch * inc ) - pitch)*2;
#endif
}

void SoundController::decrease_pitch( float dist, float old_dist )
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;

	float dec = 1.0f - ( old_dist - dist );
	doppler_pitch = ((pitch * dec) - pitch)*2;
#endif
}

void SoundController::set_volume( float vol )
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;

	CL_String vol_str = "new volume: ";
	vol_str += vol;
	RaceDebug::print( vol_str.get_string(), 11 );

	this->volume = vol;
#endif
}

void SoundController::stop()
{
#ifdef RACE_SOUND
	if( !Config::sfx_on ) return;

	RaceDebug::print("SoundController::stop()", 11 );

	high.stop();
	low.stop();
#endif
}


