#include "gunobj.h"
#include "weaponobj.h"
#include "gun_etwirl_machine.h"
#include "hull_weapon_twirl.h"
#include "defs.h"
#include "trigtable.h"
#include "spaceobj.h"
#include "ebox.h"
#include "rafkill.h"
#include <vector>

using namespace std;

EnemyTwirlMachine::EnemyTwirlMachine( int d, int al ):
WeaponObject( d, "Twirl Machine", 0, al, 0, 0 ),
tear( 5 ) {

	BITMAP * temp = create_bitmap( 6, 12 );
	clear_to_color( temp, makecol(255,0,255) );
	ellipsefill( temp, 3, 6, 3, 6, makecol(255,255,255) );
	ecollide = new ECollide( temp,2,makecol(255,0,255), 52 );
	destroy_bitmap( temp );

}


EnemyTwirlMachine::~EnemyTwirlMachine() {
	delete ecollide;
}


void EnemyTwirlMachine::MakeShot(int x, int y,vector< SpaceObject * > * Ammo, vector< SpaceObject * >  * fight ) {
	shot_counter = 40;
	if ( fight == NULL ) return;
	if ( tear > 0 ) {
		tear--;
		shot_counter = 10;
	} else tear = 5;

	if ( fight->empty() ) return;

	SpaceObject * use = fight->front();

	if ( use != NULL ) {
		int sang = gang( x, y, use->actualx, use->actualy+7 );
		double sx = tcos[sang]*1.1;
		double sy = tsine[sang]*1.1;
		Ammo->push_back( new WeaponNode(x,y,sx,sy,new Twirl_WHull((BITMAP *)global_data[BULLET_TWIRL].dat, ecollide->copy() ), alignment ) );
	}
}
