#include "gunobj.h"
#include "gun_tractor_beam.h"
#include "trigtable.h"
#include "weapon_damage.h"
#include "hull_weapon_tractor_beam.h"
#include "spaceobj.h"
#include "ebox.h"
#include <vector>
#include <math.h>

using namespace std;

WeaponTractorBeam::WeaponTractorBeam( int z, int d, int al ):
WeaponObject( d, "Tractor Beam", 405000, al, z, 4 ) {
	look = NULL;

	BITMAP * temp = create_bitmap( 8, 8 );
	clear_to_color( temp, makecol(255,0,255) );

	circlefill( temp, 4, 4, 3, makecol(255,0,0) );
	collide = new ECollide( temp, 2, makecol(255,0,255), 30.0 );
	destroy_bitmap( temp );

}


WeaponObject * WeaponTractorBeam::copy() {
	return new WeaponTractorBeam( strength, dir, alignment );
}


WeaponTractorBeam::~WeaponTractorBeam() {
	delete collide;
}


void WeaponTractorBeam::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {

	if ( fight == NULL ) return;
	if ( fight->empty() ) {
		look = NULL;
		return;
	}

	SpaceObject * gay = new SpaceObject(0,0,0,0,NULL,NULL,PLANE_AIR|PLANE_GROUND, alignment );
	bool cy = false;

	for ( vector< SpaceObject * >::iterator it = fight->begin(); it != fight->end(); it++ )
		if ( (*it)->CanbeHit( gay ) ) cy = true;

	if ( !cy ) {
		look = NULL;
		delete gay;
		return;
	}

	shot_counter = 0;

	vector< SpaceObject * >::iterator find_next = fight->begin();

	cy = true;
	if ( look != NULL ) {
		for ( vector< SpaceObject * >::iterator it = fight->begin();
		it != fight->end(); ) {
			if ( look == (*it) ) {
				cy = false;
				it = fight->end();
			} else it++;
		}
	}
	if ( cy ) look = NULL;
	else {
		if ( look->actualx>640||look->actualx<0||look->actualy>480||
			look->actualy<0 )
			cy = true;
		if ( !look->CanbeHit( gay ) )
			cy = true;
	}

	if ( cy ) {

		look = *find_next;
		while ( !look->CanbeHit( gay ) ) {

			find_next++;
			if ( find_next == fight->end() ) find_next = fight->begin();
			look = *find_next;

		}
		find_next++;
		if ( find_next == fight->end() ) find_next = fight->begin();

	}

	int r, g, b;
	int h = ( (strength + 2 ) * 50 ) % 360;
	hsv_to_rgb( (float)h, 1.0, 1.0, &r, &g, &b );

	SpaceObject * choose = look;
	if ( choose != NULL ) {

		int d = dist( x, y, choose->actualx, choose->actualy );

		int fx, fy;
		fx = choose->actualx;
		fy = choose->actualy;
		int ang = gang( x, y, fx, fy );

		for ( int s = 0; s < d; s += 5 ) {
			int qx = (int)( (double)x + tcos[ang]*(double)s );
			int qy = (int)( (double)y + tsine[ang]*(double)s );
			Ammo->push_back(new Damage_Weapon(qx,qy,0,0,1, new Tractor_WHull(strength*2+1, makecol(r,g,b), collide->copy() ),alignment ) );
		}

	}
	delete gay;

}
