#include "allegro.h"
#include "defs.h"
#include "hull_weapon.h"
#include "hull_weapon_chain.h"
#include "spaceobj.h"
#include "trigtable.h"
#include "ebox.h"
#include "rafkill.h"

Chain_WHull::Chain_WHull( BITMAP * _pics, int str, int power, int ang, int len, ECollide * ec ):
HullWeapon( 0, 1, str ) {

	Bitmap = _pics;

	life = 1;
	strength = power/5;
	angle = ang;
	length = len;
	collide = ec;

}


Chain_WHull::~Chain_WHull() {
	delete collide;
}


void Chain_WHull::Draw( BITMAP * who, int x, int y ) {
	if ( Bitmap == NULL ) return;

	#define max_link 9
	for (int q = 0; q < max_link; q++ ) {

		double ds = (double)length / max_link;
		double fn = ds * (double)q;

		double lx = x+tcos[angle]*fn;
		double ly = y+tsine[angle]*fn;

		draw_sprite( who, (BITMAP *)global_data[CHAIN_LINK_CIRCLE].dat,(int)lx,(int)ly);
		lx += tcos[angle]*ds/2.0;
		ly += tsine[angle]*ds/2.0;

		fixed fang = itofix( (360-(90+angle)%360) * 256 / 360 );
		rotate_sprite( who, (BITMAP *)global_data[CHAIN_LINK_LINK].dat,(int)lx,(int)ly,fang);

	}
	#undef max_link

	HullObject::Draw( who, x, y );
}
