#include "menu.h"
#include "spaceobj.h"
#include "game.h"
#include "trigtable.h"
#include "allegro.h"
#include "strings.h"
#include <string.h>
#include <stdio.h>
#include "defs.h"
#include "ebox.h"
#include "rafkill.h"
#include "sound.h"
#include "rmenu.h"
#include "hull.h"
#include "wormhole.h"
#include "explode.h"
#include <aldumb.h>

#include "hull_player.h"
#include "playerobj.h"
#include "gun_machine.h"

#define RAPTOR_TITLE_COLOR (makecol(244,228,7))

void inc_speed_counter() {
	speed_counter++;
}


END_OF_FUNCTION( inc_speed_counter );

void init( int GFX, int GAME_SPEED ) {

	set_trig();
	allegro_init();
	/*
	#ifdef UNIX
	srandom( time( NULL ) );
	#else
	srand( time( NULL ) );
	#endif
	*/
	srand( time( NULL ) );
	install_timer();
	install_keyboard();

	/*
	if ( get_desktop_resolution(&screen_x,&screen_y) == -1 ){
		screen_x = 640;
		screen_y = 480;
	}
	*/

	set_color_depth( 16 );
	if ( set_gfx_mode( GFX, GRAPHICS_X, GRAPHICS_Y, 0, 0 ) != 0 )
	if ( set_gfx_mode( GFX_AUTODETECT, GRAPHICS_X, GRAPHICS_Y, 0, 0 ) != 0 ) {
		exit( 1 );
	}
	text_mode( -1 );
	//reserve_voices (8, -1);
	set_volume_per_voice( 0 );
	install_sound( DIGI_AUTODETECT, MIDI_NONE, "" );
	atexit( &dumb_exit );
	dumb_register_packfiles();

	LOCK_VARIABLE( speed_counter );
	LOCK_FUNCTION( (void *)inc_speed_counter );
	install_int_ex( inc_speed_counter, MSEC_TO_TIMER( GAME_SPEED ) );
	explColor();
	set_trans_blender( 0, 0, 0, 128 );
	//set_config_int( "sound", "quality", 2 );
	get_config_int( "sound", "quality", 2 );
	sound_vol = 1.0;			  //max volume to begin with
	music_vol = 0.50;
	dumb_resampling_quality = get_config_int( "sound", "dumb_resampling_quality", 1 );

}


void credits() {
	printf("Exiting normally..\n");
	printf("-------\n");
	printf("Credits\n");
	printf("Programming: Jon Rafkind\n");
	printf("Graphics: Jon Rafkind and Elton Fry\n");
	printf("Sound: Jon Rafkind\n");
	printf("Gameplay: Jon Rafkind\n");
	printf("Concept and design: Jon Rafkind\n");
	printf("Almost all ideas stolen from other games, including idea to steal in the first place.\n");
	printf("Made with the Allegro graphics library by Shawn Hargreaves\n");
	printf("Email Jon at: workmin@ccs.neu.edu\n");
}


void do_credits( AL_DUH_PLAYER * who ) {

	BITMAP * work = create_bitmap( GRAPHICS_X, GRAPHICS_Y );
	clear( work );

	int y_begin = GRAPHICS_Y-20;
	char ** creds = new char*[6];
	creds[0] = "Rafkill";
	creds[1] = "Programming Jon Rafkind";
	creds[2] = "Design Jon Rafkind";
	creds[3] = "Art Jon Rafkind";
	creds[4] = "Art Elton Fry";
	creds[5] = "Sound Jon Rafkind";

	int * shade = new int[60];
	#define RCOLOR (127+rnd(127))
	shade[0] = makecol(RCOLOR,RCOLOR,RCOLOR);
	for ( int q = 0; q < 4; q++ )
		blend_palette( shade+q*12+1, 12, shade[q*12],
			makecol(RCOLOR,RCOLOR,RCOLOR) );
	blend_palette( shade+48, 12, shade[48], shade[0] );
	int color = 0;
	int shade_color = 0;

	WormHole wole;
	for ( int q = 0; q < 40; q++ )
		wole.Update();

	while ( !key[KEY_SPACE] && !key[KEY_ESC] ) {

		bool yay = false;
		while ( speed_counter > 0 ) {
			yay = true;
			if ( y_begin > 100 ) y_begin-=2;
			if ( y_begin > 100 ) {
				y_begin-=2;
				color = makecol(255,255,255);
			}
			else {
				color = shade[ shade_color ];
				shade_color++;
				if ( shade_color > 59 ) shade_color = 0;
			}

			wole.Update();

			speed_counter--;
		}
		if ( yay ) {
			wole.Draw( work );

			for ( int q = 0; q < 6; q++ )
				raptor_font->rtext(work,100,y_begin+q*30,color,creds[q]);
			blit( work, screen, 0, 0, 0, 0, GRAPHICS_X, GRAPHICS_Y );
			clear( work );
		}
		if ( speed_counter == 0 ) YIELD();
		al_poll_duh( who );

	}
	while ( key[KEY_SPACE] );
	destroy_bitmap( work );
	delete[] creds;
	delete[] shade;

}


BITMAP * get_help_screen() {

	BITMAP * work = create_bitmap( 640, 480 );
	clear_to_color( work, makecol(0,12,19) );
	//int cy = 10;
	/*
	textprintf(work,font,10,cy,makecol(255,255,255),"How to play Raptor" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Main Menu Options" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Continue: Continue playing an already started game" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Play New: Play a new game" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Options: More Options" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Help: This screen" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Credits: The credits! What else?" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Quit: Quit the game" );cy+=10;
	cy += 10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Options Menu" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Frame Rate: Frame Rate Menu" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Fullscreen: Fullscreen Mode" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"Background on/off: Turn the background on or off" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	textprintf(work,font,10,cy,makecol(255,255,255),"" );cy+=10;
	*/

	return work;

}


int intro_screen( int & frames, int window_mode, bool & dl, SpaceObject ** player, DATAFILE * sound, AL_DUH_PLAYER * dumb_player ) {

	//RGB * crap = new RGB[256];
	char * file_name_pcx = data_file( "logosmoot.pcx" );
	BITMAP * intr = load_bitmap( file_name_pcx, NULL );
	free( file_name_pcx );
	//delete[] crap;
	if ( !intr ) {
		printf("Supreme error with bitmap intr\n");
		return 3;
	}

	/*
	DUH * dumb_file = NULL;
	AL_DUH_PLAYER * dumb_player = NULL;
	char * d_file = data_file( "intro.mod" );
	dumb_file = dumb_load_mod( d_file );
	free( d_file );
	dumb_player = al_start_duh( dumb_file, 2, 0, music_vol, 4096, 22050 );
	*/

	#define INIT_CONTINUE 0
	#define INIT_PLAY 1
	#define INIT_OPT 2
	#define INIT_QUIT 3
	#define INIT_CREDITS 4
	#define INIT_BACK 6
	#define INIT_SAVE 7
	#define INIT_LOAD 8
	#define INC_RATE 10
	#define DEC_RATE 11
	#define INIT_HELP 12
	#define INIT_SCREEN_FULL 13
	#define INIT_SCREEN_WINDOW 14
	#define SOUND_INC 15
	#define SOUND_DEC 16
	#define MUSIC_INC 17
	#define MUSIC_DEC 18
	#define DIFFICULT_MENU 1000

	SAMPLE * select_smp = (SAMPLE *)sound[ INTRO_MENU_SELECT ].dat;

	RMenu * intro_menu = new RMenu( intr, 170, 240, makecol(120,0,0),makecol(255,0,0), RAPTOR_TITLE_COLOR);
	RMenu * option_menu = new RMenu( intr, 1, 120, makecol(120,0,0),makecol(255,0,0), RAPTOR_TITLE_COLOR );
	RMenu * frame_menu = new RMenu( intr, 1, 230, makecol(120,0,0),makecol(255,0,0), RAPTOR_TITLE_COLOR );
	RMenu * difficulty_menu = new RMenu( intr, 1, 210, makecol(120,0,0),makecol(255,0,0), RAPTOR_TITLE_COLOR );
	RMenu * sound_menu = new RMenu( intr, 1, 145, makecol(120,0,0), makecol(255,0,0), RAPTOR_TITLE_COLOR );

	if ( *player != NULL )
		intro_menu->addMenu( strdup("Continue"),raptor_font,true,INIT_CONTINUE,NULL,select_smp);
	intro_menu->addMenu( strdup("Play new"),raptor_font,true,INIT_PLAY,NULL,select_smp);
	intro_menu->addMenu( strdup("Options"),raptor_font,true,INIT_OPT,option_menu,select_smp);
	intro_menu->addMenu( strdup("Credits"),raptor_font,true,INIT_CREDITS,intro_menu,select_smp);
	intro_menu->addMenu( strdup("Quit"),raptor_font,true,INIT_QUIT,NULL,select_smp);

	option_menu->addTitle( strdup("Options"),raptor_font );
	char * numnum = int2str( frames );
	option_menu->addMenu( append("Frame rate ",numnum),raptor_font,true,244,frame_menu,select_smp);
	//if ( window_mode == GFX_AUTODETECT )
	//	option_menu->addMenu( strdup("Windowed"),raptor_font,true,INIT_SCREEN,option_menu,select_smp);
	//else    option_menu->addMenu( strdup("Fullscreen"),raptor_font,true,INIT_SCREEN,option_menu,select_smp);
	option_menu->addMenu( strdup("Windowed"),raptor_font,true,INIT_SCREEN_WINDOW,option_menu,select_smp);
	option_menu->addMenu( strdup("Fullscreen"),raptor_font,true,INIT_SCREEN_FULL,option_menu,select_smp);
	if ( dl )
		option_menu->addMenu( strdup("Background on"),raptor_font,true,INIT_BACK,option_menu,select_smp);
	else    option_menu->addMenu( strdup("Background off"),raptor_font,true,INIT_BACK,option_menu,select_smp);
	option_menu->addMenu( strdup("Sound"), raptor_font, true, 800, sound_menu, select_smp );
	option_menu->addMenu( strdup("Return to Menu"),raptor_font,true,800,NULL,select_smp);

	frame_menu->addTitle( append("Frame Rate ",numnum),raptor_font );
	//frame_menu->addTitle( strdup("Frame Rate is Unstable"),raptor_font );
	frame_menu->addMenu( strdup("Increase Rate"),raptor_font,true,INC_RATE,frame_menu,select_smp);
	frame_menu->addMenu( strdup("Decrease Rate"),raptor_font,true,DEC_RATE,frame_menu,select_smp);
	frame_menu->addMenu( strdup("Return to options"),raptor_font,true,800,NULL,select_smp);

	char * sound_num = int2str( (int)(sound_vol * 100 ) );
	char * music_num = int2str( (int)(music_vol * 100 ) );
	sound_menu->addTitle( append("Sound volume ", sound_num ), raptor_font );
	sound_menu->addMenu( strdup("Increase sound volume"), raptor_font, true, SOUND_INC, sound_menu, select_smp );
	sound_menu->addMenu( strdup("Decrease sound volume"), raptor_font, true, SOUND_DEC, sound_menu, select_smp );
	sound_menu->addTitle( append("Music volume ", music_num ), raptor_font );
	sound_menu->addMenu( strdup("Increase music volume"), raptor_font, true, MUSIC_INC, sound_menu, select_smp );
	sound_menu->addMenu( strdup("Decrease music volume"), raptor_font, true, MUSIC_DEC, sound_menu, select_smp );
	sound_menu->addMenu( strdup("Return to options"),raptor_font,true,800,NULL,select_smp);

	difficulty_menu->addTitle( strdup("Difficulty"), raptor_font );
	difficulty_menu->addMenu( strdup("Very Easy"), raptor_font, true, DIFFICULT_MENU+1, NULL, select_smp );
	difficulty_menu->addMenu( strdup("Easy"), raptor_font, true, DIFFICULT_MENU+2, NULL, select_smp );
	difficulty_menu->addMenu( strdup("Medium"), raptor_font, true, DIFFICULT_MENU+3, NULL, select_smp );
	difficulty_menu->addMenu( strdup("Hard"), raptor_font, true, DIFFICULT_MENU+4, NULL, select_smp );
	difficulty_menu->addMenu( strdup("Impossible"), raptor_font, true, DIFFICULT_MENU+5, NULL, select_smp );

	RMenu * current = intro_menu;
	RMenu * temp = current;
	current->init();

	int g = -1;
	while ( g != INIT_QUIT && g != INIT_CONTINUE && g != INIT_PLAY ) {
		YIELD();
		al_poll_duh( dumb_player );

		temp = current;
		g = current->procMenu( &current );
		if ( !temp->Selected() ) g = -1;

		bool changed_frames = false;
		bool changed_sound = false;
		bool changed_music = false;
		switch ( g ) {
			case INC_RATE   : {
				frames++;
				changed_frames = true;
				break;
			}
			case DEC_RATE   : {
				if( frames > 1 ) {
					frames--;
					changed_frames = true;
				}
				break;
			}
			case SOUND_INC  : {
				sound_vol += 0.02;
				if ( sound_vol > 1.0 ) sound_vol = 1.0;
				changed_sound = true;
				break;
			}
			case SOUND_DEC  : {
				sound_vol -= 0.02;
				if ( sound_vol < 0 ) sound_vol = 0;
				changed_sound = true;
				break;
			}
			case MUSIC_INC  : {
				music_vol += 0.02;
				if ( music_vol > 1.0 ) music_vol = 1.0;
				changed_music = true;
				break;
			}
			case MUSIC_DEC  : {
				music_vol -= 0.02;
				if ( music_vol < 0 ) music_vol = 0;
				changed_music = true;
				break;
			}
			case INIT_CREDITS       : {
				do_credits( dumb_player );
				break;
			}
						  /*
			case INIT_SCREEN        : {
			if ( window_mode == GFX_AUTODETECT_FULLSCREEN )
			window_mode = GFX_AUTODETECT_WINDOWED;
			else    window_mode = GFX_AUTODETECT_FULLSCREEN;
			if ( window_mode == GFX_AUTODETECT_WINDOWED )
			option_menu->replace( 3, strdup("Windowed"), raptor_font,true, INIT_SCREEN, option_menu, select_smp  );
			else    option_menu->replace( 3, strdup("Fullscreen"), raptor_font,true, INIT_SCREEN, option_menu, select_smp );
			printf("Setting gfx mode to %d - Status ",window_mode);
			int cap = set_gfx_mode( window_mode, GRAPHICS_X, GRAPHICS_Y, 0, 0 );
			printf("%d\n",cap );
			if ( cap == -1 ) {
			printf("Allegro error: %s\n", allegro_error );
			set_gfx_mode(GFX_AUTODETECT,GRAPHICS_X,GRAPHICS_Y,0,0);
			option_menu->replace(3,strdup("Error with gfx set"), raptor_font,false, INIT_SCREEN, option_menu, select_smp );
			}

			break;
			}
			*/
			case INIT_SCREEN_FULL   : {
				set_gfx_mode( GFX_AUTODETECT_FULLSCREEN, GRAPHICS_X, GRAPHICS_Y, 0, 0 );
				break;
			}
			case INIT_SCREEN_WINDOW : {
				set_gfx_mode( GFX_AUTODETECT_WINDOWED, GRAPHICS_X, GRAPHICS_Y, 0, 0 );
				break;
			}
			case INIT_BACK          : {
				if ( dl ) dl = false;else dl=true;
				if ( dl ) option_menu->replace( 5, strdup("Background ON"), raptor_font,true, INIT_BACK, option_menu, select_smp ); else
					option_menu->replace( 5, strdup("Background off"), raptor_font,true, INIT_BACK, option_menu, select_smp );
				break;
			}

		}

		if ( changed_frames ) {
			free( numnum );
			numnum = int2str( frames );
			option_menu->replaceTitle( 2, append("Frame Rate ",numnum), raptor_font );
			frame_menu->replaceTitle( 1, append("Frame Rate ",numnum), raptor_font );
			install_int_ex( inc_speed_counter, MSEC_TO_TIMER( frames ) );
		}

		if ( changed_sound ) {
			free( sound_num );
			sound_num = int2str( (int)(sound_vol * 100 ) );
			sound_menu->replaceTitle( 1, append("Sound volume ", sound_num ), raptor_font );
		}

		if ( changed_music ) {
			free( music_num );
			music_num = int2str( (int)(music_vol * 100 ) );
			sound_menu->replaceTitle( 4, append("Music volume ", music_num ), raptor_font );
			al_duh_set_volume( dumb_player, music_vol );
		}

	}

	if ( g == INIT_PLAY ) {

		if ( *player != NULL )
			delete *player;
		current = difficulty_menu;
		current->init();
		int v = 0;
		while ( !current->Selected() ) {
			v = current->procMenu( &current );
			al_poll_duh( dumb_player );
			YIELD();
		}
		int difficulty = v - DIFFICULT_MENU;
		BITMAP ** pics = new BITMAP*[ 9 ];
		for ( int q = 0; q < 9; q++ )
			pics[q] = (BITMAP *)global_data[HULL_1_1+q].dat;
		HullObject * hwho = new PlayerHull( pics, 9, 100, 100, 3, 1, new ECollide( pics[4], 6, makecol(255,0,255), 52 ) );
		*player = new PlayerObject(320,450, difficulty, hwho );
		WeaponObject * wwho = new WeaponMachineGun( 0, -1, NULL, TEAM_PLAYER );
		(*player)->giveWeapon( wwho, 0 );
		( ((PlayerObject *) (*player) ) )->level = 1;
		if ( difficulty == 1 )
			screen_x = 640;
		else    screen_x = 640*3/2;

	}

	//al_stop_duh( dumb_player );
	//unload_duh( dumb_file );

	delete intro_menu;
	delete option_menu;
	delete frame_menu;
	delete difficulty_menu;
	delete sound_menu;
	free( numnum );
	free( sound_num );
	free( music_num );

	destroy_bitmap( intr );

	return g;

	#undef INC_RATE
	#undef DEC_RATE

}


char * get_os( int g ) {
	switch( g ) {
		case OSTYPE_UNKNOWN     :       return "unknown, or regular MSDOS";
		case OSTYPE_WIN3        :       return "Windows 3.1 or earlier";
		case OSTYPE_WIN95       :       return "Windows 95";
		case OSTYPE_WIN98       :       return "Windows 98";
		case OSTYPE_WINME       :       return "Windows ME";
		case OSTYPE_WINNT       :       return "Windows NT";
		case OSTYPE_WIN2000     :       return "Windows 2000";
		case OSTYPE_WINXP       :       return "Windows XP";
		case OSTYPE_OS2         :       return "OS/2";
		case OSTYPE_WARP        :       return "OS/2 Warp 3";
		case OSTYPE_DOSEMU      :       return "Linux DOSEMU";
		case OSTYPE_OPENDOS     :       return "Caldera OpenDOS";
		case OSTYPE_LINUX       :       return "Linux";
		case OSTYPE_FREEBSD     :       return "FreeBSD";
		case OSTYPE_UNIX        :       return "Unknown Unix variant";
		case OSTYPE_BEOS        :       return "BeOS";
		case OSTYPE_QNX         :       return "QNX";
		case OSTYPE_MACOS       :       return "MacOS";
	}
	return "Unknown OS";
}


//******************************MAIN**************************
int main( int argc, char ** argv ) {

	int window = GFX_AUTODETECT_FULLSCREEN;
	bool dl = true;
	int gs = 40;

	printf("rafkill -h for help screen\n");
	for ( int q = 1; q < argc; q++ ) {
		if ( strcmp( argv[q], "-h" ) == 0 ||
			strcmp( argv[q], "-help" ) == 0 ||
		strcmp( argv[q], "--help" ) == 0 ) {
			printf("OPTIONS\n");
			printf("------\n");
			printf("-w\t\t\tWindowed Mode\n");
			printf("-l\t\t\tNo background\n");
			printf("-g#\t\t\tRun game at # msec per tick\n");
			printf("-h -help --help\t\tThis Help Screen\n");
			return 1;
		}
		if ( strcmp( argv[q], "-w" ) == 0 )
			window = GFX_AUTODETECT_WINDOWED;
		else
		if ( strcmp( argv[q], "-l" ) == 0 )
			dl = false;
		else
		if ( strlen( argv[q] ) > 2 )
			if ( argv[q][1] == 'g' )
				gs = atoi( &argv[q][2] );

	}

	if ( gs <= 0 ) gs = 40;
	printf("Running game at %d\n", gs );
	printf("Using mode %d\n", window );
	init( window, gs );
	printf("OS %s\n", get_os(os_type) );

	char * file_name_data = data_file( "rafkill.dat" );
	char * file_name_sound = data_file( "sound.dat" );
	char * file_name_font = data_file( "beast.fnt" );

	//DATAFILE * data = load_datafile( file_name_data );
	global_data = load_datafile( file_name_data );
	DATAFILE * snd = load_datafile( file_name_sound );
	raptor_font = new RFont( file_name_font );

	printf("Loaded data\n");

	free( file_name_data );
	free( file_name_sound );
	free( file_name_font );

	if ( !global_data || !snd ) {
		printf("Error with data!\n");
		return 1;
	}

	DUH * dumb_file = NULL;
	AL_DUH_PLAYER * dumb_player = NULL;
	char * d_file = data_file( "intro.mod" );
	dumb_file = dumb_load_mod( d_file );
	free( d_file );
	dumb_player = al_start_duh( dumb_file, 2, 0, music_vol, 4096, 22050 );

	SpaceObject * player;
	GameRunnable * Game = NULL;
	menuClass menu;

	//player = new PlayerObject(320,450, 1, HullObject( NULL, 1, 1, 1, 1, 1, false, NULL ) );
	player = NULL;

	printf("***\n");
	bool quit;
	int real_level = 1;
	int geti;
	while ( (geti = intro_screen( gs, window, dl, &player, snd, dumb_player ) ) != INIT_QUIT ) {
		quit = geti == INIT_QUIT;
		while ( !quit ) {

			if ( !quit && geti != INIT_CONTINUE ) {
				char * numnum = int2str( ((PlayerObject *)player)->level);
				char * f1 = append("level",numnum);
				char * file_level = append( f1,".lev" );
				free( numnum );
				free( f1 );

				//HullObject * reserve = player->hull->copy();
				al_pause_duh( dumb_player );
				Game = new GameRunnable( dl,snd,file_level, player );

				free( file_level );
				player->SetCoordXY( screen_x/2, screen_y - 40 );

				int game_error = Game->RunGame( player, real_level );

				delete Game;
				if ( ( (PlayerObject *)player)->level == 1 ) real_level++;

				switch( game_error ) {
					case 0  :       ( (PlayerObject *)player)->level++;break;
					case 1  : {

						//player->giveHull( reserve );

						int tx = text_length(font,"YOU DIED");
						int ty = 10;
						BITMAP * text = create_bitmap( tx, ty );
						clear( text );
						textprintf( text, font, 0, 0, makecol(255,255,255), "YOU DIED");
						BITMAP * work = create_bitmap( GRAPHICS_X, GRAPHICS_Y );

						int _max_ex = 500;
						last_explode = 0;
						ExplosionClass ** expl = new ExplosionClass*[ _max_ex ];
						for ( int q = 0; q < _max_ex; q++ )
							expl[q] = NULL;

						if ( key[KEY_SPACE] )
							while ( key[KEY_SPACE] );
						if ( key[KEY_ENTER] )
							while ( key[KEY_ENTER] );

						while ( !key[KEY_SPACE] && !key[KEY_ENTER] ) {

							bool dirty = false;
							while ( speed_counter ) {

								dirty = true;

								for ( int q = 0; q < 300; q++ ) {
									int x = rnd( tx );
									int y = rnd( ty );
									double ymove = ((double)y - (double)(ty-1) / 2.0) * 1.54;
									if ( getpixel( text, x, y ) == makecol(255,255,255) )
										addExplode( expl, _max_ex, new ExplosionClass( x*9 + 50, y*9 + 200, 0, ymove, rnd( 3 ) + 7 ) );
								}

								for ( int q = 0; q < _max_ex; q++ )
									if( expl[q] != NULL )
									if ( expl[q]->update() ) {
										delete expl[q];
									expl[q] = NULL;
								}
								speed_counter--;
							}

							if ( dirty ) {
								for ( int q = 0; q < _max_ex; q++ )
									if ( expl[q] != NULL )
										expl[q]->Draw( work, 0 );

								blit( work, screen, 0, 0, 0, 0, GRAPHICS_X, GRAPHICS_Y );
								clear( work );
							}
						}

						for ( int q = 0; q < _max_ex; q++ )
							if ( expl[q] )
								delete expl[q];
						delete[] expl;

						destroy_bitmap( text );
						destroy_bitmap( work );

						while ( key[KEY_SPACE] );
						while ( key[KEY_ENTER] );

						break;
					}
					case 2  : {
						( (PlayerObject *)player)->level = 1;
						break;
					}
					case 3  : {
						quit = true;
						break;
					}
					case 4  : {
						break;

					}
				}		  //switch
				//if ( game_error != 1 ) delete reserve;
			}			  //if

			geti = INIT_PLAY;
			al_resume_duh( dumb_player );
			quit = menu.activate( player, dumb_player );

		}				  //while !quit

	}					  //while key[KEY_ESC]

	if ( player ) delete player;
	printf("Unloading data\n");
	unload_datafile( global_data );
	unload_datafile( snd );
	delete raptor_font;

	al_stop_duh( dumb_player );
	unload_duh( dumb_file );

	credits();

	return 0;
}


END_OF_MAIN();
