#include "allegro.h"
#include "shipobj.h"
#include "hull.h"
#include "rafkill.h"
#include "trigtable.h"
#include "explode.h"
//#include "explode_slim.h"
#include "explode_animate.h"
#include "gunobj.h"
#include "sound.h"
#include "move.h"
#include "defs.h"
#include "strings.h"
#include "booster.h"
#include "section.h"

#include "hull_num_show.h"
#include "hull_player.h"

#include <stdio.h>

//{
ShipObject::ShipObject( int qx, int qy, int spc, HullObject * hnew, Group * _group, Move * movey, int al ):
SpaceObject(qx,qy,0,0,hnew, _group, PLANE_AIR, al ),
special( spc ) {
	style = movey;
	if ( style != NULL ) style->setP( actualx, actualy,
			virtualx, virtualy );
}


void ShipObject::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * snd ) {
	if ( check != NULL )
		check->IncScore( special + (int)(hull->original_life * 10) );
	this->Explode( explr, ME );
	play_sound( snd, 1, 180 );
}


bool ShipObject::powerUp() {
	return true;
}


double ShipObject::Hurt() {
	if ( getLife() >= hull->Hurt() ) return hull->Hurt();
	if ( getLife() > 0 ) return getLife();
	return 1;
}


double ShipObject::DX() {
	if ( style != NULL )
		return style->DX();
	return dx;
}


double ShipObject::DY() {
	if ( style != NULL )
		return style->DY();
	return dy;
}

double ShipObject::AccelX(){
	if ( style != NULL )
		return style->Accel_X();
	return accel_x;
}

double ShipObject::AccelY(){
	if ( style != NULL )
		return style->Accel_Y();
	return accel_y;
}

bool ShipObject::MoveMe( vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight, Section * onscreen, DATAFILE * snd ) {
	if ( style != NULL )
		if ( style->action( fight ) )
			return true;

	if ( hull ) hull->Moved( this->DX(), this->DY(), this->AccelX(), this->AccelY() );
	if ( hull ) hull->addSection( this, onscreen, actualx, actualy );

	if ( actualy > -10 ) {

		WeaponObject ** myGun = hull->Guns();
		if ( myGun != NULL ) {
			for ( int q = 0; q < hull->maxGuns(); q++ )
				if ( myGun[q] != NULL )
					if ( myGun[q]->shot_counter > 0 )
						myGun[q]->shot_counter--;
			else myGun[q]->MakeShot( actualx, actualy, Ammo, fight );

		}
	}
	return false;
}


void ShipObject::Explode( ExplosionClass ** explr, int ME ) {
	ExplosionClass * w_expl = new ExplosionAnimate( actualx, actualy, this->DX()/2, this->DY()/2, EXPLODE_1, EXPLODE_A_30 );
	addExplode( explr, ME, w_expl );
}


ShipObject::~ShipObject() {
	if ( style != NULL ) delete style;
}


//}
//{
MeteorObject::MeteorObject( int qx, int qy, int spc, HullObject * hnew, Move * hmove ):
ShipObject( qx, qy, spc, hnew, NULL, hmove, TEAM_ENEMY ){}

void MeteorObject::Explode( ExplosionClass ** explr, int ME ) {
	ExplosionClass * w_expl = new ExplosionAnimate( actualx, actualy, this->DX()/2, this->DY()/2, GR_EXPLODE_01, GR_EXPLODE_29 );
	addExplode( explr, ME, w_expl );
}


//{

//}
//{
EnemyGeneric::EnemyGeneric( int qx, int qy, HullObject * hnew, WeaponObject * myW, Move * movey, Group * _group ):
ShipObject(qx,qy,100,hnew, _group, movey,TEAM_ENEMY) {
	//WeaponObject ** myGun = hull->Guns();
	//if ( myGun != NULL )
	//	myGun[0] = myW;
	hull->giveWeapon( myW, 0 );
}


void EnemyGeneric::Radar( BITMAP * rad ) {
	//putpixel( rad, (int)( (float)actualx / ( (float)screen_x / (float)rad->w  ) ), (int)( (float)actualy / ( (float)screen_y / (float)rad->h  ) ), makecol(200,100,0) );
	circlefill( rad, (int)( (float)actualx / ( (float)screen_x / (float)rad->w  ) ), (int)( (float)actualy / ( (float)screen_y / (float)rad->h  ) ), 1, makecol(200,100,0) );

}


//}
//{
Money::Money( int qx, int qy, int m, HullObject * hnew, Move * movey ):
PowerUp( qx, qy, hnew, movey ) {
	str = 0;
	special = m;
}


void Money::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * snd ) {
	if ( check != NULL )
		check->IncScore( special );
	play_sound( snd, POWER, 255 );
}


bool Money::Damage( double much ) {
	delete hull;
	hull = new HullShow( special );
	style->setD( 0, 0 );
	return true;
}


//}
//{
PowerUp::PowerUp( int qx, int qy, HullObject * hnew, Move * movey ):
ShipObject( qx, qy, 0, hnew, NULL, movey,TEAM_ENEMY ) {
	str = 0;
}


void PowerUp::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * snd ) {
	if ( check != NULL ) {

		/*
		WeaponObject ** gz = check->hull->Guns();
		if ( pcount( (char **)gz, check->hull->maxGuns()-1 ) == 0 ) return;
		int q = rnd( check->hull->maxGuns()-1 );
		while ( gz[q] == NULL ) q = rnd(check->hull->maxGuns()-1);
		gz[q]->IncreasePower( 1 );
		*/
		WeaponObject ** gz = new WeaponObject*[ check->hull->maxGuns() - 1 ];
		for ( int q = 0; q < check->hull->maxGuns()-1; q++ ) {
			gz[q] = NULL;
			if ( check->hull->Guns()[q] != NULL && (check->hull->Guns()[q]->strength < check->hull->Guns()[q]->maxPower() || check->hull->Guns()[q]->maxPower() == -1) )
				gz[q] = check->hull->Guns()[q];
		}
		int q = rnd( check->hull->maxGuns()-1 );
		if ( pcount( (char **)gz, check->hull->maxGuns()-1 ) == 0 ) {
			delete[] gz;
			return;
		}
		while ( gz[q] == NULL ) q = rnd( check->hull->maxGuns()-1 );
		gz[q]->IncreasePower( 1 );

	}
	play_sound( snd, POWER, 255 );
}


bool PowerUp::Damage( double much ) {
	hull->takeDamage( getLife()+1 );
	return true;
}


void PowerUp::Radar( BITMAP * rad ) {
}


bool PowerUp::needSpecial() {
	return true;
}


bool PowerUp::powerUp() {
	return false;
}


//}
Health::Health( int qx, int qy, HullObject * hnew, Move * movey ):
PowerUp( qx, qy, hnew, movey ) {
}


void Health::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * snd ) {
	if ( check != NULL ) {

		check->hull->life += 20;
		if ( check->hull->life > ((PlayerHull *)check->hull)->max(0) )
			check->hull->life = ((PlayerHull *)check->hull)->max(0);

	}
	play_sound( snd, POWER, 255 );
}


Cloak::Cloak( int qx, int qy, HullObject * hnew, Move * movey ):
PowerUp( qx, qy, hnew, movey ) {
}


void Cloak::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * snd ) {
	if ( check != NULL ) {

		((PlayerHull *)check->hull)->cloak = 300;

	}
	play_sound( snd, POWER, 255 );
}
