/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: h.h,v 1.177.2.1 2004/12/07 03:04:36 pneumatus Exp $
 */

#include "send.h"
#include "ircsprintf.h"
#include "setup.h"
#include "msg.h"

struct _user_ban;

extern char *crypt();
extern int base64_encode(const char *, size_t, char *, size_t);
extern int base64_decode(const char *, char *, size_t);

extern void connauth_init();
extern void connauth_init_client(aClient *);
extern void connauth_delete_queries(aClient *);

extern void init_masking_keys();
extern char *maskme(aClient *);

extern char *get_listener_name(Listener *);
extern char *get_listener_flags(Listener *);
extern void open_listeners();
extern void close_listeners();
extern void close_one_listener(Listener *, dlink_node *);
extern void attach_listener(aClient *, Listener *);
extern void detach_listener(aClient *);

extern MessageFile *motd;
extern MessageFile *opermotd;
extern MessageFile *rules;

extern MessageFile *load_message_file(char *, short);
extern void destroy_message_file(MessageFile *);
extern void init_message_files();
extern void rehash_message_files();
extern void send_message_file(aClient *, MessageFile *);
extern void send_motd(aClient *);

extern int spam_num, spam_time;

extern IRCd Internal;
extern struct Counter Count;
extern aClient *client, me;
extern aChannel *channel;
extern struct stats *ircstp;

extern unsigned long get_max_rss();

extern void init_channels();
extern char *canonize(char *);
extern int check_channel_name(aClient *, char *);
extern int check_fake_channel_name(aClient *, char *);
extern aChannel *get_channel(aClient *, char *, int, int *);
extern chanMember *add_user_to_channel(aChannel *, aClient *, int);
extern chanMember *remove_user_from_channel(aClient *, aChannel *);
extern void sub1_from_channel(aChannel *);
extern int can_join(aClient *, aChannel *, char *);
extern int can_send(aClient *, aChannel *, char *);
extern void send_topic_burst(aClient *);

extern char *pretty_mask(char *);
extern void add_invite(aClient *, aChannel *);
extern void del_invite(aClient *, aChannel *);
extern aClient *find_chasing(aClient *, char *, int *, char *);

extern void init_channelbans();
extern void destroy_channelban(channelBan *);
extern int add_id(char *, aChannel *, long, aClient *);
extern int del_id(char *, aChannel *, long);
extern int is_invited(aClient *, aChannel *);
extern int is_banned(aClient * , aChannel *, chanMember *);
extern void send_ban_list(aClient *, aChannel *, dlink_list *, int, int);
extern void synch_ban_list(aClient *, aChannel *, long);
extern void kill_ban_list(aClient *, aChannel *, long);

extern void clear_scache_hash_table();
extern char *find_or_add(char *);
extern void count_scache_memory(int *, unsigned long *);
extern void list_scache(aClient *);

extern aClient *find_by_base64_id(char *);
extern aClient *find_serv_by_base64_id(char *, unsigned long *);
extern void add_userid_to_serv(aClient *, aClient *);
extern int del_userid_from_serv(aClient *, aClient *);
extern void assign_local_userid(aClient *);
extern int free_local_userid(aClient *);
extern int add_base64_serv(aClient *, char *);
extern void del_base64_serv(aClient *);
extern int init_identity(unsigned short);
extern char *base64enc(unsigned int);
extern unsigned int base64dec(char *);

extern char *get_numeric_format(int *);
extern void make_numeric_string(char *, int);

extern int errno;

extern void set_time();

extern int get_sockerr(int);
extern void report_error(int, const char *, char *);
extern int check_client(aClient *);
extern void close_connection(aClient *);
extern int serv_connect(ConfigItem_link *, aClient *);

#ifdef INCREASE_SOCK_BUFS
extern int increase_sock_bufs(int, int);
#endif
extern int set_non_blocking(int);
extern int set_sock_opts(int);
extern int unset_sock_ipopts(int);
extern void add_connection(Listener *, int);

extern void restart(char *);
extern void server_reboot();

extern int match(char *, char *);
extern int mycmp(char *, char *);
extern int myncmp(char *, char *, int);
extern int irccmp(char *, char *);
extern int ircncmp(char *, char *, int);
extern char *collapse(char *);

extern char *check_string(char *);
extern char *make_user_host(char *, char *);
extern char *make_nick_user_host(char *, char *, char *);
extern char *get_client_name(aClient *, int);
extern void target_left(aClient *, char *, char *, char *);
extern char *myctime(time_t), *date(time_t), *smalldate(time_t);
extern int exit_client_kill(aClient *, aClient *, struct _user_ban *);
extern int exit_client_zap(aClient *, aClient *, struct _user_ban *);
extern int exit_client(aClient *, aClient *, aClient *, char *);
extern void init_stats(), serv_stats(aClient *);

extern int serv_parse(aClient *, char *, char *);
extern int user_parse(aClient *, char *, char *);

extern int do_numeric(int, aClient *, aClient *, int, char **);
extern int use_or_deliver(aClient *, aClient *, msg_ptr *, char *, int, int, char **);
extern aClient *next_client(aClient *, char *);
extern aClient *next_client_double(aClient *, char *);

extern void init_clients();
extern int register_user(aClient *, aClient *, char *, char *);
extern void introduce_user(aClient *, aClient *, char *);
extern int do_user(char *, aClient *, aClient *, char *, char *, char *, unsigned long, unsigned int, char *);
extern int send_lusers(aClient *, aClient *, int, char **);
extern int add_silence(aClient *, char *);
extern int del_silence(aClient *, char *);
extern int is_silenced(aClient *, aClient *);

extern Capability cap_table[];
extern char *make_capab_list(unsigned int, int, int);
#define get_my_cap(x)		make_capab_list(x, 0, 0)
#define get_link_cap(x)		make_capab_list(x, 1, -1)
#define get_synch_cap(x)	make_capab_list(x, 1, 1)
extern void try_connections(void *);
extern int do_server_estab(aClient *);

extern void init_link();
extern aChannel *make_channel();
extern channelBan *make_channelban();
extern SLink *make_slink();
extern dlink_node *make_dlink_node();
extern chanMember *make_chanmember();
extern anUser *make_user(aClient *);
extern LocalUser *make_localuser(aClient *);
extern aServer *make_server(aClient *);
extern LocalClient *make_localclient();
extern aClient *make_client(aClient *, aClient *);
#ifdef USE_THROTTLE
extern throttle *make_throttle();
extern hashent *make_hashent();
extern void free_throttle(throttle *);
extern void free_hashent(hashent *);
#endif
extern void free_localclient(LocalClient *);
extern void free_client(aClient *);
extern void free_slink(SLink *);
extern void free_dlink_node(dlink_node *);
extern void free_chanmember(chanMember *);
extern void free_user(anUser *);
extern void free_localuser(LocalUser *);
extern void free_channel(aChannel *);
extern void free_channelban(channelBan *);
extern chanMember *find_user_member(chanMember *, aChannel *);
extern SLink *find_str_link(SLink *, char *);
extern void add_client_to_list(aClient *);
extern void remove_client_from_list(aClient *);

extern void clear_channel_hash_table();
extern void clear_client_hash_table();
extern int add_to_client_hash_table(char *, aClient *);
extern int del_from_client_hash_table(char *, aClient *);
extern int add_to_channel_hash_table(char *, aChannel *);
extern int del_from_channel_hash_table(char *, aChannel *);
extern aChannel *hash_find_channel(char *, aChannel *);
extern aClient *hash_find_client(char *, aClient *);
extern aClient *hash_find_nickserver(char *, aClient *);
extern aClient *hash_find_server(char *, aClient *);

extern void add_history(aClient *, int);
extern aClient *get_history(char *, time_t);
extern void off_history(aClient *);
extern void count_whowas_memory(int *, unsigned long *);
extern void init_whowas();

extern int serv_dopacket(aClient *, char *, int);
extern int user_dopacket(aClient *, char *, int);

extern void debug(int level, char *pattern, ...);
extern void ircdlog(unsigned int, char *, ...);
extern void build_isupport();

#ifdef DEBUGMODE
extern void send_usage(aClient *);
#endif
extern void count_memory(aClient *);

extern aChannel *hash_get_chan_bucket(int);
extern void send_list(aClient *, int);
extern int check_for_spambot(aClient *, char *);

extern void init_ip_hash();
extern IPEntry *find_or_add_ip(struct in_addr *);
extern void remove_one_ip(struct in_addr *);
extern void count_ip_hash_memory(int *, unsigned long *);
extern void list_ip_hash(aClient *);

#ifdef FLUD
extern void init_fludbot();
extern int check_for_flud(aClient *, aClient *, aChannel *);
extern void free_fluders();
extern void free_fludees();
#endif

extern Event *add_event(char *, void (*)(), void *, time_t, int);
extern Event *add_event_approx(char *, void (*)(), void *, time_t, int);
extern void del_event(Event *, dlink_node *node);
extern void del_event_byfunc(void (*)(), void *);
extern void run_events();
extern void get_next_event();
extern void set_back_events(time_t);
extern void show_events();

extern void count_watch_memory(int *, u_long *);
extern void clear_watch_hash_table();
extern int add_to_watch_hash_table(char *, aClient *);
extern int del_from_watch_hash_table(char *, aClient *);
extern int hash_check_watch(aClient *, int);
extern int hash_del_watch_list(aClient  *);
extern aWatch *hash_get_watch(char *);

extern char *strerror(int);
extern int dgets(int, char *, int);
extern char *my_itoa(int);
extern int msg_has_colour(char *);
extern time_t atime(char *);
extern char *time_to_str(time_t);
extern char *strtoken(char **, char *, char *);
extern int has_wilds(char *);
extern int in_str(char *, char);
extern int valid_server_name(char *);
extern int valid_ip_addr(char *, int);
extern int valid_email_addr(char *, int);
extern int get_port(char *);
extern void get_port_range(char *, int *, int *);
extern long get_size(char *);
extern char *get_userhost(const char *);
extern unsigned int get_option(char *, unsigned int);

extern Command *command_table[256];
extern Command *token_table[256];
extern void init_command_table();
#ifndef STATIC_MODULES
extern int check_core_commands();
#endif
extern Command *add_command(msg_ptr *, int (*)());
extern int del_command(msg_ptr *, int (*)());
extern int del_command_cmd(Command *);

#ifdef USE_THROTTLE
extern void init_throttle();
extern int throttle_force(char *);
extern int throttle_check(char *, int, time_t);
extern void throttle_timer(time_t);
extern void throttle_remove(char *);
extern void throttle_rehash();
extern void throttle_stats(aClient *);
#endif

extern void server_die();
extern void init_signal();

extern const char *inetntoa(const char *);
extern const char *inetntop(const void *, char *, unsigned int);
extern int inetpton(const char *, void *);
extern int parse_ipv4_netmask(const char *, struct in_addr *, int *);

#include "find.h"
#include "xmode.h"
