/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_capab.c,v 1.44.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_capab) = {
	"m_capab",
	"CAPAB protocol",
	6, "$Revision: 1.44.2.2 $"
};

int MOD_LOAD(m_capab)()
{
	if (register_command(&MOD_HEADER(m_capab), &CMD_CAPAB, m_capab) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_capab)()
{
	return MOD_SUCCESS;
}

/*
 * m_capab
 *	parv[0] = sender prefix
 *	parv[n] = capabilities
 */
int m_capab(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	Capability *c;
	int i;

	if ((cptr != sptr) || IsClient(sptr)) {
		return 0;
	}

	ASSERT(sptr->localClient != NULL);
	
	/* Exclude TS capability, which is set via PASS */	
	if ((sptr->localClient->capabs & ~CAP_TS)) {
		ircdlog(LOG_ERROR, "Ignoring extra capab from unknown, parc=%d", parc);
		return 0;
	}

	for (i = 1; i < parc; i++) {
		for (c = cap_table; c->flag; c++) {
			if (c->token == NULL) {
				continue;
			}
			if (!irccmp(c->token, parv[i])) {
				sptr->localClient->capabs |= c->flag;
				break;
			}
		}
	}

	if ((CapSUID(sptr) && !CapTOK1(sptr)) || (!CapSUID(sptr) && CapTOK1(sptr))) {
		return exit_client(sptr, sptr, &me, "Requires both SUID and TOK1 capability");
	}
	if (!CapSSJ3(sptr)) {
		return exit_client(sptr, sptr, &me, "Requires SSJ3 capability");
	}
	
	return 0;
}
