/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_locops.c,v 1.16.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_locops) = {
	"m_locops",
	"/LOCOPS command",
	6, "$Revision: 1.16.2.2 $"
};

int MOD_LOAD(m_locops)()
{
	if (register_command(&MOD_HEADER(m_locops), &CMD_LOCOPS, m_locops) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_locops)()
{
	return MOD_SUCCESS;
}

/*
 * m_locops
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_locops(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!IsServer(sptr) && MyConnect(sptr) && !OPHasFlag(sptr, OFLAG_LOCOPS)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "LOCOPS");
		return 0;
	}
	send_locops("from %s: %s", parv[0], parv[1]);
	return 0;
}
