/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_restart.c,v 1.29.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

static char buf[BUFSIZE];

extern void restart(char *);

Module MOD_HEADER(m_restart) = {
	"m_restart",
	"/RESTART command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_restart)()
{
	if (register_command(&MOD_HEADER(m_restart), &CMD_RESTART, m_restart) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_restart)()
{
	return MOD_SUCCESS;
}

/*
 * m_restart
 *	parv[0] = sender prefix
 *	parv[1] = password
 */
int m_restart(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!OPHasFlag(sptr, OFLAG_RESTART)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}

	ircsprintf(buf, "Server restarting by request of %s (%s@%s).", sptr->name, sptr->username,
		MaskedHost(sptr));
	ircdlog(LOG_DEFAULT, "server restarting by request of %s!%s@%s", sptr->name, sptr->username,
		MaskedHost(sptr));

	restart(buf);

	return 0;
}
