/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_svinfo.c,v 1.42.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "patchlevel.h"
#include "zlink.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_svinfo) = {
	"m_svinfo",
	"SVINFO protocol",
	6, "$Revision: 1.42.2.2 $"
};

int MOD_LOAD(m_svinfo)()
{
	if (register_command(&MOD_HEADER(m_svinfo), &CMD_SVINFO, m_svinfo) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_svinfo)()
{
	return MOD_SUCCESS;
}

/*
 * m_svinfo
 *	parv[0] = sender prefix
 *
 *	if (parc == 2)
 *		parv[1] = ZIP (compression initialisation)
 *
 *	if (parc > 2)
 *		parv[1] = TS_CURRENT
 *		parv[2] = TS_MIN
 *		parv[3] = standalone or connected to non-TS (unused)
 *		parv[4] = UTC time
 *		parv[5] = ircd codename
 *		parv[6] = masking keys 
 */
int m_svinfo(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *inpath = get_client_name(cptr, HIDE_IP);
	time_t delta, tmptime = timeofday, theirtime;

	if (!IsServer(sptr) || !MyConnect(sptr)) {
		return 0;
	}
	if (parc == 2 && !mycmp(parv[1], "ZIP")) {
		SetInputZIP(sptr);
		sptr->serv->zip_in = zip_create_input_session();

		send_gnotice("Input from %s is now compressed", inpath);
		if (ServerInfo->hub) {
			sendto_serv_msg_butone(sptr, &me, &CMD_GNOTICE, ":Input from %s is "
				"now compressed", inpath);
		}
		return ZIP_NEXT_BUFFER;
	}
	if (parc < 7) {
		send_gnotice("Link %s dropped, incorrect number of SVINFO parameters", inpath);
		return exit_client(sptr, sptr, sptr, "Incorrect number of SVINFO parameters");
	}
	if (TS_CURRENT < atoi(parv[2]) || atoi(parv[1]) < TS_MIN) {
		send_gnotice("Link %s dropped, wrong TS protocol version (%s, %s)",
			inpath, parv[1], parv[2]);
		return exit_client(sptr, sptr, sptr, "Wrong TS protocol version");
	}

	theirtime = strtol(parv[4], NULL, 10);
	delta = abs(theirtime - tmptime);

	if (delta > GeneralConfig.ts_delta_max) {
		send_gnotice("Link %s dropped, excessive TS delta (our TS=%d, their TS=%d, delta=%d)",
			inpath, tmptime, theirtime, delta);
		return exit_client(sptr, sptr, sptr, "Excessive TS delta");
	}
	if (delta > GeneralConfig.ts_delta_warn) {
		send_gnotice("Link %s has a notable TS delta (our TS=%d, their TS=%d, delta=%d)",
			inpath, tmptime, theirtime, delta);
	}

	if (GeneralConfig.no_mixed_versions && irccmp(CODENAME, parv[5])) {
		send_gnotice("Link %s dropped, incorrect server version (ours=%s, theirs=%s)",
			inpath, CODENAME, parv[5]);
		return exit_client(sptr, sptr, sptr, "Incorrect server version");
	}

	if ((*parv[6] != '0' && *(parv[6] + 1) != '\0') && irccmp(Internal.masking_keys, parv[6])) {
		send_gnotice("WARNING! Link %s has different masking keys", inpath);
	}
	return 0;
}
