/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: xmode.h,v 1.35.2.2 2004/12/07 23:54:10 pneumatus Exp $
 */

#ifndef __xmode_include__
#define __xmode_include__

#include "channel.h"

#define XMODE_TABLE_SIZE	(sizeof(long) * 8)
#define XMODE_MAP_SIZE		256

#define XMODE_ADD		1	/* + sign */
#define XMODE_NONE		0	/* no sign (yet) */
#define XMODE_DEL 		-1	/* - sign */

typedef struct _xmode xMode;
typedef struct _xmode_table xModeTable;

struct _xmode {
	unsigned char flag;
	long mode;
	Module *owner;
};

struct _xmode_table {
	xMode table[XMODE_TABLE_SIZE + 1];
	int map[XMODE_MAP_SIZE];
	int highest;
};

enum {
	XMERR_FLAG_NOTFOUND = -3,
	XMERR_FLAG_COLLISION,
	XMERR_TABLE_FULL
};

extern const char *xmode_errstr(int);
extern xModeTable *init_xmode_table();
extern void destroy_xmode_table(xModeTable *);
extern int add_xmode(xModeTable *, unsigned char, long *);
extern int del_xmode(xModeTable *, unsigned char);

#define XMODE(x)	long x = 0L

/* Extended User Modes */

#define UOPT_LOCAL	0x0000	/* Local mode only */
#define UOPT_GLOBAL	0x0001	/* Local and global mode */
#define UOPT_NEEDOPER	0x0002	/* Oper-only mode */
#define UOPT_AUTOOPER	0x0004	/* Receive on oper */
#define UOPT_SERVONLY	0x0008	/* Modes only servers can set */
#define UOPT_ONCONNECT	0x0010	/* Modes set on local-user connect */

extern xModeTable *usermodes;
extern char usermode_str[XMODE_TABLE_SIZE + 1];

extern xMode *add_user_mode(char, long *, unsigned int);
extern int del_user_mode(char, long *);
extern void init_user_mode();
extern char *get_user_modes(aClient *);
extern int do_user_mode(aClient *, aClient *, int, char **);
extern void send_umode(aClient *, aClient *, int, int, char *);
extern void send_umode_out(aClient *, aClient *, int);

extern long ALL_UMODES;
extern long SEND_UMODES;
extern long NEEDOPER_UMODES;
extern long AUTOOPER_UMODES;
extern long SERVONLY_UMODES;
extern long ONCONNECT_UMODES;

extern long UMODE_OPER;
extern long UMODE_INVISIBLE;
extern long UMODE_SNOTICE;
extern long UMODE_KNOTICE;
extern long UMODE_FNOTICE;
extern long UMODE_DNOTICE;
extern long UMODE_SPAMBOT;
extern long UMODE_DCCNOTICE;
extern long UMODE_LCLICONN;
extern long UMODE_GCLICONN;
extern long UMODE_WALLOPS;
extern long UMODE_GLOBOPS;
extern long UMODE_CHATOPS;
extern long UMODE_REGNICK;
extern long UMODE_SPYING;
extern long UMODE_SADMIN;
extern long UMODE_NETADMIN;
extern long UMODE_ADMIN;
extern long UMODE_MASKED;
extern long UMODE_PRIVACY;
extern long UMODE_DEAF;
extern long UMODE_RSTAFF;
extern long UMODE_REJNOTICES;
extern long UMODE_NORECVQTHROTTLE;
extern long UMODE_SECURE;

/* Extended Channel Modes */

typedef struct chanmode chanMode;

struct chanmode {
	/* Function to do the mode, returns STATUS */
	int (*do_mode)(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);

	/* Function to get mode flag & para */
	void (*get_mode)(aClient *, aChannel *, int, char *, int *, char *, int *);

	/* SJOIN: Function to set mode, or buffer para
	 *
	 * FIXME -- this should be split into two handlers. One to
	 * actually do the mode change, and one to handle buffering.
	 */
	void (*sjoin_domode_pbuf)(int, short change, Mode *, char *, int);

	/* SJOIN: Function to compare mode parameters, returns KEEP,EQUAL */
	int (*sjoin_cmp_para)(int, Mode *, Mode *);

	/* SJOIN: Function to synch mode parameters */
	void (*sjoin_synch_para)(int, Mode *, Mode *);

	unsigned int privs;	/* Required privilege level */
	short para;		/* Required parameter level */
	short paratype;		/* Parameter type */
};

#define CPRIV_NONE	0	/* Requires no privileges (yikes!) */
#define CPRIV_HALFOP	1	/* Requires at least +h */
#define CPRIV_CHANOP	2	/* Requires at least +o */
#define CPRIV_CHANADMIN	3	/* Requires at least +a */
#define CPRIV_ULINE	4	/* Requires at least U:lined client */
#define CPRIV_SERVER	5	/* Requires server */
#define CPRIV_SADMIN	6	/* SAMODE override */

#define CPARA_NONE	0	/* No parameters */
#define CPARA_SETONLY	1	/* Requires parameter when + only */
#define CPARA_SETUNSET	2	/* Requires parameter when + and - */

#define CPTYP_NONE	0	/* No parameter */
#define CPTYP_NORMAL	1	/* Normal parameter */
#define CPTYP_ADDRLIST	2	/* List parameter, address type */
#define CPTYP_NICKLIST	3	/* List parameter, nickname type */
#define CPTYP_USERPRIV	4	/* User privilege (nickname) */

#define CM_STAT_BOUNCE	-1	/* Mode change: bounced */
#define CM_STAT_FAILURE	0	/* Mode change: failed */
#define CM_STAT_SUCCESS	1	/* Mode change: successful */

#define CM_SJCMP_EQUAL	 0	/* SJOIN para compare: equal */
#define CM_SJCMP_KEEPOLD 1	/* SJOIN para compare: keep old */
#define CM_SJCMP_KEEPNEW 2	/* SJOIN para compare: keep new */

#define CM_ERR_NEEDMORE		0x0001	/* Mode change needs more parameters */
#define CM_ERR_NOPRIVS		0x0002	/* Mode change needs higher privileges */
#define CM_ERR_NOTIRCOP		0x0004	/* User is not IRC op */
#define CM_ERR_NOTADMIN		0x0008	/* User is not [co]admin */
#define CM_ERR_NOTNETADMIN	0x0010	/* User is not netadmin */
#define CM_ERR_LISTSENT		0x0020	/* A list has already been sent */

extern char modebuf[REALMODEBUFLEN];
extern char parabuf[REALMODEBUFLEN];
extern char idparabuf[REALMODEBUFLEN];
extern int midx, pidx, idpidx;

extern int chanmode_prefix_len;
extern char *pptr;

extern xModeTable *chanmodes;
extern chanMode *chanmode_tab[XMODE_TABLE_SIZE + 1];
extern char chanmode_str[(XMODE_TABLE_SIZE * 2) + 1];
extern char chanmode_isupport[XMODE_TABLE_SIZE + 4];

extern int add_chan_mode(char, long *, chanMode *);
extern int del_chan_mode(char, long *); /* FIXME -- UNUSED */
extern void init_chan_mode();

extern void get_chan_modes(aClient *, aChannel *, char *, char *);
extern void synch_chan_modes(aClient *, aChannel *);
extern int do_chan_mode(aClient *, aClient *, aChannel *, int, char **, int);
extern int parse_mode(aClient *, aClient *, aChannel *, int, int, char **);
extern int has_mode(aClient *, aChannel *, long);

extern int do_mode_standard(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);
extern int do_mode_k(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);
extern int do_mode_l(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);
extern int do_mode_beI(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);
extern int do_mode_aohv(aClient *, aClient *, aChannel *, int, int, short, char *, short *, unsigned int *);

extern void get_mode_standard(aClient *, aChannel *, int, char *, int *, char *, int *);
extern void get_mode_k(aClient *, aChannel *, int, char *, int *, char *, int *);
extern void get_mode_l(aClient *, aChannel *, int, char *, int *, char *, int *);

extern void sj_domode_pbuf_l(int, short, Mode *, char *, int);
extern void sj_domode_pbuf_k(int, short, Mode *, char *, int);

extern int sj_cmp_para_l(int, Mode *, Mode *);
extern int sj_cmp_para_k(int, Mode *, Mode *);

extern void sj_synch_para_l(int, Mode *, Mode *);
extern void sj_synch_para_k(int, Mode *, Mode *);

extern long CMODE_BAN;
extern long CMODE_INVITEONLY;
extern long CMODE_KEY;
extern long CMODE_LIMIT;
extern long CMODE_MODERATED;
extern long CMODE_NOPRIVMSGS;
extern long CMODE_CHANOP;
extern long CMODE_PRIVATE;
extern long CMODE_REGISTERED;
extern long CMODE_REGONLY;
extern long CMODE_SECRET;
extern long CMODE_TOPICLIMIT;
extern long CMODE_VOICE;
extern long CMODE_NOCOLOUR;
extern long CMODE_OPERONLY;
extern long CMODE_ADMINONLY;
extern long CMODE_HALFOP;
extern long CMODE_CHANADMIN;
extern long CMODE_NOCTCP;
extern long CMODE_EXCEPT;
extern long CMODE_NONICKCH;
extern long CMODE_INVEX;
extern long CMODE_MODREGONLY;

/* Backwards compatibility */
#define is_chanadmin(cln, chn)		has_mode(cln, chn, CMODE_CHANADMIN)
#define is_chanop(cln, chn)		has_mode(cln, chn, CMODE_CHANOP)
#define is_halfop(cln, chn)		has_mode(cln, chn, CMODE_HALFOP)
#define is_voice(cln, chn)		has_mode(cln, chn, CMODE_VOICE)

/* Buffer over flow protection */
#define OVERFLOW(psz)			((chanmode_prefix_len + midx + IRCD_MAX(pidx, idpidx) + psz) > REALMODEBUFLEN)

/* Append character 'chrp' to bufp */
#define ADD_CHAR(chrp, bufp, bufidx)	bufp[bufidx++] = chrp; bufp[bufidx] = '\0'

/* Add string 'strp' to bufp */
#define ADD_STRING(strp, bufp, bufidx)	pptr = strp; if (bufidx) bufp[bufidx++] = ' '; \
					while (*pptr != '\0') bufp[bufidx++] = *pptr++; \
					bufp[bufidx] = '\0'

/* Add string 'strp' to bufp1 and bufp2 */
#define ADD_STRING2(strp, bufp1, bufidx1, bufp2, bufidx2) \
				pptr = strp; if (bufidx1) bufp1[bufidx1++] = ' '; if (bufidx2) bufp2[bufidx2++] = ' '; \
				while (*pptr != '\0') { bufp1[bufidx1++] = *pptr; bufp2[bufidx2++] = *pptr++; } \
				bufp1[bufidx1] = bufp2[bufidx2] = '\0'

/* Add string 'strp' to bufp, prefixing with 'chrp' if needed */
/*
#define ADD_STRING_CHAR(strp, chrp, bufp, bufidx) \
				pptr = strp; if (bufidx) bufp[bufidx++] = ' '; if (chrp) bufp[bufidx++] = chrp; \
				while (*pptr != '\0') bufp[bufidx++] = *pptr++; bufp[bufidx] = '\0'
*/

#define ADD_MODE(mm)		ADD_CHAR(mm, modebuf, midx)
#define ADD_PARA(pp)		ADD_STRING2(pp, parabuf, pidx, idparabuf, idpidx)
#define ADD_NPARA(pp)		ADD_STRING(pp, parabuf, pidx)
#define ADD_IPARA(pp)		ADD_STRING(pp, idparabuf, idpidx)
/* #define ADD_IPARA(pp, qq)	ADD_STRING_CHAR(pp, qq, idparabuf, idpidx) */

#endif /* __xmode_include__ */
