/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: aliases.c,v 1.34.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "hook.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(aliases) = {
	"aliases",
	"services aliases",
	6, "$Revision: 1.34.2.2 $"
};

int MOD_LOAD(aliases)()
{
	if (register_command(&MOD_HEADER(aliases), &CMD_CHANSERV, m_chanserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_NICKSERV, m_nickserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_OPERSERV, m_operserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_MEMOSERV, m_memoserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_STATSERV, m_statserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_HOSTSERV, m_hostserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_BOTSERV, m_botserv) == NULL) {
		return MOD_FAILURE;
	}

	if (register_command(&MOD_HEADER(aliases), &CMD_CS, m_chanserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_NS, m_nickserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_OS, m_operserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_MS, m_memoserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_SS, m_statserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_HS, m_hostserv) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_BS, m_botserv) == NULL) {
		return MOD_FAILURE;
	}

	if (register_command(&MOD_HEADER(aliases), &CMD_SERVICES, m_services) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(aliases), &CMD_IDENTIFY, m_identify) == NULL) {
		return MOD_FAILURE;
	}

	return MOD_SUCCESS;
}

int MOD_UNLOAD(aliases)()
{
	return MOD_SUCCESS;
}

static inline int do_alias(aClient *sptr, int parc, char *parv[], char *client_server, char *client_nick)
{
	aClient *acptr = NULL;

	if (BadPtr(client_server)) {
		send_me_numeric(sptr, ERR_FUNCDISABLED, client_nick);
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numericNA(sptr, ERR_NOTEXTTOSEND);
		return 0;
	}
	if ((acptr = find_person_on_server(client_nick, client_server)) == NULL) {
		send_me_numeric(sptr, ERR_SERVICESDOWN, client_nick);
		return 0;
	}

	sendto_one_client_onserver(acptr, sptr, &CMD_PRIVMSG_D, ":%s", parv[1]);
	return 0;
}

/*
 * m_*serv
 *	parv[0] = sender prefix
 *	parv[1] = message to relay to service
 */
int m_chanserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, CHANSERV);
}

int m_nickserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, NICKSERV);
}

int m_memoserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, MEMOSERV);
}

int m_operserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, OPERSERV);
}

int m_statserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.stats_server, STATSERV);
}

int m_hostserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, HOSTSERV);
}

int m_botserv(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	return do_alias(sptr, parc, parv, NetworkConfig.services_server, BOTSERV);
}

/*
 * m_services
 *	parv[0] = sender prefix
 *	parv[1] = message to relay to service
 */
int m_services(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *tmp = NULL;

	if (BadPtr(NetworkConfig.services_server)) {
		send_me_numeric(sptr, ERR_FUNCDISABLED, "SERVICES");
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numericNA(sptr, ERR_NOTEXTTOSEND);
		return 0;
	}
	if (!mycmp(parv[1], "help")) {
		send_me_noticeNA(sptr, ":For ChanServ help, use /chanserv help");
		send_me_noticeNA(sptr, ":For NickServ help, use /nickserv help");
		send_me_noticeNA(sptr, ":For MemoServ help, use /memoserv help");
		return 0;
	}
	if ((tmp = strchr(parv[1], ' ')) != NULL) {
		while (*tmp == ' ') {
			tmp++;
		}
		if (*tmp == '#') {
			return m_chanserv(cptr, sptr, parc, parv);
		}
	}
	return m_nickserv(cptr, sptr, parc, parv);
}

/*
 * m_identify
 *	parv[0] = sender prefix
 *	parv[1] = message to relay to service
 */
int m_identify(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr = NULL;
	int gate = 0;

	if (BadPtr(NetworkConfig.services_server)) {
		send_me_numeric(sptr, ERR_FUNCDISABLED, "IDENTIFY");
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numericNA(sptr, ERR_NOTEXTTOSEND);
		return 0;
	}
	if (*parv[1] == '#' && strchr(parv[1], ' ') != NULL) {
		acptr = find_person_on_server(CHANSERV, NetworkConfig.services_server);
		gate = 1;
	}
	else {
		acptr = find_person_on_server(NICKSERV, NetworkConfig.services_server);
		gate = 0;
	}
	if (acptr == NULL) {
		send_me_numeric(sptr, ERR_SERVICESDOWN, gate ? CHANSERV : NICKSERV);
		return 0;
	}

	sendto_one_client_onserver(acptr, sptr, &CMD_PRIVMSG_D, ":IDENTIFY %s", parv[1]);
	return 0;
}
