/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_lusers.c,v 1.25.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_lusers) = {
	"m_lusers",
	"/LUSERS command",
	6, "$Revision: 1.25.2.2 $"
};

int MOD_LOAD(m_lusers)()
{
	if (register_command(&MOD_HEADER(m_lusers), &CMD_LUSERS, m_lusers) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_lusers)()
{
	return MOD_SUCCESS;
}

/*
 * m_lusers
 *	parv[0] = sender prefix
 *	parv[1] = servername
 */
int m_lusers(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static time_t last_used = 0L;

	if (use_or_deliver(cptr, sptr, &CMD_LUSERS, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_intense > 0 && (last_used + FloodConfig.pace_wait_intense > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "LUSERS requested by %s (%s@%s) [%s]", sptr->name,
				sptr->username, MaskedHost(sptr), sptr->user->server);
		}
	}
	return send_lusers(cptr, sptr, parc, parv);
}
