/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_pass.c,v 1.19.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_pass) = {
	"m_pass",
	"PASS protocol",
	6, "$Revision: 1.19.2.2 $"
};

int MOD_LOAD(m_pass)()
{
	if (register_command(&MOD_HEADER(m_pass), &CMD_PASS, m_pass) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_pass)()
{
	return MOD_SUCCESS;
}

/*
 * m_pass
 *	parv[0] = sender prefix
 *	parv[1] = password
 *	parv[2] = optional version information
 */
int m_pass(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *password = parc > 1 ? parv[1] : NULL;

	if (BadPtr(password)) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "PASS");
		return 0;
	}
	if (!MyConnect(sptr) || (!IsUnknown(cptr) && !IsHandshake(cptr))) {
		send_me_numericNA(cptr, ERR_ALREADYREGISTRED);
		return 0;
	}

	ASSERT(cptr->localClient != NULL);

	strncpyzt(cptr->localClient->passwd, password, PASSWDLEN + 1);
	if (parc > 2 && strlen(parv[2]) > 1) {
		if (*parv[2] == 'T' && *(parv[2] + 1) == 'S') {
			cptr->localClient->capabs |= CAP_TS;
		}
	}
	return 0;
}
