/*
 *  Copyright 2001-2004 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FTABCODEGEN_H
#define _FTABCODEGEN_H

#include <iostream>
#include "tabcodegen.h"

/* Forwards. */
struct ParseData;


/*
 * FTabCodeGen
 */
class FTabCodeGen : public TabCodeGen
{
public:
	FTabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

protected:
	std::ostream &ACTION_SWITCH();
	std::ostream &TRANSITIONS();
	std::ostream &LOCATE_TRANS();

	virtual std::ostream &STATE_OUT_ACTION( RedStateAp *state );
	virtual std::ostream &TRANS_ACTION( RedTransAp *trans );
};

/*
 * CFTabCodeGen
 */
class CFTabCodeGen : public FTabCodeGen
{
public:
	CFTabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( char *stateExpr, int targState, bool inFinish );

	virtual void writeOutHeader();
	virtual void writeOutCode();
};

/*
 * class CCFTabCodeGen
 */
class CCFTabCodeGen : public FTabCodeGen
{
public:
	CCFTabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( char *stateExpr, int targState, bool inFinish );

	virtual void writeOutHeader();
	virtual void writeOutCode();
};

#endif /* _FTABCODEGEN_H */
