" Vim syntax file
"
" Language: Ragel
" Author: Adrian Thurston

syntax clear

"
" Outside code
"

" Comments
syntax region ocComment start="\/\*" end="\*\/"
syntax match ocComment "\/\/.*$"

" Anything preprocessor
syntax match ocPreproc "#.*$"

" Strings
syntax match ocLiteral "'\(\\.\|[^'\\]\)*'"
syntax match ocLiteral "\"\(\\.\|[^\"\\]\)*\""

" Keywords
syntax keyword ocType unsigned signed void char short int long float double bool
syntax keyword ocType inline static extern register const volatile auto
syntax keyword ocType union enum struct class typedef
syntax keyword ocType namespace template typename mutable
syntax keyword ocKeyword break continue default do else for
syntax keyword ocKeyword goto if return switch while
syntax keyword ocKeyword new delete this using friend public private protected sizeof
syntax keyword ocKeyword throw try catch operator typeid
syntax keyword ocKeyword and bitor xor compl bitand and_eq or_eq xor_eq not not_eq
syntax keyword ocKeyword static_cast dynamic_cast

" Numbers
syntax match ocNumber "[0-9][0-9]*"
syntax match ocNumber "0x[0-9a-fA-F][0-9a-fA-F]*"

" Booleans
syntax keyword ocBoolean true false

" Identifiers
syntax match anyId "[a-zA-Z_][a-zA-Z_0-9]*"

" Inline code only
syntax keyword fsmType fpc fc fcurs fbuf fblen ftargs fstack
syntax keyword fsmKeyword fhold fgoto fcall fret fentry fnext fexec

"
" Machine Specification
"
syntax region machineSpec matchgroup=ocType start="%%" end="%%" contains=rlComment,rlLiteral,rlAugmentOps,rlOtherOps,rlType,anyLabelColon,rlCodeCurly,rlCodeSemi,rlNumber,anyId

" Comments
syntax match rlComment "#.*$" contained

" Literals
syntax match rlLiteral "'\(\\.\|[^'\\]\)*'" contained
syntax match rlLiteral "\"\(\\.\|[^\"\\]\)*\"" contained
syntax match rlLiteral /\/\(\\.\|[^\/\\]\)*\// contained
syntax match rlLiteral "\[\(\\.\|[^\]\\]\)*\]" contained

" Numbers
syntax match rlNumber "[+\-]\?[0-9][0-9]*" contained
syntax match rlNumber "0x[0-9a-fA-F][0-9a-fA-F]*" contained

" Operators
syntax match rlAugmentOps "[>$@%][\!^:]\?" contained
syntax match rlOtherOps "->" contained


" Keywords
syntax keyword rlType init action struct context contained

" Case Labels
syntax keyword caseLabelKeyword case contained
syntax cluster caseLabelItems contains=ocComment,ocPreproc,ocLiteral,ocType,ocKeyword,caseLabelKeyword,ocNumber,ocBoolean,anyId,fsmType,fsmKeyword
syntax match caseLabelColon "case" contains=@caseLabelItems
syntax match caseLabelColon "case[\t ]\+.*:$" contains=@caseLabelItems
syntax match caseLabelColon "case[\t ]\+.*:[^=:]"me=e-1 contains=@caseLabelItems

" Labels
syntax match anyLabelColon "[a-zA-Z_][a-zA-Z_0-9]*[ \t]*:$" contains=anyLabel
syntax match anyLabelColon "[a-zA-Z_][a-zA-Z_0-9]*[ \t]*:[^=:]"me=e-1 contains=anyLabel
syntax match anyLabel "[a-zA-Z_][a-zA-Z_0-9]*" contained

" All items that can go in a code block.
syntax cluster inlineItems contains=rlCodeCurly,ocComment,ocPreproc,ocLiteral,ocType,ocKeyword,ocNumber,ocBoolean,anyId,fsmType,fsmKeyword,caseLabelColon,anyLabelColon

" Blocks of code. Note the recursive specification.
syntax region rlCodeCurly start="{" end="}" contained contains=@inlineItems
syntax region rlCodeSemi matchgroup=rlType start="\<alphtype\>" start="\<getkey\>" start="\<element\>" matchgroup=NONE end=";" contained contains=@inlineItems

"
" Sync at the start and end of machine specs.
"
syn sync match ragelSyncPat grouphere machineSpec "^[ \t]*%%[ \t]*[a-zA-Z_][a-zA-Z_0-9]*[ \t]*$"
syn sync match ragelSyncPat grouphere NONE "^[ \t]*%%[ \t]*$"

"
" Specifying Groups
"
hi link ocComment Comment
hi link ocPreproc Macro
hi link ocLiteral String
hi link ocType Type
hi link ocKeyword Keyword
hi link ocNumber Number
hi link ocBoolean Boolean
hi link rlComment Comment
hi link rlNumber Number
hi link rlLiteral String
hi link rlAugmentOps Keyword
hi link rlType Type
hi link fsmType Type
hi link fsmKeyword Keyword
hi link anyLabel Label
hi link caseLabelKeyword Keyword

let b:current_syntax = "ragel"
