/*
 *  Copyright 2004 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FFLATCODEGEN_H
#define _FFLATCODEGEN_H

#include <iostream>
#include "flatcodegen.h"

/* Forwards. */
struct ParseData;

/*
 * FFlatCodeGen
 */
class FFlatCodeGen : public FlatCodeGen
{
protected:
	std::ostream &ACTION_SWITCH();
	std::ostream &STATE_DATA();

	virtual std::ostream &STATE_OUT_ACTION( RedStateAp *state );
	virtual std::ostream &TRANS_ACTION( RedTransAp *trans );
};

/*
 * CFFlatCodeGen
 */
class CFFlatCodeGen : public FFlatCodeGen, public CCodeGen
{
public:
	CFFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * class CppFFlatCodeGen
 */
class CppFFlatCodeGen : public FFlatCodeGen, public CppCodeGen
{
public:
	CppFFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * class ObjCFFlatCodeGen
 */
class ObjCFFlatCodeGen : public FFlatCodeGen, public ObjCCodeGen
{
public:
	ObjCFFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


#endif /* _FFLATCODEGEN_H */
