/*
 * Test error actions.
 */

#include <iostream>
#include <stdio.h>
#import <objc/Object.h>

using namespace std;

#define DIGIT   0x01
#define PLUS    0x02
#define MINUS   0x04
#define DECIMAL 0x08

int expt = 0;

@interface ErrAct : Object
{
@public
	int curs;
};

%% interface;

@end

%% ErrAct
{
	action err_start { printf("err_start\n"); }
	action err_all { printf("err_all\n"); }
	action err_middle { printf("err_middle\n"); }
	action err_out { printf("err_out\n"); }

	action eof_start { printf("eof_start\n"); }
	action eof_all { printf("eof_all\n"); }
	action eof_middle { printf("eof_middle\n"); }
	action eof_out { printf("eof_out\n"); }

	main := ( 'hello' 
			>!err_start $!err_all @!err_middle %!err_out
			>/eof_start $/eof_all @/eof_middle %/eof_out
		) '\n';
}

#define BUFSIZE 1024

int main()
{
	char buf[BUFSIZE];
	
	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		/* Take the first character to be the length. */
		int len = buf[0] - '0';
		ErrAct *errAct = [[ErrAct alloc] init];

		[errAct start];
		[errAct executeWithElements:buf+1 length:len];
		if ( [errAct finish] > 0 )
			cout << "ACCEPT" << endl;
		else
			cout << "FAIL" << endl;
	}
	
	return 0;
}
