/**
 * Test a high character to make sure signedness 
 * isn't messing us up.
 */

#include <stdio.h>
#include <stdlib.h>

struct high
{
	int curs;
};

%% high
{
	# We Want the header portion.
	alphtype unsigned int;

	main := ( 
			0x20 .. 0xefffffff   @1 @{printf("gothigh1\n");} | 
			0xf0000000           @1 @{printf("gothigh1\n");} | 
			0x200 .. 0xfe000000  @1 @{printf("gothigh2\n");} |
			any                  @0 @{printf("else\n");}
		)*;
}

struct high high;

#define BUFSIZE 1024
char cbuf[BUFSIZE];
unsigned int buf[BUFSIZE];
int buflen = 0;
char numbuf[9];
int numlen = 0;

struct tokenizer
{
	int curs;
};

%% tokenizer
{
	action bufdigit {
		if ( numlen < 8 )
			numbuf[numlen++] = fc;
	}

	action writeDigit {
		/* Null terminate the buffer storing the number and reset. */
		numbuf[numlen] = 0;
		numlen = 0;

		/* Store the number in the buf. If the buf is full then 
		 * flush and reset the buffer. */
		buf[buflen++] = strtoul( numbuf, 0, 16 );
		if ( buflen == BUFSIZE ) {
			high_execute( &high, buf, BUFSIZE );
			buflen = 0;
		}
	}

	action finish {
		if ( buflen > 0 )
			high_execute( &high, buf, buflen );
		if ( high_finish( &high ) > 0 )
			printf("ACCEPT\n");
		else
			printf("FAIL\n");
	}

	num = ( digit | 'a'..'f' )+ $bufdigit %writeDigit;
	main := ( num $1 %0 | space )* %/finish;
}

struct tokenizer tok;


int main()
{
	high_init( &high );
	tokenizer_init( &tok );

	while ( 1 ) {
		int len = fread( cbuf, 1, BUFSIZE, stdin );
		tokenizer_execute( &tok, cbuf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( tokenizer_finish( &tok ) <= 0 )
		printf("Tokenizer FAIL\n");
	
	return 0;
}

