/*
 * Test error actions.
 */

module atoi3;

import std.c.stdio;
import std.string;


class ErrAct
{
	int cs;

	%%{
		machine ErrAct;

		action err_start { printf("err_start\n"); }
		action err_all { printf("err_all\n"); }
		action err_middle { printf("err_middle\n"); }
		action err_out { printf("err_out\n"); }

		action eof_start { int i; printf("eof_start\n"); }
		action eof_all { printf("eof_all\n"); }
		action eof_middle { printf("eof_middle\n"); }
		action eof_out { printf("eof_out\n"); }

		main := ( 'hello'
				>!err_start $!err_all <@!err_middle %!err_out
				>/eof_start $/eof_all <@/eof_middle %/eof_out
			) '\n';
	}%%

	%% write data noprefix;

	void init( )
	{
		%% write init;
		return 1;
	}

	void execute( char* _data, int _len )
	{
		char *p = _data;
		char *pe = _data + _len;

		%% write exec;
	}

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( )
	{
		%% write eof;

		if ( cs == error )
			return -1;
		if ( cs >= first_final )
			return 1;
		return 0;
	}
};

static const int BUFSIZE = 1024;

int main()
{
	char[BUFSIZE] buf;

	while ( fgets( buf, buf.length, stdin ) != null ) {
		/* Take the first character to be the length. */
		int len = buf[0] - '0';
		ErrAct errAct = new ErrAct();

		errAct.init();
		errAct.execute( buf.ptr+1, len );
		if ( errAct.finish() > 0 )
			printf( "ACCEPT\n" );
		else
			printf( "FAIL\n" );
	}
	return 0;
}

