#include <stdio.h>

/*
 * After the fact start and ending transitions. Behaves like constructors of
 * and destructors in c++.
 */

struct forder
{
	int cs;
};

%%{
	machine forder;
	variable curstate fsm->cs;

	inner = 'inner'
		>{printf("enter inner\n");}
		${printf("inside inner\n");}
		%{printf("leave inner\n");}
	;

	outter = inner
		>{printf("enter outter\n");}
		${printf("inside outter\n");}
		%{printf("leave outter\n");}
	;

	main := outter . '\n';
}%%

%% write data;

void forder_init( struct forder *fsm )
{
	%% write init;
}

void forder_execute( struct forder *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;
}

int forder_finish( struct forder *fsm )
{
	%% write eof;

	if ( fsm->cs == forder_error )
		return -1;
	if ( fsm->cs >= forder_first_final )
		return 1;
	return 0;
}

#include <stdio.h>
#define BUFSIZE 2048

struct forder fsm;
char buf[BUFSIZE];

int main()
{
	forder_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		forder_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( forder_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

