/*
 * Test in and out state actions.
 */

#include <stdio.h>
#include <objc/Object.h>

@interface StateAct : Object
{
@public
	int cs;
};

// Initialize the machine. Invokes any init statement blocks. Returns 0
// if the machine begins in a non-accepting state and 1 if the machine
// begins in an accepting state.
- (int) initFsm;

// Execute the machine on a block of data. Returns -1 if after processing
// the data, the machine is in the error state and can never accept, 0 if
// the machine is in a non-accepting state and 1 if the machine is in an
// accepting state.
- (void) executeWithData:(const char *)data len:(int)len;

// Indicate that there is no more data. Returns -1 if the machine finishes
// in the error state and does not accept, 0 if the machine finishes
// in any other non-accepting state and 1 if the machine finishes in an
// accepting state.
- (int) finish;

@end

@implementation StateAct

%%{
	machine StateAct;

	action a1 { printf( "a1\n"); }
	action a2 { printf( "a2\n"); }
	action b1 { printf( "b1\n"); }
	action b2 { printf( "b2\n"); }
	action c1 { printf( "c1\n"); }
	action c2 { printf( "c2\n"); }

	hi = 'hi';
	main := ( again: hi >~b1 >*b2 '\n' >~c1 >*c2 @{fnext again;} )* >~a1 >*a2;
}%%

%% write data;

- (int) initFsm;
{
	%% write init;
	return 1;
}

- (void) executeWithData:(const char *)_data len:(int)_len;
{
	const char *p = _data;
	const char *pe = _data + _len;
	%% write exec;
}

- (int) finish;
{
	%% write eof;
	if ( cs == StateAct_error )
		return -1;
	else if ( cs >= StateAct_first_final )
		return 1;
	return 0;
}


@end

#define BUFSIZE 3
char buf[BUFSIZE];

StateAct *sa;

int main()
{
	sa = [[StateAct alloc] init];

	[sa initFsm];
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		[sa executeWithData:buf len:len];
		if ( len != BUFSIZE )
			break;
	}
	[sa finish];
/*	if ( [sa finish] ) <= 0 )*/
/*		printf("Tokenizer FAIL\n");*/
	
	return 0;
}
