/*
 * Test in and out state actions.
 */

import std.c.stdio;
import std.string;

class state_act 
{
	int cs;

	%%{
		machine state_act;

		action a1 { printf( "a1\n"); }
		action a2 { printf( "a2\n"); }
		action b1 { printf( "b1\n"); }
		action b2 { printf( "b2\n"); }
		action c1 { printf( "c1\n"); }
		action c2 { printf( "c2\n"); }

		hi = 'hi';
		main := ( again: hi >~b1 >*b2 '\n' >~c1 >*c2 @{fnext again;} )* >~a1 >*a2;
	}%%

	%% write data noprefix;

	void init( )
	{
		%% write init;
		return 1;
	}

	void execute( char* _data, int _len )
	{
		char *p = _data;
		char *pe = _data + _len;

		%% write exec;
	}

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( )
	{
		%% write eof;

		if ( cs == error )
			return -1;
		if ( cs >= first_final )
			return 1;
		return 0;
	}
};

static const int BUFSIZE = 3;

int main()
{
	state_act sa = new state_act();
	char[BUFSIZE] buf = new char[BUFSIZE];

	sa.init();
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		if(len > 0)
			sa.execute( buf.ptr, len );
		else
			break;
	}
	
	sa.finish();
	return 0;
}
