# Announce: Rakudo compiler, Release #141 (2020.11)

On behalf of the Rakudo development team, I’m very happy to announce the
November 2020 release of Rakudo #141. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.11:

  + Additions:
    + Introduce new coercion semantics. It includes coercions being first-class
      type objects, a parameter being marked as `coercive` if its type is a coerce,
      coercions redelegating method calls to their target type, coercions type checking
      being more correct. Coercions are now nominalizable, they nominalize into
      the target type. Aside from those changes, coercion protocol is introduced.
      If `coerce` method of `Metamodel::CoercionHOW` is used for `Foo(Bar)`,
      then the following methods are tried in the order of mentioning:
      - the current standard of `Bar.Foo`
      - `Bar.COERCE-INTO(Foo)`
      - `Foo.COERCE-FROM(Bar)`
      Also, nested coercions are supported now.
      User code that depends heavily on compiler internals in this area can become incompatible,
      so upgrade with caution if there is any of such sort.
      [f2d73287][2675813f][81f3334a][27fb3ec0][39614955][841529a9][ea2fdd2f]
      [3a7ae220][ebef668e][178c8535][dcfcda64][7429bfe3][32a8024b][42a0d131]
      [0dc9664d][f4f5d2c1][e890ddf9][9725c2e9][58576c24][0edb1fcb][1dd99ef1]
      [72984bfa][4efcdba2][43a81a2c][8a1ba7fd][cad80873][9f625326][34bc0b91]
      [a3ed0204][b4525665][6dbce0ac][824c5adc][c015759b][efd8078f][2fb0f9fb]
    + Implement the `prefix:<||>` operator in postcircumfixes for `6.e` and later,
      originally described in Synopsis 09 [e6787d77][48b1b20f][7a2264b4][35213f66]
    + Give `dd` (an internal Rakudo-specific routine for debugging purposes)
      support for `BOOTThread` objects [59d140bf]
    + Add a flag to `symlink` allowing creation of relative symlinks [089bd590]
    + Implement binding of array-slices (e.g. `@A[1,2,3] := <a b c>`) [051e0361]
    + Implement binding of hash-slices (e.g. `%h<a b c> := 1,2,3`) [87ef76ae]
    + Give `raku -v` a pure ASCII version [329e47f4]
    + Introduce `is test-assertion` trait for routines, improving behaving of
      test assertions written by the user [585db59c][86a208e2][2436532f]
    + Make Whatever slice work on 1-dim native shaped arrays [1cb2df80]
    + Handle `:exists` and `:delete` on 1-dim native shaped arrays with int index [db3ca28e]
    + Add Windows specific build instructions [07c95131][5b282cfc]
  + Changes:
    + Unicode support is updated to match with 13.0, 13.1 versions [bd803d5e][68196c99]
    + Do not allow `infix:<does>` on Int or Str, print an error message saying
      `but` should be used [2f3de2fa]
    + `Datetime.local` now defaults to `$*TZ` [9443fba8]
    + Values passed to sub form of `push` and `unshift` are not longer flattened [e78c53ba]
  + Efficiency:
    + Create common Version objects at setting compile time [18882bf6][7f9f9e96]
    + Make `Str.raku` about 35% faster [97d473b9][5cbe14e8]
    + Make `DateTime.now` 60% faster [53b558fe][fd5950f1]
    + Simplify native shaped array `.shape` method [424ce71a]
    + Constantize empty list / hash in `Match` [0447b15e]
    + Constantize encoding and clean parts lookup [8af0c463]
    + Simplify Hash parameterization [1321a853]
    + Streamline handling of bind/delete on native arrays [adeff7de]
    + Make simple native shaped array access about 5x as fast [3e6e15e6][75574bea][f6cdbd81]
  + Fixes:
    + Fix building on Windows with MinGW [200821cd]
    + Fix a rare issue with precompilation [dd0a2a15]
    + Improvements of `postcircumfix[;]` in 6.e language version [39c51595][03e1ba72][316902dd]
    + Make auto-generated mixin role be of language revision `c`.
      This fixes `$a but $b` under `use v6.e` pragma [6b87d3e5]
    + Don't inherit mixin class language revision. This allows mixin of custom roles
      under `v6.e.PREVIEW` pragma [2991016a]
    + Fix some issues with `$*TZ` and long-running processes [613da571][78935ebd]
    + Make MacOS nick lookup hash a constant, also improving build reproducibility
      on MacOS [78f16451][2ad244b1]
    + Add support for MacOS 11.0 nick [ccc50f7a]
    + Use alternate test for DST change [89211e2e][ede52fb0]
    + Make sure match processing can handle `$/` being a `Junction` [5b369181]
    + Fix for `isa-ok` to handle test subjects not inheriting from `Mu`
      (e.g. `isa-ok Any.HOW, Metamodel::ClassHOW`) [dbf53c05]
    + Fix `IO::Path.absolute(IO::Path)` breakage on Windows [08f5d028]
    + Fix regression in list handling of `take` / `take-rw` introduced back in 2020.01 release [3e10cc6f]
    + Provide more improvements to language revision support and provide a better fix for mixins
      [7de2b15b][9075c766][b21dd027][38bb2441][74faa0a2]
  + Internal:
    + Replace all simple `nqp::if(42,foo,bar)` with ternaries [b1912d9f]
    + Strip excessive escaping in an internal script [857fbfd5]
    + Update `docs/running.pod` [39eedacf]
    + Make `sigils2bit` mapper a setting compiler time thing [a541aed8][0a4eaf31]
    + Expose the `Array::Shaped` role, `Array::Shaped1|2|3` roles [ee089234][532b5423][cb95c653][e45bcd53][e45bcd53]
    + Expose `Hash::Object` and `Hash::Typed` roles [1a6cf787]
    + Make unicode property tests deterministic [151fd310]
    + Pseudostash code doesn't need a sub [7b2d9af7]
    + Refactor `Array::set-shape` a bit [18af3f44][417ad76c]
    + Better check for subness of `MAIN` [e3352cdd]
    + Don't use "perl" in identifiers unless needed [fa2013db]
    + Prevent a compiler warning about an invalid cast [f0808da6]
    + Make setting array shapes more alike [e612214c]


The following people contributed to this release:

Elizabeth Mattijsen, Vadim Belman, Will "Coke" Coleda, Patrick Böker,
Alexander Kiryuhin, Stoned Elipot, Christian Bartolomäus, Samantha McVey,
Nicholas Clark, Peter du Marchie van Voorthuysen, Daniel Green,
Stefan Seifert, Fernando Santagata, Ben Davies, Juan Julián Merelo Guervós,
Daniel Mita, Jonathan Worthington, José Joaquín Atria,
Matthew Wilson, Timo Paulssen, Yves Guillemot

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#142), is tentatively scheduled for 2020-11-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
