/*
This code is written by kerukuro and released into public domain.
*/

#ifndef DIGESTPP_PROVIDERS_GROESTL_CONSTANTS_HPP
#define DIGESTPP_PROVIDERS_GROESTL_CONSTANTS_HPP

namespace digestpp
{

namespace detail
{

template<typename V>
struct groestl_constants
{
	static const uint64_t T[8][256];

};

template<typename V>
const uint64_t groestl_constants<V>::T[8][256] = {
	{
		0xc6a597f4a5f432c6ull,	0xf884eb9784976ff8ull,	0xee99c7b099b05eeeull,	0xf68df78c8d8c7af6ull,
		0xff0de5170d17e8ffull,	0xd6bdb7dcbddc0ad6ull,	0xdeb1a7c8b1c816deull,	0x915439fc54fc6d91ull,
		0x6050c0f050f09060ull,	0x0203040503050702ull,	0xcea987e0a9e02eceull,	0x567dac877d87d156ull,
		0xe719d52b192bcce7ull,	0xb56271a662a613b5ull,	0x4de69a31e6317c4dull,	0xec9ac3b59ab559ecull,
		0x8f4505cf45cf408full,	0x1f9d3ebc9dbca31full,	0x894009c040c04989ull,	0xfa87ef92879268faull,
		0xef15c53f153fd0efull,	0xb2eb7f26eb2694b2ull,	0x8ec90740c940ce8eull,	0xfb0bed1d0b1de6fbull,
		0x41ec822fec2f6e41ull,	0xb3677da967a91ab3ull,	0x5ffdbe1cfd1c435full,	0x45ea8a25ea256045ull,
		0x23bf46dabfdaf923ull,	0x53f7a602f7025153ull,	0xe496d3a196a145e4ull,	0x9b5b2ded5bed769bull,
		0x75c2ea5dc25d2875ull,	0xe11cd9241c24c5e1ull,	0x3dae7ae9aee9d43dull,	0x4c6a98be6abef24cull,
		0x6c5ad8ee5aee826cull,	0x7e41fcc341c3bd7eull,	0xf502f1060206f3f5ull,	0x834f1dd14fd15283ull,
		0x685cd0e45ce48c68ull,	0x51f4a207f4075651ull,	0xd134b95c345c8dd1ull,	0xf908e9180818e1f9ull,
		0xe293dfae93ae4ce2ull,	0xab734d9573953eabull,	0x6253c4f553f59762ull,	0x2a3f54413f416b2aull,
		0x080c10140c141c08ull,	0x955231f652f66395ull,	0x46658caf65afe946ull,	0x9d5e21e25ee27f9dull,
		0x3028607828784830ull,	0x37a16ef8a1f8cf37ull,	0x0a0f14110f111b0aull,	0x2fb55ec4b5c4eb2full,
		0x0e091c1b091b150eull,	0x2436485a365a7e24ull,	0x1b9b36b69bb6ad1bull,	0xdf3da5473d4798dfull,
		0xcd26816a266aa7cdull,	0x4e699cbb69bbf54eull,	0x7fcdfe4ccd4c337full,	0xea9fcfba9fba50eaull,
		0x121b242d1b2d3f12ull,	0x1d9e3ab99eb9a41dull,	0x5874b09c749cc458ull,	0x342e68722e724634ull,
		0x362d6c772d774136ull,	0xdcb2a3cdb2cd11dcull,	0xb4ee7329ee299db4ull,	0x5bfbb616fb164d5bull,
		0xa4f65301f601a5a4ull,	0x764decd74dd7a176ull,	0xb76175a361a314b7ull,	0x7dcefa49ce49347dull,
		0x527ba48d7b8ddf52ull,	0xdd3ea1423e429fddull,	0x5e71bc937193cd5eull,	0x139726a297a2b113ull,
		0xa6f55704f504a2a6ull,	0xb96869b868b801b9ull,	0x0000000000000000ull,	0xc12c99742c74b5c1ull,
		0x406080a060a0e040ull,	0xe31fdd211f21c2e3ull,	0x79c8f243c8433a79ull,	0xb6ed772ced2c9ab6ull,
		0xd4beb3d9bed90dd4ull,	0x8d4601ca46ca478dull,	0x67d9ce70d9701767ull,	0x724be4dd4bddaf72ull,
		0x94de3379de79ed94ull,	0x98d42b67d467ff98ull,	0xb0e87b23e82393b0ull,	0x854a11de4ade5b85ull,
		0xbb6b6dbd6bbd06bbull,	0xc52a917e2a7ebbc5ull,	0x4fe59e34e5347b4full,	0xed16c13a163ad7edull,
		0x86c51754c554d286ull,	0x9ad72f62d762f89aull,	0x6655ccff55ff9966ull,	0x119422a794a7b611ull,
		0x8acf0f4acf4ac08aull,	0xe910c9301030d9e9ull,	0x0406080a060a0e04ull,	0xfe81e798819866feull,
		0xa0f05b0bf00baba0ull,	0x7844f0cc44ccb478ull,	0x25ba4ad5bad5f025ull,	0x4be3963ee33e754bull,
		0xa2f35f0ef30eaca2ull,	0x5dfeba19fe19445dull,	0x80c01b5bc05bdb80ull,	0x058a0a858a858005ull,
		0x3fad7eecadecd33full,	0x21bc42dfbcdffe21ull,	0x7048e0d848d8a870ull,	0xf104f90c040cfdf1ull,
		0x63dfc67adf7a1963ull,	0x77c1ee58c1582f77ull,	0xaf75459f759f30afull,	0x426384a563a5e742ull,
		0x2030405030507020ull,	0xe51ad12e1a2ecbe5ull,	0xfd0ee1120e12effdull,	0xbf6d65b76db708bfull,
		0x814c19d44cd45581ull,	0x1814303c143c2418ull,	0x26354c5f355f7926ull,	0xc32f9d712f71b2c3ull,
		0xbee16738e13886beull,	0x35a26afda2fdc835ull,	0x88cc0b4fcc4fc788ull,	0x2e395c4b394b652eull,
		0x93573df957f96a93ull,	0x55f2aa0df20d5855ull,	0xfc82e39d829d61fcull,	0x7a47f4c947c9b37aull,
		0xc8ac8befacef27c8ull,	0xbae76f32e73288baull,	0x322b647d2b7d4f32ull,	0xe695d7a495a442e6ull,
		0xc0a09bfba0fb3bc0ull,	0x199832b398b3aa19ull,	0x9ed12768d168f69eull,	0xa37f5d817f8122a3ull,
		0x446688aa66aaee44ull,	0x547ea8827e82d654ull,	0x3bab76e6abe6dd3bull,	0x0b83169e839e950bull,
		0x8cca0345ca45c98cull,	0xc729957b297bbcc7ull,	0x6bd3d66ed36e056bull,	0x283c50443c446c28ull,
		0xa779558b798b2ca7ull,	0xbce2633de23d81bcull,	0x161d2c271d273116ull,	0xad76419a769a37adull,
		0xdb3bad4d3b4d96dbull,	0x6456c8fa56fa9e64ull,	0x744ee8d24ed2a674ull,	0x141e28221e223614ull,
		0x92db3f76db76e492ull,	0x0c0a181e0a1e120cull,	0x486c90b46cb4fc48ull,	0xb8e46b37e4378fb8ull,
		0x9f5d25e75de7789full,	0xbd6e61b26eb20fbdull,	0x43ef862aef2a6943ull,	0xc4a693f1a6f135c4ull,
		0x39a872e3a8e3da39ull,	0x31a462f7a4f7c631ull,	0xd337bd5937598ad3ull,	0xf28bff868b8674f2ull,
		0xd532b156325683d5ull,	0x8b430dc543c54e8bull,	0x6e59dceb59eb856eull,	0xdab7afc2b7c218daull,
		0x018c028f8c8f8e01ull,	0xb16479ac64ac1db1ull,	0x9cd2236dd26df19cull,	0x49e0923be03b7249ull,
		0xd8b4abc7b4c71fd8ull,	0xacfa4315fa15b9acull,	0xf307fd090709faf3ull,	0xcf25856f256fa0cfull,
		0xcaaf8feaafea20caull,	0xf48ef3898e897df4ull,	0x47e98e20e9206747ull,	0x1018202818283810ull,
		0x6fd5de64d5640b6full,	0xf088fb83888373f0ull,	0x4a6f94b16fb1fb4aull,	0x5c72b8967296ca5cull,
		0x3824706c246c5438ull,	0x57f1ae08f1085f57ull,	0x73c7e652c7522173ull,	0x975135f351f36497ull,
		0xcb238d652365aecbull,	0xa17c59847c8425a1ull,	0xe89ccbbf9cbf57e8ull,	0x3e217c6321635d3eull,
		0x96dd377cdd7cea96ull,	0x61dcc27fdc7f1e61ull,	0x0d861a9186919c0dull,	0x0f851e9485949b0full,
		0xe090dbab90ab4be0ull,	0x7c42f8c642c6ba7cull,	0x71c4e257c4572671ull,	0xccaa83e5aae529ccull,
		0x90d83b73d873e390ull,	0x06050c0f050f0906ull,	0xf701f5030103f4f7ull,	0x1c12383612362a1cull,
		0xc2a39ffea3fe3cc2ull,	0x6a5fd4e15fe18b6aull,	0xaef94710f910beaeull,	0x69d0d26bd06b0269ull,
		0x17912ea891a8bf17ull,	0x995829e858e87199ull,	0x3a2774692769533aull,	0x27b94ed0b9d0f727ull,
		0xd938a948384891d9ull,	0xeb13cd351335deebull,	0x2bb356ceb3cee52bull,	0x2233445533557722ull,
		0xd2bbbfd6bbd604d2ull,	0xa9704990709039a9ull,	0x07890e8089808707ull,	0x33a766f2a7f2c133ull,
		0x2db65ac1b6c1ec2dull,	0x3c22786622665a3cull,	0x15922aad92adb815ull,	0xc92089602060a9c9ull,
		0x874915db49db5c87ull,	0xaaff4f1aff1ab0aaull,	0x5078a0887888d850ull,	0xa57a518e7a8e2ba5ull,
		0x038f068a8f8a8903ull,	0x59f8b213f8134a59ull,	0x0980129b809b9209ull,	0x1a1734391739231aull,
		0x65daca75da751065ull,	0xd731b553315384d7ull,	0x84c61351c651d584ull,	0xd0b8bbd3b8d303d0ull,
		0x82c31f5ec35edc82ull,	0x29b052cbb0cbe229ull,	0x5a77b4997799c35aull,	0x1e113c3311332d1eull,
		0x7bcbf646cb463d7bull,	0xa8fc4b1ffc1fb7a8ull,	0x6dd6da61d6610c6dull,	0x2c3a584e3a4e622cull
	},
	{
		0xa597f4a5f432c6c6ull,	0x84eb9784976ff8f8ull,	0x99c7b099b05eeeeeull,	0x8df78c8d8c7af6f6ull,
		0x0de5170d17e8ffffull,	0xbdb7dcbddc0ad6d6ull,	0xb1a7c8b1c816dedeull,	0x5439fc54fc6d9191ull,
		0x50c0f050f0906060ull,	0x0304050305070202ull,	0xa987e0a9e02ececeull,	0x7dac877d87d15656ull,
		0x19d52b192bcce7e7ull,	0x6271a662a613b5b5ull,	0xe69a31e6317c4d4dull,	0x9ac3b59ab559ececull,
		0x4505cf45cf408f8full,	0x9d3ebc9dbca31f1full,	0x4009c040c0498989ull,	0x87ef92879268fafaull,
		0x15c53f153fd0efefull,	0xeb7f26eb2694b2b2ull,	0xc90740c940ce8e8eull,	0x0bed1d0b1de6fbfbull,
		0xec822fec2f6e4141ull,	0x677da967a91ab3b3ull,	0xfdbe1cfd1c435f5full,	0xea8a25ea25604545ull,
		0xbf46dabfdaf92323ull,	0xf7a602f702515353ull,	0x96d3a196a145e4e4ull,	0x5b2ded5bed769b9bull,
		0xc2ea5dc25d287575ull,	0x1cd9241c24c5e1e1ull,	0xae7ae9aee9d43d3dull,	0x6a98be6abef24c4cull,
		0x5ad8ee5aee826c6cull,	0x41fcc341c3bd7e7eull,	0x02f1060206f3f5f5ull,	0x4f1dd14fd1528383ull,
		0x5cd0e45ce48c6868ull,	0xf4a207f407565151ull,	0x34b95c345c8dd1d1ull,	0x08e9180818e1f9f9ull,
		0x93dfae93ae4ce2e2ull,	0x734d9573953eababull,	0x53c4f553f5976262ull,	0x3f54413f416b2a2aull,
		0x0c10140c141c0808ull,	0x5231f652f6639595ull,	0x658caf65afe94646ull,	0x5e21e25ee27f9d9dull,
		0x2860782878483030ull,	0xa16ef8a1f8cf3737ull,	0x0f14110f111b0a0aull,	0xb55ec4b5c4eb2f2full,
		0x091c1b091b150e0eull,	0x36485a365a7e2424ull,	0x9b36b69bb6ad1b1bull,	0x3da5473d4798dfdfull,
		0x26816a266aa7cdcdull,	0x699cbb69bbf54e4eull,	0xcdfe4ccd4c337f7full,	0x9fcfba9fba50eaeaull,
		0x1b242d1b2d3f1212ull,	0x9e3ab99eb9a41d1dull,	0x74b09c749cc45858ull,	0x2e68722e72463434ull,
		0x2d6c772d77413636ull,	0xb2a3cdb2cd11dcdcull,	0xee7329ee299db4b4ull,	0xfbb616fb164d5b5bull,
		0xf65301f601a5a4a4ull,	0x4decd74dd7a17676ull,	0x6175a361a314b7b7ull,	0xcefa49ce49347d7dull,
		0x7ba48d7b8ddf5252ull,	0x3ea1423e429fddddull,	0x71bc937193cd5e5eull,	0x9726a297a2b11313ull,
		0xf55704f504a2a6a6ull,	0x6869b868b801b9b9ull,	0x0000000000000000ull,	0x2c99742c74b5c1c1ull,
		0x6080a060a0e04040ull,	0x1fdd211f21c2e3e3ull,	0xc8f243c8433a7979ull,	0xed772ced2c9ab6b6ull,
		0xbeb3d9bed90dd4d4ull,	0x4601ca46ca478d8dull,	0xd9ce70d970176767ull,	0x4be4dd4bddaf7272ull,
		0xde3379de79ed9494ull,	0xd42b67d467ff9898ull,	0xe87b23e82393b0b0ull,	0x4a11de4ade5b8585ull,
		0x6b6dbd6bbd06bbbbull,	0x2a917e2a7ebbc5c5ull,	0xe59e34e5347b4f4full,	0x16c13a163ad7ededull,
		0xc51754c554d28686ull,	0xd72f62d762f89a9aull,	0x55ccff55ff996666ull,	0x9422a794a7b61111ull,
		0xcf0f4acf4ac08a8aull,	0x10c9301030d9e9e9ull,	0x06080a060a0e0404ull,	0x81e798819866fefeull,
		0xf05b0bf00baba0a0ull,	0x44f0cc44ccb47878ull,	0xba4ad5bad5f02525ull,	0xe3963ee33e754b4bull,
		0xf35f0ef30eaca2a2ull,	0xfeba19fe19445d5dull,	0xc01b5bc05bdb8080ull,	0x8a0a858a85800505ull,
		0xad7eecadecd33f3full,	0xbc42dfbcdffe2121ull,	0x48e0d848d8a87070ull,	0x04f90c040cfdf1f1ull,
		0xdfc67adf7a196363ull,	0xc1ee58c1582f7777ull,	0x75459f759f30afafull,	0x6384a563a5e74242ull,
		0x3040503050702020ull,	0x1ad12e1a2ecbe5e5ull,	0x0ee1120e12effdfdull,	0x6d65b76db708bfbfull,
		0x4c19d44cd4558181ull,	0x14303c143c241818ull,	0x354c5f355f792626ull,	0x2f9d712f71b2c3c3ull,
		0xe16738e13886bebeull,	0xa26afda2fdc83535ull,	0xcc0b4fcc4fc78888ull,	0x395c4b394b652e2eull,
		0x573df957f96a9393ull,	0xf2aa0df20d585555ull,	0x82e39d829d61fcfcull,	0x47f4c947c9b37a7aull,
		0xac8befacef27c8c8ull,	0xe76f32e73288babaull,	0x2b647d2b7d4f3232ull,	0x95d7a495a442e6e6ull,
		0xa09bfba0fb3bc0c0ull,	0x9832b398b3aa1919ull,	0xd12768d168f69e9eull,	0x7f5d817f8122a3a3ull,
		0x6688aa66aaee4444ull,	0x7ea8827e82d65454ull,	0xab76e6abe6dd3b3bull,	0x83169e839e950b0bull,
		0xca0345ca45c98c8cull,	0x29957b297bbcc7c7ull,	0xd3d66ed36e056b6bull,	0x3c50443c446c2828ull,
		0x79558b798b2ca7a7ull,	0xe2633de23d81bcbcull,	0x1d2c271d27311616ull,	0x76419a769a37adadull,
		0x3bad4d3b4d96dbdbull,	0x56c8fa56fa9e6464ull,	0x4ee8d24ed2a67474ull,	0x1e28221e22361414ull,
		0xdb3f76db76e49292ull,	0x0a181e0a1e120c0cull,	0x6c90b46cb4fc4848ull,	0xe46b37e4378fb8b8ull,
		0x5d25e75de7789f9full,	0x6e61b26eb20fbdbdull,	0xef862aef2a694343ull,	0xa693f1a6f135c4c4ull,
		0xa872e3a8e3da3939ull,	0xa462f7a4f7c63131ull,	0x37bd5937598ad3d3ull,	0x8bff868b8674f2f2ull,
		0x32b156325683d5d5ull,	0x430dc543c54e8b8bull,	0x59dceb59eb856e6eull,	0xb7afc2b7c218dadaull,
		0x8c028f8c8f8e0101ull,	0x6479ac64ac1db1b1ull,	0xd2236dd26df19c9cull,	0xe0923be03b724949ull,
		0xb4abc7b4c71fd8d8ull,	0xfa4315fa15b9acacull,	0x07fd090709faf3f3ull,	0x25856f256fa0cfcfull,
		0xaf8feaafea20cacaull,	0x8ef3898e897df4f4ull,	0xe98e20e920674747ull,	0x1820281828381010ull,
		0xd5de64d5640b6f6full,	0x88fb83888373f0f0ull,	0x6f94b16fb1fb4a4aull,	0x72b8967296ca5c5cull,
		0x24706c246c543838ull,	0xf1ae08f1085f5757ull,	0xc7e652c752217373ull,	0x5135f351f3649797ull,
		0x238d652365aecbcbull,	0x7c59847c8425a1a1ull,	0x9ccbbf9cbf57e8e8ull,	0x217c6321635d3e3eull,
		0xdd377cdd7cea9696ull,	0xdcc27fdc7f1e6161ull,	0x861a9186919c0d0dull,	0x851e9485949b0f0full,
		0x90dbab90ab4be0e0ull,	0x42f8c642c6ba7c7cull,	0xc4e257c457267171ull,	0xaa83e5aae529ccccull,
		0xd83b73d873e39090ull,	0x050c0f050f090606ull,	0x01f5030103f4f7f7ull,	0x12383612362a1c1cull,
		0xa39ffea3fe3cc2c2ull,	0x5fd4e15fe18b6a6aull,	0xf94710f910beaeaeull,	0xd0d26bd06b026969ull,
		0x912ea891a8bf1717ull,	0x5829e858e8719999ull,	0x2774692769533a3aull,	0xb94ed0b9d0f72727ull,
		0x38a948384891d9d9ull,	0x13cd351335deebebull,	0xb356ceb3cee52b2bull,	0x3344553355772222ull,
		0xbbbfd6bbd604d2d2ull,	0x704990709039a9a9ull,	0x890e808980870707ull,	0xa766f2a7f2c13333ull,
		0xb65ac1b6c1ec2d2dull,	0x22786622665a3c3cull,	0x922aad92adb81515ull,	0x2089602060a9c9c9ull,
		0x4915db49db5c8787ull,	0xff4f1aff1ab0aaaaull,	0x78a0887888d85050ull,	0x7a518e7a8e2ba5a5ull,
		0x8f068a8f8a890303ull,	0xf8b213f8134a5959ull,	0x80129b809b920909ull,	0x1734391739231a1aull,
		0xdaca75da75106565ull,	0x31b553315384d7d7ull,	0xc61351c651d58484ull,	0xb8bbd3b8d303d0d0ull,
		0xc31f5ec35edc8282ull,	0xb052cbb0cbe22929ull,	0x77b4997799c35a5aull,	0x113c3311332d1e1eull,
		0xcbf646cb463d7b7bull,	0xfc4b1ffc1fb7a8a8ull,	0xd6da61d6610c6d6dull,	0x3a584e3a4e622c2cull
	},
	{
		0x97f4a5f432c6c6a5ull,	0xeb9784976ff8f884ull,	0xc7b099b05eeeee99ull,	0xf78c8d8c7af6f68dull,
		0xe5170d17e8ffff0dull,	0xb7dcbddc0ad6d6bdull,	0xa7c8b1c816dedeb1ull,	0x39fc54fc6d919154ull,
		0xc0f050f090606050ull,	0x0405030507020203ull,	0x87e0a9e02ececea9ull,	0xac877d87d156567dull,
		0xd52b192bcce7e719ull,	0x71a662a613b5b562ull,	0x9a31e6317c4d4de6ull,	0xc3b59ab559ecec9aull,
		0x05cf45cf408f8f45ull,	0x3ebc9dbca31f1f9dull,	0x09c040c049898940ull,	0xef92879268fafa87ull,
		0xc53f153fd0efef15ull,	0x7f26eb2694b2b2ebull,	0x0740c940ce8e8ec9ull,	0xed1d0b1de6fbfb0bull,
		0x822fec2f6e4141ecull,	0x7da967a91ab3b367ull,	0xbe1cfd1c435f5ffdull,	0x8a25ea25604545eaull,
		0x46dabfdaf92323bfull,	0xa602f702515353f7ull,	0xd3a196a145e4e496ull,	0x2ded5bed769b9b5bull,
		0xea5dc25d287575c2ull,	0xd9241c24c5e1e11cull,	0x7ae9aee9d43d3daeull,	0x98be6abef24c4c6aull,
		0xd8ee5aee826c6c5aull,	0xfcc341c3bd7e7e41ull,	0xf1060206f3f5f502ull,	0x1dd14fd15283834full,
		0xd0e45ce48c68685cull,	0xa207f407565151f4ull,	0xb95c345c8dd1d134ull,	0xe9180818e1f9f908ull,
		0xdfae93ae4ce2e293ull,	0x4d9573953eabab73ull,	0xc4f553f597626253ull,	0x54413f416b2a2a3full,
		0x10140c141c08080cull,	0x31f652f663959552ull,	0x8caf65afe9464665ull,	0x21e25ee27f9d9d5eull,
		0x6078287848303028ull,	0x6ef8a1f8cf3737a1ull,	0x14110f111b0a0a0full,	0x5ec4b5c4eb2f2fb5ull,
		0x1c1b091b150e0e09ull,	0x485a365a7e242436ull,	0x36b69bb6ad1b1b9bull,	0xa5473d4798dfdf3dull,
		0x816a266aa7cdcd26ull,	0x9cbb69bbf54e4e69ull,	0xfe4ccd4c337f7fcdull,	0xcfba9fba50eaea9full,
		0x242d1b2d3f12121bull,	0x3ab99eb9a41d1d9eull,	0xb09c749cc4585874ull,	0x68722e724634342eull,
		0x6c772d774136362dull,	0xa3cdb2cd11dcdcb2ull,	0x7329ee299db4b4eeull,	0xb616fb164d5b5bfbull,
		0x5301f601a5a4a4f6ull,	0xecd74dd7a176764dull,	0x75a361a314b7b761ull,	0xfa49ce49347d7dceull,
		0xa48d7b8ddf52527bull,	0xa1423e429fdddd3eull,	0xbc937193cd5e5e71ull,	0x26a297a2b1131397ull,
		0x5704f504a2a6a6f5ull,	0x69b868b801b9b968ull,	0x0000000000000000ull,	0x99742c74b5c1c12cull,
		0x80a060a0e0404060ull,	0xdd211f21c2e3e31full,	0xf243c8433a7979c8ull,	0x772ced2c9ab6b6edull,
		0xb3d9bed90dd4d4beull,	0x01ca46ca478d8d46ull,	0xce70d970176767d9ull,	0xe4dd4bddaf72724bull,
		0x3379de79ed9494deull,	0x2b67d467ff9898d4ull,	0x7b23e82393b0b0e8ull,	0x11de4ade5b85854aull,
		0x6dbd6bbd06bbbb6bull,	0x917e2a7ebbc5c52aull,	0x9e34e5347b4f4fe5ull,	0xc13a163ad7eded16ull,
		0x1754c554d28686c5ull,	0x2f62d762f89a9ad7ull,	0xccff55ff99666655ull,	0x22a794a7b6111194ull,
		0x0f4acf4ac08a8acfull,	0xc9301030d9e9e910ull,	0x080a060a0e040406ull,	0xe798819866fefe81ull,
		0x5b0bf00baba0a0f0ull,	0xf0cc44ccb4787844ull,	0x4ad5bad5f02525baull,	0x963ee33e754b4be3ull,
		0x5f0ef30eaca2a2f3ull,	0xba19fe19445d5dfeull,	0x1b5bc05bdb8080c0ull,	0x0a858a858005058aull,
		0x7eecadecd33f3fadull,	0x42dfbcdffe2121bcull,	0xe0d848d8a8707048ull,	0xf90c040cfdf1f104ull,
		0xc67adf7a196363dfull,	0xee58c1582f7777c1ull,	0x459f759f30afaf75ull,	0x84a563a5e7424263ull,
		0x4050305070202030ull,	0xd12e1a2ecbe5e51aull,	0xe1120e12effdfd0eull,	0x65b76db708bfbf6dull,
		0x19d44cd45581814cull,	0x303c143c24181814ull,	0x4c5f355f79262635ull,	0x9d712f71b2c3c32full,
		0x6738e13886bebee1ull,	0x6afda2fdc83535a2ull,	0x0b4fcc4fc78888ccull,	0x5c4b394b652e2e39ull,
		0x3df957f96a939357ull,	0xaa0df20d585555f2ull,	0xe39d829d61fcfc82ull,	0xf4c947c9b37a7a47ull,
		0x8befacef27c8c8acull,	0x6f32e73288babae7ull,	0x647d2b7d4f32322bull,	0xd7a495a442e6e695ull,
		0x9bfba0fb3bc0c0a0ull,	0x32b398b3aa191998ull,	0x2768d168f69e9ed1ull,	0x5d817f8122a3a37full,
		0x88aa66aaee444466ull,	0xa8827e82d654547eull,	0x76e6abe6dd3b3babull,	0x169e839e950b0b83ull,
		0x0345ca45c98c8ccaull,	0x957b297bbcc7c729ull,	0xd66ed36e056b6bd3ull,	0x50443c446c28283cull,
		0x558b798b2ca7a779ull,	0x633de23d81bcbce2ull,	0x2c271d273116161dull,	0x419a769a37adad76ull,
		0xad4d3b4d96dbdb3bull,	0xc8fa56fa9e646456ull,	0xe8d24ed2a674744eull,	0x28221e223614141eull,
		0x3f76db76e49292dbull,	0x181e0a1e120c0c0aull,	0x90b46cb4fc48486cull,	0x6b37e4378fb8b8e4ull,
		0x25e75de7789f9f5dull,	0x61b26eb20fbdbd6eull,	0x862aef2a694343efull,	0x93f1a6f135c4c4a6ull,
		0x72e3a8e3da3939a8ull,	0x62f7a4f7c63131a4ull,	0xbd5937598ad3d337ull,	0xff868b8674f2f28bull,
		0xb156325683d5d532ull,	0x0dc543c54e8b8b43ull,	0xdceb59eb856e6e59ull,	0xafc2b7c218dadab7ull,
		0x028f8c8f8e01018cull,	0x79ac64ac1db1b164ull,	0x236dd26df19c9cd2ull,	0x923be03b724949e0ull,
		0xabc7b4c71fd8d8b4ull,	0x4315fa15b9acacfaull,	0xfd090709faf3f307ull,	0x856f256fa0cfcf25ull,
		0x8feaafea20cacaafull,	0xf3898e897df4f48eull,	0x8e20e920674747e9ull,	0x2028182838101018ull,
		0xde64d5640b6f6fd5ull,	0xfb83888373f0f088ull,	0x94b16fb1fb4a4a6full,	0xb8967296ca5c5c72ull,
		0x706c246c54383824ull,	0xae08f1085f5757f1ull,	0xe652c752217373c7ull,	0x35f351f364979751ull,
		0x8d652365aecbcb23ull,	0x59847c8425a1a17cull,	0xcbbf9cbf57e8e89cull,	0x7c6321635d3e3e21ull,
		0x377cdd7cea9696ddull,	0xc27fdc7f1e6161dcull,	0x1a9186919c0d0d86ull,	0x1e9485949b0f0f85ull,
		0xdbab90ab4be0e090ull,	0xf8c642c6ba7c7c42ull,	0xe257c457267171c4ull,	0x83e5aae529ccccaaull,
		0x3b73d873e39090d8ull,	0x0c0f050f09060605ull,	0xf5030103f4f7f701ull,	0x383612362a1c1c12ull,
		0x9ffea3fe3cc2c2a3ull,	0xd4e15fe18b6a6a5full,	0x4710f910beaeaef9ull,	0xd26bd06b026969d0ull,
		0x2ea891a8bf171791ull,	0x29e858e871999958ull,	0x74692769533a3a27ull,	0x4ed0b9d0f72727b9ull,
		0xa948384891d9d938ull,	0xcd351335deebeb13ull,	0x56ceb3cee52b2bb3ull,	0x4455335577222233ull,
		0xbfd6bbd604d2d2bbull,	0x4990709039a9a970ull,	0x0e80898087070789ull,	0x66f2a7f2c13333a7ull,
		0x5ac1b6c1ec2d2db6ull,	0x786622665a3c3c22ull,	0x2aad92adb8151592ull,	0x89602060a9c9c920ull,
		0x15db49db5c878749ull,	0x4f1aff1ab0aaaaffull,	0xa0887888d8505078ull,	0x518e7a8e2ba5a57aull,
		0x068a8f8a8903038full,	0xb213f8134a5959f8ull,	0x129b809b92090980ull,	0x34391739231a1a17ull,
		0xca75da75106565daull,	0xb553315384d7d731ull,	0x1351c651d58484c6ull,	0xbbd3b8d303d0d0b8ull,
		0x1f5ec35edc8282c3ull,	0x52cbb0cbe22929b0ull,	0xb4997799c35a5a77ull,	0x3c3311332d1e1e11ull,
		0xf646cb463d7b7bcbull,	0x4b1ffc1fb7a8a8fcull,	0xda61d6610c6d6dd6ull,	0x584e3a4e622c2c3aull
	},
	{
		0xf4a5f432c6c6a597ull,	0x9784976ff8f884ebull,	0xb099b05eeeee99c7ull,	0x8c8d8c7af6f68df7ull,
		0x170d17e8ffff0de5ull,	0xdcbddc0ad6d6bdb7ull,	0xc8b1c816dedeb1a7ull,	0xfc54fc6d91915439ull,
		0xf050f090606050c0ull,	0x0503050702020304ull,	0xe0a9e02ececea987ull,	0x877d87d156567dacull,
		0x2b192bcce7e719d5ull,	0xa662a613b5b56271ull,	0x31e6317c4d4de69aull,	0xb59ab559ecec9ac3ull,
		0xcf45cf408f8f4505ull,	0xbc9dbca31f1f9d3eull,	0xc040c04989894009ull,	0x92879268fafa87efull,
		0x3f153fd0efef15c5ull,	0x26eb2694b2b2eb7full,	0x40c940ce8e8ec907ull,	0x1d0b1de6fbfb0bedull,
		0x2fec2f6e4141ec82ull,	0xa967a91ab3b3677dull,	0x1cfd1c435f5ffdbeull,	0x25ea25604545ea8aull,
		0xdabfdaf92323bf46ull,	0x02f702515353f7a6ull,	0xa196a145e4e496d3ull,	0xed5bed769b9b5b2dull,
		0x5dc25d287575c2eaull,	0x241c24c5e1e11cd9ull,	0xe9aee9d43d3dae7aull,	0xbe6abef24c4c6a98ull,
		0xee5aee826c6c5ad8ull,	0xc341c3bd7e7e41fcull,	0x060206f3f5f502f1ull,	0xd14fd15283834f1dull,
		0xe45ce48c68685cd0ull,	0x07f407565151f4a2ull,	0x5c345c8dd1d134b9ull,	0x180818e1f9f908e9ull,
		0xae93ae4ce2e293dfull,	0x9573953eabab734dull,	0xf553f597626253c4ull,	0x413f416b2a2a3f54ull,
		0x140c141c08080c10ull,	0xf652f66395955231ull,	0xaf65afe94646658cull,	0xe25ee27f9d9d5e21ull,
		0x7828784830302860ull,	0xf8a1f8cf3737a16eull,	0x110f111b0a0a0f14ull,	0xc4b5c4eb2f2fb55eull,
		0x1b091b150e0e091cull,	0x5a365a7e24243648ull,	0xb69bb6ad1b1b9b36ull,	0x473d4798dfdf3da5ull,
		0x6a266aa7cdcd2681ull,	0xbb69bbf54e4e699cull,	0x4ccd4c337f7fcdfeull,	0xba9fba50eaea9fcfull,
		0x2d1b2d3f12121b24ull,	0xb99eb9a41d1d9e3aull,	0x9c749cc4585874b0ull,	0x722e724634342e68ull,
		0x772d774136362d6cull,	0xcdb2cd11dcdcb2a3ull,	0x29ee299db4b4ee73ull,	0x16fb164d5b5bfbb6ull,
		0x01f601a5a4a4f653ull,	0xd74dd7a176764decull,	0xa361a314b7b76175ull,	0x49ce49347d7dcefaull,
		0x8d7b8ddf52527ba4ull,	0x423e429fdddd3ea1ull,	0x937193cd5e5e71bcull,	0xa297a2b113139726ull,
		0x04f504a2a6a6f557ull,	0xb868b801b9b96869ull,	0x0000000000000000ull,	0x742c74b5c1c12c99ull,
		0xa060a0e040406080ull,	0x211f21c2e3e31fddull,	0x43c8433a7979c8f2ull,	0x2ced2c9ab6b6ed77ull,
		0xd9bed90dd4d4beb3ull,	0xca46ca478d8d4601ull,	0x70d970176767d9ceull,	0xdd4bddaf72724be4ull,
		0x79de79ed9494de33ull,	0x67d467ff9898d42bull,	0x23e82393b0b0e87bull,	0xde4ade5b85854a11ull,
		0xbd6bbd06bbbb6b6dull,	0x7e2a7ebbc5c52a91ull,	0x34e5347b4f4fe59eull,	0x3a163ad7eded16c1ull,
		0x54c554d28686c517ull,	0x62d762f89a9ad72full,	0xff55ff99666655ccull,	0xa794a7b611119422ull,
		0x4acf4ac08a8acf0full,	0x301030d9e9e910c9ull,	0x0a060a0e04040608ull,	0x98819866fefe81e7ull,
		0x0bf00baba0a0f05bull,	0xcc44ccb4787844f0ull,	0xd5bad5f02525ba4aull,	0x3ee33e754b4be396ull,
		0x0ef30eaca2a2f35full,	0x19fe19445d5dfebaull,	0x5bc05bdb8080c01bull,	0x858a858005058a0aull,
		0xecadecd33f3fad7eull,	0xdfbcdffe2121bc42ull,	0xd848d8a8707048e0ull,	0x0c040cfdf1f104f9ull,
		0x7adf7a196363dfc6ull,	0x58c1582f7777c1eeull,	0x9f759f30afaf7545ull,	0xa563a5e742426384ull,
		0x5030507020203040ull,	0x2e1a2ecbe5e51ad1ull,	0x120e12effdfd0ee1ull,	0xb76db708bfbf6d65ull,
		0xd44cd45581814c19ull,	0x3c143c2418181430ull,	0x5f355f792626354cull,	0x712f71b2c3c32f9dull,
		0x38e13886bebee167ull,	0xfda2fdc83535a26aull,	0x4fcc4fc78888cc0bull,	0x4b394b652e2e395cull,
		0xf957f96a9393573dull,	0x0df20d585555f2aaull,	0x9d829d61fcfc82e3ull,	0xc947c9b37a7a47f4ull,
		0xefacef27c8c8ac8bull,	0x32e73288babae76full,	0x7d2b7d4f32322b64ull,	0xa495a442e6e695d7ull,
		0xfba0fb3bc0c0a09bull,	0xb398b3aa19199832ull,	0x68d168f69e9ed127ull,	0x817f8122a3a37f5dull,
		0xaa66aaee44446688ull,	0x827e82d654547ea8ull,	0xe6abe6dd3b3bab76ull,	0x9e839e950b0b8316ull,
		0x45ca45c98c8cca03ull,	0x7b297bbcc7c72995ull,	0x6ed36e056b6bd3d6ull,	0x443c446c28283c50ull,
		0x8b798b2ca7a77955ull,	0x3de23d81bcbce263ull,	0x271d273116161d2cull,	0x9a769a37adad7641ull,
		0x4d3b4d96dbdb3badull,	0xfa56fa9e646456c8ull,	0xd24ed2a674744ee8ull,	0x221e223614141e28ull,
		0x76db76e49292db3full,	0x1e0a1e120c0c0a18ull,	0xb46cb4fc48486c90ull,	0x37e4378fb8b8e46bull,
		0xe75de7789f9f5d25ull,	0xb26eb20fbdbd6e61ull,	0x2aef2a694343ef86ull,	0xf1a6f135c4c4a693ull,
		0xe3a8e3da3939a872ull,	0xf7a4f7c63131a462ull,	0x5937598ad3d337bdull,	0x868b8674f2f28bffull,
		0x56325683d5d532b1ull,	0xc543c54e8b8b430dull,	0xeb59eb856e6e59dcull,	0xc2b7c218dadab7afull,
		0x8f8c8f8e01018c02ull,	0xac64ac1db1b16479ull,	0x6dd26df19c9cd223ull,	0x3be03b724949e092ull,
		0xc7b4c71fd8d8b4abull,	0x15fa15b9acacfa43ull,	0x090709faf3f307fdull,	0x6f256fa0cfcf2585ull,
		0xeaafea20cacaaf8full,	0x898e897df4f48ef3ull,	0x20e920674747e98eull,	0x2818283810101820ull,
		0x64d5640b6f6fd5deull,	0x83888373f0f088fbull,	0xb16fb1fb4a4a6f94ull,	0x967296ca5c5c72b8ull,
		0x6c246c5438382470ull,	0x08f1085f5757f1aeull,	0x52c752217373c7e6ull,	0xf351f36497975135ull,
		0x652365aecbcb238dull,	0x847c8425a1a17c59ull,	0xbf9cbf57e8e89ccbull,	0x6321635d3e3e217cull,
		0x7cdd7cea9696dd37ull,	0x7fdc7f1e6161dcc2ull,	0x9186919c0d0d861aull,	0x9485949b0f0f851eull,
		0xab90ab4be0e090dbull,	0xc642c6ba7c7c42f8ull,	0x57c457267171c4e2ull,	0xe5aae529ccccaa83ull,
		0x73d873e39090d83bull,	0x0f050f090606050cull,	0x030103f4f7f701f5ull,	0x3612362a1c1c1238ull,
		0xfea3fe3cc2c2a39full,	0xe15fe18b6a6a5fd4ull,	0x10f910beaeaef947ull,	0x6bd06b026969d0d2ull,
		0xa891a8bf1717912eull,	0xe858e87199995829ull,	0x692769533a3a2774ull,	0xd0b9d0f72727b94eull,
		0x48384891d9d938a9ull,	0x351335deebeb13cdull,	0xceb3cee52b2bb356ull,	0x5533557722223344ull,
		0xd6bbd604d2d2bbbfull,	0x90709039a9a97049ull,	0x808980870707890eull,	0xf2a7f2c13333a766ull,
		0xc1b6c1ec2d2db65aull,	0x6622665a3c3c2278ull,	0xad92adb81515922aull,	0x602060a9c9c92089ull,
		0xdb49db5c87874915ull,	0x1aff1ab0aaaaff4full,	0x887888d8505078a0ull,	0x8e7a8e2ba5a57a51ull,
		0x8a8f8a8903038f06ull,	0x13f8134a5959f8b2ull,	0x9b809b9209098012ull,	0x391739231a1a1734ull,
		0x75da75106565dacaull,	0x53315384d7d731b5ull,	0x51c651d58484c613ull,	0xd3b8d303d0d0b8bbull,
		0x5ec35edc8282c31full,	0xcbb0cbe22929b052ull,	0x997799c35a5a77b4ull,	0x3311332d1e1e113cull,
		0x46cb463d7b7bcbf6ull,	0x1ffc1fb7a8a8fc4bull,	0x61d6610c6d6dd6daull,	0x4e3a4e622c2c3a58ull
	},
	{
		0xa5f432c6c6a597f4ull,	0x84976ff8f884eb97ull,	0x99b05eeeee99c7b0ull,	0x8d8c7af6f68df78cull,
		0x0d17e8ffff0de517ull,	0xbddc0ad6d6bdb7dcull,	0xb1c816dedeb1a7c8ull,	0x54fc6d91915439fcull,
		0x50f090606050c0f0ull,	0x0305070202030405ull,	0xa9e02ececea987e0ull,	0x7d87d156567dac87ull,
		0x192bcce7e719d52bull,	0x62a613b5b56271a6ull,	0xe6317c4d4de69a31ull,	0x9ab559ecec9ac3b5ull,
		0x45cf408f8f4505cfull,	0x9dbca31f1f9d3ebcull,	0x40c04989894009c0ull,	0x879268fafa87ef92ull,
		0x153fd0efef15c53full,	0xeb2694b2b2eb7f26ull,	0xc940ce8e8ec90740ull,	0x0b1de6fbfb0bed1dull,
		0xec2f6e4141ec822full,	0x67a91ab3b3677da9ull,	0xfd1c435f5ffdbe1cull,	0xea25604545ea8a25ull,
		0xbfdaf92323bf46daull,	0xf702515353f7a602ull,	0x96a145e4e496d3a1ull,	0x5bed769b9b5b2dedull,
		0xc25d287575c2ea5dull,	0x1c24c5e1e11cd924ull,	0xaee9d43d3dae7ae9ull,	0x6abef24c4c6a98beull,
		0x5aee826c6c5ad8eeull,	0x41c3bd7e7e41fcc3ull,	0x0206f3f5f502f106ull,	0x4fd15283834f1dd1ull,
		0x5ce48c68685cd0e4ull,	0xf407565151f4a207ull,	0x345c8dd1d134b95cull,	0x0818e1f9f908e918ull,
		0x93ae4ce2e293dfaeull,	0x73953eabab734d95ull,	0x53f597626253c4f5ull,	0x3f416b2a2a3f5441ull,
		0x0c141c08080c1014ull,	0x52f66395955231f6ull,	0x65afe94646658cafull,	0x5ee27f9d9d5e21e2ull,
		0x2878483030286078ull,	0xa1f8cf3737a16ef8ull,	0x0f111b0a0a0f1411ull,	0xb5c4eb2f2fb55ec4ull,
		0x091b150e0e091c1bull,	0x365a7e242436485aull,	0x9bb6ad1b1b9b36b6ull,	0x3d4798dfdf3da547ull,
		0x266aa7cdcd26816aull,	0x69bbf54e4e699cbbull,	0xcd4c337f7fcdfe4cull,	0x9fba50eaea9fcfbaull,
		0x1b2d3f12121b242dull,	0x9eb9a41d1d9e3ab9ull,	0x749cc4585874b09cull,	0x2e724634342e6872ull,
		0x2d774136362d6c77ull,	0xb2cd11dcdcb2a3cdull,	0xee299db4b4ee7329ull,	0xfb164d5b5bfbb616ull,
		0xf601a5a4a4f65301ull,	0x4dd7a176764decd7ull,	0x61a314b7b76175a3ull,	0xce49347d7dcefa49ull,
		0x7b8ddf52527ba48dull,	0x3e429fdddd3ea142ull,	0x7193cd5e5e71bc93ull,	0x97a2b113139726a2ull,
		0xf504a2a6a6f55704ull,	0x68b801b9b96869b8ull,	0x0000000000000000ull,	0x2c74b5c1c12c9974ull,
		0x60a0e040406080a0ull,	0x1f21c2e3e31fdd21ull,	0xc8433a7979c8f243ull,	0xed2c9ab6b6ed772cull,
		0xbed90dd4d4beb3d9ull,	0x46ca478d8d4601caull,	0xd970176767d9ce70ull,	0x4bddaf72724be4ddull,
		0xde79ed9494de3379ull,	0xd467ff9898d42b67ull,	0xe82393b0b0e87b23ull,	0x4ade5b85854a11deull,
		0x6bbd06bbbb6b6dbdull,	0x2a7ebbc5c52a917eull,	0xe5347b4f4fe59e34ull,	0x163ad7eded16c13aull,
		0xc554d28686c51754ull,	0xd762f89a9ad72f62ull,	0x55ff99666655ccffull,	0x94a7b611119422a7ull,
		0xcf4ac08a8acf0f4aull,	0x1030d9e9e910c930ull,	0x060a0e040406080aull,	0x819866fefe81e798ull,
		0xf00baba0a0f05b0bull,	0x44ccb4787844f0ccull,	0xbad5f02525ba4ad5ull,	0xe33e754b4be3963eull,
		0xf30eaca2a2f35f0eull,	0xfe19445d5dfeba19ull,	0xc05bdb8080c01b5bull,	0x8a858005058a0a85ull,
		0xadecd33f3fad7eecull,	0xbcdffe2121bc42dfull,	0x48d8a8707048e0d8ull,	0x040cfdf1f104f90cull,
		0xdf7a196363dfc67aull,	0xc1582f7777c1ee58ull,	0x759f30afaf75459full,	0x63a5e742426384a5ull,
		0x3050702020304050ull,	0x1a2ecbe5e51ad12eull,	0x0e12effdfd0ee112ull,	0x6db708bfbf6d65b7ull,
		0x4cd45581814c19d4ull,	0x143c24181814303cull,	0x355f792626354c5full,	0x2f71b2c3c32f9d71ull,
		0xe13886bebee16738ull,	0xa2fdc83535a26afdull,	0xcc4fc78888cc0b4full,	0x394b652e2e395c4bull,
		0x57f96a9393573df9ull,	0xf20d585555f2aa0dull,	0x829d61fcfc82e39dull,	0x47c9b37a7a47f4c9ull,
		0xacef27c8c8ac8befull,	0xe73288babae76f32ull,	0x2b7d4f32322b647dull,	0x95a442e6e695d7a4ull,
		0xa0fb3bc0c0a09bfbull,	0x98b3aa19199832b3ull,	0xd168f69e9ed12768ull,	0x7f8122a3a37f5d81ull,
		0x66aaee44446688aaull,	0x7e82d654547ea882ull,	0xabe6dd3b3bab76e6ull,	0x839e950b0b83169eull,
		0xca45c98c8cca0345ull,	0x297bbcc7c729957bull,	0xd36e056b6bd3d66eull,	0x3c446c28283c5044ull,
		0x798b2ca7a779558bull,	0xe23d81bcbce2633dull,	0x1d273116161d2c27ull,	0x769a37adad76419aull,
		0x3b4d96dbdb3bad4dull,	0x56fa9e646456c8faull,	0x4ed2a674744ee8d2ull,	0x1e223614141e2822ull,
		0xdb76e49292db3f76ull,	0x0a1e120c0c0a181eull,	0x6cb4fc48486c90b4ull,	0xe4378fb8b8e46b37ull,
		0x5de7789f9f5d25e7ull,	0x6eb20fbdbd6e61b2ull,	0xef2a694343ef862aull,	0xa6f135c4c4a693f1ull,
		0xa8e3da3939a872e3ull,	0xa4f7c63131a462f7ull,	0x37598ad3d337bd59ull,	0x8b8674f2f28bff86ull,
		0x325683d5d532b156ull,	0x43c54e8b8b430dc5ull,	0x59eb856e6e59dcebull,	0xb7c218dadab7afc2ull,
		0x8c8f8e01018c028full,	0x64ac1db1b16479acull,	0xd26df19c9cd2236dull,	0xe03b724949e0923bull,
		0xb4c71fd8d8b4abc7ull,	0xfa15b9acacfa4315ull,	0x0709faf3f307fd09ull,	0x256fa0cfcf25856full,
		0xafea20cacaaf8feaull,	0x8e897df4f48ef389ull,	0xe920674747e98e20ull,	0x1828381010182028ull,
		0xd5640b6f6fd5de64ull,	0x888373f0f088fb83ull,	0x6fb1fb4a4a6f94b1ull,	0x7296ca5c5c72b896ull,
		0x246c54383824706cull,	0xf1085f5757f1ae08ull,	0xc752217373c7e652ull,	0x51f36497975135f3ull,
		0x2365aecbcb238d65ull,	0x7c8425a1a17c5984ull,	0x9cbf57e8e89ccbbfull,	0x21635d3e3e217c63ull,
		0xdd7cea9696dd377cull,	0xdc7f1e6161dcc27full,	0x86919c0d0d861a91ull,	0x85949b0f0f851e94ull,
		0x90ab4be0e090dbabull,	0x42c6ba7c7c42f8c6ull,	0xc457267171c4e257ull,	0xaae529ccccaa83e5ull,
		0xd873e39090d83b73ull,	0x050f090606050c0full,	0x0103f4f7f701f503ull,	0x12362a1c1c123836ull,
		0xa3fe3cc2c2a39ffeull,	0x5fe18b6a6a5fd4e1ull,	0xf910beaeaef94710ull,	0xd06b026969d0d26bull,
		0x91a8bf1717912ea8ull,	0x58e87199995829e8ull,	0x2769533a3a277469ull,	0xb9d0f72727b94ed0ull,
		0x384891d9d938a948ull,	0x1335deebeb13cd35ull,	0xb3cee52b2bb356ceull,	0x3355772222334455ull,
		0xbbd604d2d2bbbfd6ull,	0x709039a9a9704990ull,	0x8980870707890e80ull,	0xa7f2c13333a766f2ull,
		0xb6c1ec2d2db65ac1ull,	0x22665a3c3c227866ull,	0x92adb81515922aadull,	0x2060a9c9c9208960ull,
		0x49db5c87874915dbull,	0xff1ab0aaaaff4f1aull,	0x7888d8505078a088ull,	0x7a8e2ba5a57a518eull,
		0x8f8a8903038f068aull,	0xf8134a5959f8b213ull,	0x809b92090980129bull,	0x1739231a1a173439ull,
		0xda75106565daca75ull,	0x315384d7d731b553ull,	0xc651d58484c61351ull,	0xb8d303d0d0b8bbd3ull,
		0xc35edc8282c31f5eull,	0xb0cbe22929b052cbull,	0x7799c35a5a77b499ull,	0x11332d1e1e113c33ull,
		0xcb463d7b7bcbf646ull,	0xfc1fb7a8a8fc4b1full,	0xd6610c6d6dd6da61ull,	0x3a4e622c2c3a584eull
	},
	{
		0xf432c6c6a597f4a5ull,	0x976ff8f884eb9784ull,	0xb05eeeee99c7b099ull,	0x8c7af6f68df78c8dull,
		0x17e8ffff0de5170dull,	0xdc0ad6d6bdb7dcbdull,	0xc816dedeb1a7c8b1ull,	0xfc6d91915439fc54ull,
		0xf090606050c0f050ull,	0x0507020203040503ull,	0xe02ececea987e0a9ull,	0x87d156567dac877dull,
		0x2bcce7e719d52b19ull,	0xa613b5b56271a662ull,	0x317c4d4de69a31e6ull,	0xb559ecec9ac3b59aull,
		0xcf408f8f4505cf45ull,	0xbca31f1f9d3ebc9dull,	0xc04989894009c040ull,	0x9268fafa87ef9287ull,
		0x3fd0efef15c53f15ull,	0x2694b2b2eb7f26ebull,	0x40ce8e8ec90740c9ull,	0x1de6fbfb0bed1d0bull,
		0x2f6e4141ec822fecull,	0xa91ab3b3677da967ull,	0x1c435f5ffdbe1cfdull,	0x25604545ea8a25eaull,
		0xdaf92323bf46dabfull,	0x02515353f7a602f7ull,	0xa145e4e496d3a196ull,	0xed769b9b5b2ded5bull,
		0x5d287575c2ea5dc2ull,	0x24c5e1e11cd9241cull,	0xe9d43d3dae7ae9aeull,	0xbef24c4c6a98be6aull,
		0xee826c6c5ad8ee5aull,	0xc3bd7e7e41fcc341ull,	0x06f3f5f502f10602ull,	0xd15283834f1dd14full,
		0xe48c68685cd0e45cull,	0x07565151f4a207f4ull,	0x5c8dd1d134b95c34ull,	0x18e1f9f908e91808ull,
		0xae4ce2e293dfae93ull,	0x953eabab734d9573ull,	0xf597626253c4f553ull,	0x416b2a2a3f54413full,
		0x141c08080c10140cull,	0xf66395955231f652ull,	0xafe94646658caf65ull,	0xe27f9d9d5e21e25eull,
		0x7848303028607828ull,	0xf8cf3737a16ef8a1ull,	0x111b0a0a0f14110full,	0xc4eb2f2fb55ec4b5ull,
		0x1b150e0e091c1b09ull,	0x5a7e242436485a36ull,	0xb6ad1b1b9b36b69bull,	0x4798dfdf3da5473dull,
		0x6aa7cdcd26816a26ull,	0xbbf54e4e699cbb69ull,	0x4c337f7fcdfe4ccdull,	0xba50eaea9fcfba9full,
		0x2d3f12121b242d1bull,	0xb9a41d1d9e3ab99eull,	0x9cc4585874b09c74ull,	0x724634342e68722eull,
		0x774136362d6c772dull,	0xcd11dcdcb2a3cdb2ull,	0x299db4b4ee7329eeull,	0x164d5b5bfbb616fbull,
		0x01a5a4a4f65301f6ull,	0xd7a176764decd74dull,	0xa314b7b76175a361ull,	0x49347d7dcefa49ceull,
		0x8ddf52527ba48d7bull,	0x429fdddd3ea1423eull,	0x93cd5e5e71bc9371ull,	0xa2b113139726a297ull,
		0x04a2a6a6f55704f5ull,	0xb801b9b96869b868ull,	0x0000000000000000ull,	0x74b5c1c12c99742cull,
		0xa0e040406080a060ull,	0x21c2e3e31fdd211full,	0x433a7979c8f243c8ull,	0x2c9ab6b6ed772cedull,
		0xd90dd4d4beb3d9beull,	0xca478d8d4601ca46ull,	0x70176767d9ce70d9ull,	0xddaf72724be4dd4bull,
		0x79ed9494de3379deull,	0x67ff9898d42b67d4ull,	0x2393b0b0e87b23e8ull,	0xde5b85854a11de4aull,
		0xbd06bbbb6b6dbd6bull,	0x7ebbc5c52a917e2aull,	0x347b4f4fe59e34e5ull,	0x3ad7eded16c13a16ull,
		0x54d28686c51754c5ull,	0x62f89a9ad72f62d7ull,	0xff99666655ccff55ull,	0xa7b611119422a794ull,
		0x4ac08a8acf0f4acfull,	0x30d9e9e910c93010ull,	0x0a0e040406080a06ull,	0x9866fefe81e79881ull,
		0x0baba0a0f05b0bf0ull,	0xccb4787844f0cc44ull,	0xd5f02525ba4ad5baull,	0x3e754b4be3963ee3ull,
		0x0eaca2a2f35f0ef3ull,	0x19445d5dfeba19feull,	0x5bdb8080c01b5bc0ull,	0x858005058a0a858aull,
		0xecd33f3fad7eecadull,	0xdffe2121bc42dfbcull,	0xd8a8707048e0d848ull,	0x0cfdf1f104f90c04ull,
		0x7a196363dfc67adfull,	0x582f7777c1ee58c1ull,	0x9f30afaf75459f75ull,	0xa5e742426384a563ull,
		0x5070202030405030ull,	0x2ecbe5e51ad12e1aull,	0x12effdfd0ee1120eull,	0xb708bfbf6d65b76dull,
		0xd45581814c19d44cull,	0x3c24181814303c14ull,	0x5f792626354c5f35ull,	0x71b2c3c32f9d712full,
		0x3886bebee16738e1ull,	0xfdc83535a26afda2ull,	0x4fc78888cc0b4fccull,	0x4b652e2e395c4b39ull,
		0xf96a9393573df957ull,	0x0d585555f2aa0df2ull,	0x9d61fcfc82e39d82ull,	0xc9b37a7a47f4c947ull,
		0xef27c8c8ac8befacull,	0x3288babae76f32e7ull,	0x7d4f32322b647d2bull,	0xa442e6e695d7a495ull,
		0xfb3bc0c0a09bfba0ull,	0xb3aa19199832b398ull,	0x68f69e9ed12768d1ull,	0x8122a3a37f5d817full,
		0xaaee44446688aa66ull,	0x82d654547ea8827eull,	0xe6dd3b3bab76e6abull,	0x9e950b0b83169e83ull,
		0x45c98c8cca0345caull,	0x7bbcc7c729957b29ull,	0x6e056b6bd3d66ed3ull,	0x446c28283c50443cull,
		0x8b2ca7a779558b79ull,	0x3d81bcbce2633de2ull,	0x273116161d2c271dull,	0x9a37adad76419a76ull,
		0x4d96dbdb3bad4d3bull,	0xfa9e646456c8fa56ull,	0xd2a674744ee8d24eull,	0x223614141e28221eull,
		0x76e49292db3f76dbull,	0x1e120c0c0a181e0aull,	0xb4fc48486c90b46cull,	0x378fb8b8e46b37e4ull,
		0xe7789f9f5d25e75dull,	0xb20fbdbd6e61b26eull,	0x2a694343ef862aefull,	0xf135c4c4a693f1a6ull,
		0xe3da3939a872e3a8ull,	0xf7c63131a462f7a4ull,	0x598ad3d337bd5937ull,	0x8674f2f28bff868bull,
		0x5683d5d532b15632ull,	0xc54e8b8b430dc543ull,	0xeb856e6e59dceb59ull,	0xc218dadab7afc2b7ull,
		0x8f8e01018c028f8cull,	0xac1db1b16479ac64ull,	0x6df19c9cd2236dd2ull,	0x3b724949e0923be0ull,
		0xc71fd8d8b4abc7b4ull,	0x15b9acacfa4315faull,	0x09faf3f307fd0907ull,	0x6fa0cfcf25856f25ull,
		0xea20cacaaf8feaafull,	0x897df4f48ef3898eull,	0x20674747e98e20e9ull,	0x2838101018202818ull,
		0x640b6f6fd5de64d5ull,	0x8373f0f088fb8388ull,	0xb1fb4a4a6f94b16full,	0x96ca5c5c72b89672ull,
		0x6c54383824706c24ull,	0x085f5757f1ae08f1ull,	0x52217373c7e652c7ull,	0xf36497975135f351ull,
		0x65aecbcb238d6523ull,	0x8425a1a17c59847cull,	0xbf57e8e89ccbbf9cull,	0x635d3e3e217c6321ull,
		0x7cea9696dd377cddull,	0x7f1e6161dcc27fdcull,	0x919c0d0d861a9186ull,	0x949b0f0f851e9485ull,
		0xab4be0e090dbab90ull,	0xc6ba7c7c42f8c642ull,	0x57267171c4e257c4ull,	0xe529ccccaa83e5aaull,
		0x73e39090d83b73d8ull,	0x0f090606050c0f05ull,	0x03f4f7f701f50301ull,	0x362a1c1c12383612ull,
		0xfe3cc2c2a39ffea3ull,	0xe18b6a6a5fd4e15full,	0x10beaeaef94710f9ull,	0x6b026969d0d26bd0ull,
		0xa8bf1717912ea891ull,	0xe87199995829e858ull,	0x69533a3a27746927ull,	0xd0f72727b94ed0b9ull,
		0x4891d9d938a94838ull,	0x35deebeb13cd3513ull,	0xcee52b2bb356ceb3ull,	0x5577222233445533ull,
		0xd604d2d2bbbfd6bbull,	0x9039a9a970499070ull,	0x80870707890e8089ull,	0xf2c13333a766f2a7ull,
		0xc1ec2d2db65ac1b6ull,	0x665a3c3c22786622ull,	0xadb81515922aad92ull,	0x60a9c9c920896020ull,
		0xdb5c87874915db49ull,	0x1ab0aaaaff4f1affull,	0x88d8505078a08878ull,	0x8e2ba5a57a518e7aull,
		0x8a8903038f068a8full,	0x134a5959f8b213f8ull,	0x9b92090980129b80ull,	0x39231a1a17343917ull,
		0x75106565daca75daull,	0x5384d7d731b55331ull,	0x51d58484c61351c6ull,	0xd303d0d0b8bbd3b8ull,
		0x5edc8282c31f5ec3ull,	0xcbe22929b052cbb0ull,	0x99c35a5a77b49977ull,	0x332d1e1e113c3311ull,
		0x463d7b7bcbf646cbull,	0x1fb7a8a8fc4b1ffcull,	0x610c6d6dd6da61d6ull,	0x4e622c2c3a584e3aull
	},
	{
		0x32c6c6a597f4a5f4ull,	0x6ff8f884eb978497ull,	0x5eeeee99c7b099b0ull,	0x7af6f68df78c8d8cull,
		0xe8ffff0de5170d17ull,	0x0ad6d6bdb7dcbddcull,	0x16dedeb1a7c8b1c8ull,	0x6d91915439fc54fcull,
		0x90606050c0f050f0ull,	0x0702020304050305ull,	0x2ececea987e0a9e0ull,	0xd156567dac877d87ull,
		0xcce7e719d52b192bull,	0x13b5b56271a662a6ull,	0x7c4d4de69a31e631ull,	0x59ecec9ac3b59ab5ull,
		0x408f8f4505cf45cfull,	0xa31f1f9d3ebc9dbcull,	0x4989894009c040c0ull,	0x68fafa87ef928792ull,
		0xd0efef15c53f153full,	0x94b2b2eb7f26eb26ull,	0xce8e8ec90740c940ull,	0xe6fbfb0bed1d0b1dull,
		0x6e4141ec822fec2full,	0x1ab3b3677da967a9ull,	0x435f5ffdbe1cfd1cull,	0x604545ea8a25ea25ull,
		0xf92323bf46dabfdaull,	0x515353f7a602f702ull,	0x45e4e496d3a196a1ull,	0x769b9b5b2ded5bedull,
		0x287575c2ea5dc25dull,	0xc5e1e11cd9241c24ull,	0xd43d3dae7ae9aee9ull,	0xf24c4c6a98be6abeull,
		0x826c6c5ad8ee5aeeull,	0xbd7e7e41fcc341c3ull,	0xf3f5f502f1060206ull,	0x5283834f1dd14fd1ull,
		0x8c68685cd0e45ce4ull,	0x565151f4a207f407ull,	0x8dd1d134b95c345cull,	0xe1f9f908e9180818ull,
		0x4ce2e293dfae93aeull,	0x3eabab734d957395ull,	0x97626253c4f553f5ull,	0x6b2a2a3f54413f41ull,
		0x1c08080c10140c14ull,	0x6395955231f652f6ull,	0xe94646658caf65afull,	0x7f9d9d5e21e25ee2ull,
		0x4830302860782878ull,	0xcf3737a16ef8a1f8ull,	0x1b0a0a0f14110f11ull,	0xeb2f2fb55ec4b5c4ull,
		0x150e0e091c1b091bull,	0x7e242436485a365aull,	0xad1b1b9b36b69bb6ull,	0x98dfdf3da5473d47ull,
		0xa7cdcd26816a266aull,	0xf54e4e699cbb69bbull,	0x337f7fcdfe4ccd4cull,	0x50eaea9fcfba9fbaull,
		0x3f12121b242d1b2dull,	0xa41d1d9e3ab99eb9ull,	0xc4585874b09c749cull,	0x4634342e68722e72ull,
		0x4136362d6c772d77ull,	0x11dcdcb2a3cdb2cdull,	0x9db4b4ee7329ee29ull,	0x4d5b5bfbb616fb16ull,
		0xa5a4a4f65301f601ull,	0xa176764decd74dd7ull,	0x14b7b76175a361a3ull,	0x347d7dcefa49ce49ull,
		0xdf52527ba48d7b8dull,	0x9fdddd3ea1423e42ull,	0xcd5e5e71bc937193ull,	0xb113139726a297a2ull,
		0xa2a6a6f55704f504ull,	0x01b9b96869b868b8ull,	0x0000000000000000ull,	0xb5c1c12c99742c74ull,
		0xe040406080a060a0ull,	0xc2e3e31fdd211f21ull,	0x3a7979c8f243c843ull,	0x9ab6b6ed772ced2cull,
		0x0dd4d4beb3d9bed9ull,	0x478d8d4601ca46caull,	0x176767d9ce70d970ull,	0xaf72724be4dd4bddull,
		0xed9494de3379de79ull,	0xff9898d42b67d467ull,	0x93b0b0e87b23e823ull,	0x5b85854a11de4adeull,
		0x06bbbb6b6dbd6bbdull,	0xbbc5c52a917e2a7eull,	0x7b4f4fe59e34e534ull,	0xd7eded16c13a163aull,
		0xd28686c51754c554ull,	0xf89a9ad72f62d762ull,	0x99666655ccff55ffull,	0xb611119422a794a7ull,
		0xc08a8acf0f4acf4aull,	0xd9e9e910c9301030ull,	0x0e040406080a060aull,	0x66fefe81e7988198ull,
		0xaba0a0f05b0bf00bull,	0xb4787844f0cc44ccull,	0xf02525ba4ad5bad5ull,	0x754b4be3963ee33eull,
		0xaca2a2f35f0ef30eull,	0x445d5dfeba19fe19ull,	0xdb8080c01b5bc05bull,	0x8005058a0a858a85ull,
		0xd33f3fad7eecadecull,	0xfe2121bc42dfbcdfull,	0xa8707048e0d848d8ull,	0xfdf1f104f90c040cull,
		0x196363dfc67adf7aull,	0x2f7777c1ee58c158ull,	0x30afaf75459f759full,	0xe742426384a563a5ull,
		0x7020203040503050ull,	0xcbe5e51ad12e1a2eull,	0xeffdfd0ee1120e12ull,	0x08bfbf6d65b76db7ull,
		0x5581814c19d44cd4ull,	0x24181814303c143cull,	0x792626354c5f355full,	0xb2c3c32f9d712f71ull,
		0x86bebee16738e138ull,	0xc83535a26afda2fdull,	0xc78888cc0b4fcc4full,	0x652e2e395c4b394bull,
		0x6a9393573df957f9ull,	0x585555f2aa0df20dull,	0x61fcfc82e39d829dull,	0xb37a7a47f4c947c9ull,
		0x27c8c8ac8befacefull,	0x88babae76f32e732ull,	0x4f32322b647d2b7dull,	0x42e6e695d7a495a4ull,
		0x3bc0c0a09bfba0fbull,	0xaa19199832b398b3ull,	0xf69e9ed12768d168ull,	0x22a3a37f5d817f81ull,
		0xee44446688aa66aaull,	0xd654547ea8827e82ull,	0xdd3b3bab76e6abe6ull,	0x950b0b83169e839eull,
		0xc98c8cca0345ca45ull,	0xbcc7c729957b297bull,	0x056b6bd3d66ed36eull,	0x6c28283c50443c44ull,
		0x2ca7a779558b798bull,	0x81bcbce2633de23dull,	0x3116161d2c271d27ull,	0x37adad76419a769aull,
		0x96dbdb3bad4d3b4dull,	0x9e646456c8fa56faull,	0xa674744ee8d24ed2ull,	0x3614141e28221e22ull,
		0xe49292db3f76db76ull,	0x120c0c0a181e0a1eull,	0xfc48486c90b46cb4ull,	0x8fb8b8e46b37e437ull,
		0x789f9f5d25e75de7ull,	0x0fbdbd6e61b26eb2ull,	0x694343ef862aef2aull,	0x35c4c4a693f1a6f1ull,
		0xda3939a872e3a8e3ull,	0xc63131a462f7a4f7ull,	0x8ad3d337bd593759ull,	0x74f2f28bff868b86ull,
		0x83d5d532b1563256ull,	0x4e8b8b430dc543c5ull,	0x856e6e59dceb59ebull,	0x18dadab7afc2b7c2ull,
		0x8e01018c028f8c8full,	0x1db1b16479ac64acull,	0xf19c9cd2236dd26dull,	0x724949e0923be03bull,
		0x1fd8d8b4abc7b4c7ull,	0xb9acacfa4315fa15ull,	0xfaf3f307fd090709ull,	0xa0cfcf25856f256full,
		0x20cacaaf8feaafeaull,	0x7df4f48ef3898e89ull,	0x674747e98e20e920ull,	0x3810101820281828ull,
		0x0b6f6fd5de64d564ull,	0x73f0f088fb838883ull,	0xfb4a4a6f94b16fb1ull,	0xca5c5c72b8967296ull,
		0x54383824706c246cull,	0x5f5757f1ae08f108ull,	0x217373c7e652c752ull,	0x6497975135f351f3ull,
		0xaecbcb238d652365ull,	0x25a1a17c59847c84ull,	0x57e8e89ccbbf9cbfull,	0x5d3e3e217c632163ull,
		0xea9696dd377cdd7cull,	0x1e6161dcc27fdc7full,	0x9c0d0d861a918691ull,	0x9b0f0f851e948594ull,
		0x4be0e090dbab90abull,	0xba7c7c42f8c642c6ull,	0x267171c4e257c457ull,	0x29ccccaa83e5aae5ull,
		0xe39090d83b73d873ull,	0x090606050c0f050full,	0xf4f7f701f5030103ull,	0x2a1c1c1238361236ull,
		0x3cc2c2a39ffea3feull,	0x8b6a6a5fd4e15fe1ull,	0xbeaeaef94710f910ull,	0x026969d0d26bd06bull,
		0xbf1717912ea891a8ull,	0x7199995829e858e8ull,	0x533a3a2774692769ull,	0xf72727b94ed0b9d0ull,
		0x91d9d938a9483848ull,	0xdeebeb13cd351335ull,	0xe52b2bb356ceb3ceull,	0x7722223344553355ull,
		0x04d2d2bbbfd6bbd6ull,	0x39a9a97049907090ull,	0x870707890e808980ull,	0xc13333a766f2a7f2ull,
		0xec2d2db65ac1b6c1ull,	0x5a3c3c2278662266ull,	0xb81515922aad92adull,	0xa9c9c92089602060ull,
		0x5c87874915db49dbull,	0xb0aaaaff4f1aff1aull,	0xd8505078a0887888ull,	0x2ba5a57a518e7a8eull,
		0x8903038f068a8f8aull,	0x4a5959f8b213f813ull,	0x92090980129b809bull,	0x231a1a1734391739ull,
		0x106565daca75da75ull,	0x84d7d731b5533153ull,	0xd58484c61351c651ull,	0x03d0d0b8bbd3b8d3ull,
		0xdc8282c31f5ec35eull,	0xe22929b052cbb0cbull,	0xc35a5a77b4997799ull,	0x2d1e1e113c331133ull,
		0x3d7b7bcbf646cb46ull,	0xb7a8a8fc4b1ffc1full,	0x0c6d6dd6da61d661ull,	0x622c2c3a584e3a4eull
	},
	{
		0xc6c6a597f4a5f432ull,	0xf8f884eb9784976full,	0xeeee99c7b099b05eull,	0xf6f68df78c8d8c7aull,
		0xffff0de5170d17e8ull,	0xd6d6bdb7dcbddc0aull,	0xdedeb1a7c8b1c816ull,	0x91915439fc54fc6dull,
		0x606050c0f050f090ull,	0x0202030405030507ull,	0xcecea987e0a9e02eull,	0x56567dac877d87d1ull,
		0xe7e719d52b192bccull,	0xb5b56271a662a613ull,	0x4d4de69a31e6317cull,	0xecec9ac3b59ab559ull,
		0x8f8f4505cf45cf40ull,	0x1f1f9d3ebc9dbca3ull,	0x89894009c040c049ull,	0xfafa87ef92879268ull,
		0xefef15c53f153fd0ull,	0xb2b2eb7f26eb2694ull,	0x8e8ec90740c940ceull,	0xfbfb0bed1d0b1de6ull,
		0x4141ec822fec2f6eull,	0xb3b3677da967a91aull,	0x5f5ffdbe1cfd1c43ull,	0x4545ea8a25ea2560ull,
		0x2323bf46dabfdaf9ull,	0x5353f7a602f70251ull,	0xe4e496d3a196a145ull,	0x9b9b5b2ded5bed76ull,
		0x7575c2ea5dc25d28ull,	0xe1e11cd9241c24c5ull,	0x3d3dae7ae9aee9d4ull,	0x4c4c6a98be6abef2ull,
		0x6c6c5ad8ee5aee82ull,	0x7e7e41fcc341c3bdull,	0xf5f502f1060206f3ull,	0x83834f1dd14fd152ull,
		0x68685cd0e45ce48cull,	0x5151f4a207f40756ull,	0xd1d134b95c345c8dull,	0xf9f908e9180818e1ull,
		0xe2e293dfae93ae4cull,	0xabab734d9573953eull,	0x626253c4f553f597ull,	0x2a2a3f54413f416bull,
		0x08080c10140c141cull,	0x95955231f652f663ull,	0x4646658caf65afe9ull,	0x9d9d5e21e25ee27full,
		0x3030286078287848ull,	0x3737a16ef8a1f8cfull,	0x0a0a0f14110f111bull,	0x2f2fb55ec4b5c4ebull,
		0x0e0e091c1b091b15ull,	0x242436485a365a7eull,	0x1b1b9b36b69bb6adull,	0xdfdf3da5473d4798ull,
		0xcdcd26816a266aa7ull,	0x4e4e699cbb69bbf5ull,	0x7f7fcdfe4ccd4c33ull,	0xeaea9fcfba9fba50ull,
		0x12121b242d1b2d3full,	0x1d1d9e3ab99eb9a4ull,	0x585874b09c749cc4ull,	0x34342e68722e7246ull,
		0x36362d6c772d7741ull,	0xdcdcb2a3cdb2cd11ull,	0xb4b4ee7329ee299dull,	0x5b5bfbb616fb164dull,
		0xa4a4f65301f601a5ull,	0x76764decd74dd7a1ull,	0xb7b76175a361a314ull,	0x7d7dcefa49ce4934ull,
		0x52527ba48d7b8ddfull,	0xdddd3ea1423e429full,	0x5e5e71bc937193cdull,	0x13139726a297a2b1ull,
		0xa6a6f55704f504a2ull,	0xb9b96869b868b801ull,	0x0000000000000000ull,	0xc1c12c99742c74b5ull,
		0x40406080a060a0e0ull,	0xe3e31fdd211f21c2ull,	0x7979c8f243c8433aull,	0xb6b6ed772ced2c9aull,
		0xd4d4beb3d9bed90dull,	0x8d8d4601ca46ca47ull,	0x6767d9ce70d97017ull,	0x72724be4dd4bddafull,
		0x9494de3379de79edull,	0x9898d42b67d467ffull,	0xb0b0e87b23e82393ull,	0x85854a11de4ade5bull,
		0xbbbb6b6dbd6bbd06ull,	0xc5c52a917e2a7ebbull,	0x4f4fe59e34e5347bull,	0xeded16c13a163ad7ull,
		0x8686c51754c554d2ull,	0x9a9ad72f62d762f8ull,	0x666655ccff55ff99ull,	0x11119422a794a7b6ull,
		0x8a8acf0f4acf4ac0ull,	0xe9e910c9301030d9ull,	0x040406080a060a0eull,	0xfefe81e798819866ull,
		0xa0a0f05b0bf00babull,	0x787844f0cc44ccb4ull,	0x2525ba4ad5bad5f0ull,	0x4b4be3963ee33e75ull,
		0xa2a2f35f0ef30eacull,	0x5d5dfeba19fe1944ull,	0x8080c01b5bc05bdbull,	0x05058a0a858a8580ull,
		0x3f3fad7eecadecd3ull,	0x2121bc42dfbcdffeull,	0x707048e0d848d8a8ull,	0xf1f104f90c040cfdull,
		0x6363dfc67adf7a19ull,	0x7777c1ee58c1582full,	0xafaf75459f759f30ull,	0x42426384a563a5e7ull,
		0x2020304050305070ull,	0xe5e51ad12e1a2ecbull,	0xfdfd0ee1120e12efull,	0xbfbf6d65b76db708ull,
		0x81814c19d44cd455ull,	0x181814303c143c24ull,	0x2626354c5f355f79ull,	0xc3c32f9d712f71b2ull,
		0xbebee16738e13886ull,	0x3535a26afda2fdc8ull,	0x8888cc0b4fcc4fc7ull,	0x2e2e395c4b394b65ull,
		0x9393573df957f96aull,	0x5555f2aa0df20d58ull,	0xfcfc82e39d829d61ull,	0x7a7a47f4c947c9b3ull,
		0xc8c8ac8befacef27ull,	0xbabae76f32e73288ull,	0x32322b647d2b7d4full,	0xe6e695d7a495a442ull,
		0xc0c0a09bfba0fb3bull,	0x19199832b398b3aaull,	0x9e9ed12768d168f6ull,	0xa3a37f5d817f8122ull,
		0x44446688aa66aaeeull,	0x54547ea8827e82d6ull,	0x3b3bab76e6abe6ddull,	0x0b0b83169e839e95ull,
		0x8c8cca0345ca45c9ull,	0xc7c729957b297bbcull,	0x6b6bd3d66ed36e05ull,	0x28283c50443c446cull,
		0xa7a779558b798b2cull,	0xbcbce2633de23d81ull,	0x16161d2c271d2731ull,	0xadad76419a769a37ull,
		0xdbdb3bad4d3b4d96ull,	0x646456c8fa56fa9eull,	0x74744ee8d24ed2a6ull,	0x14141e28221e2236ull,
		0x9292db3f76db76e4ull,	0x0c0c0a181e0a1e12ull,	0x48486c90b46cb4fcull,	0xb8b8e46b37e4378full,
		0x9f9f5d25e75de778ull,	0xbdbd6e61b26eb20full,	0x4343ef862aef2a69ull,	0xc4c4a693f1a6f135ull,
		0x3939a872e3a8e3daull,	0x3131a462f7a4f7c6ull,	0xd3d337bd5937598aull,	0xf2f28bff868b8674ull,
		0xd5d532b156325683ull,	0x8b8b430dc543c54eull,	0x6e6e59dceb59eb85ull,	0xdadab7afc2b7c218ull,
		0x01018c028f8c8f8eull,	0xb1b16479ac64ac1dull,	0x9c9cd2236dd26df1ull,	0x4949e0923be03b72ull,
		0xd8d8b4abc7b4c71full,	0xacacfa4315fa15b9ull,	0xf3f307fd090709faull,	0xcfcf25856f256fa0ull,
		0xcacaaf8feaafea20ull,	0xf4f48ef3898e897dull,	0x4747e98e20e92067ull,	0x1010182028182838ull,
		0x6f6fd5de64d5640bull,	0xf0f088fb83888373ull,	0x4a4a6f94b16fb1fbull,	0x5c5c72b8967296caull,
		0x383824706c246c54ull,	0x5757f1ae08f1085full,	0x7373c7e652c75221ull,	0x97975135f351f364ull,
		0xcbcb238d652365aeull,	0xa1a17c59847c8425ull,	0xe8e89ccbbf9cbf57ull,	0x3e3e217c6321635dull,
		0x9696dd377cdd7ceaull,	0x6161dcc27fdc7f1eull,	0x0d0d861a9186919cull,	0x0f0f851e9485949bull,
		0xe0e090dbab90ab4bull,	0x7c7c42f8c642c6baull,	0x7171c4e257c45726ull,	0xccccaa83e5aae529ull,
		0x9090d83b73d873e3ull,	0x0606050c0f050f09ull,	0xf7f701f5030103f4ull,	0x1c1c12383612362aull,
		0xc2c2a39ffea3fe3cull,	0x6a6a5fd4e15fe18bull,	0xaeaef94710f910beull,	0x6969d0d26bd06b02ull,
		0x1717912ea891a8bfull,	0x99995829e858e871ull,	0x3a3a277469276953ull,	0x2727b94ed0b9d0f7ull,
		0xd9d938a948384891ull,	0xebeb13cd351335deull,	0x2b2bb356ceb3cee5ull,	0x2222334455335577ull,
		0xd2d2bbbfd6bbd604ull,	0xa9a9704990709039ull,	0x0707890e80898087ull,	0x3333a766f2a7f2c1ull,
		0x2d2db65ac1b6c1ecull,	0x3c3c22786622665aull,	0x1515922aad92adb8ull,	0xc9c92089602060a9ull,
		0x87874915db49db5cull,	0xaaaaff4f1aff1ab0ull,	0x505078a0887888d8ull,	0xa5a57a518e7a8e2bull,
		0x03038f068a8f8a89ull,	0x5959f8b213f8134aull,	0x090980129b809b92ull,	0x1a1a173439173923ull,
		0x6565daca75da7510ull,	0xd7d731b553315384ull,	0x8484c61351c651d5ull,	0xd0d0b8bbd3b8d303ull,
		0x8282c31f5ec35edcull,	0x2929b052cbb0cbe2ull,	0x5a5a77b4997799c3ull,	0x1e1e113c3311332dull,
		0x7b7bcbf646cb463dull,	0xa8a8fc4b1ffc1fb7ull,	0x6d6dd6da61d6610cull,	0x2c2c3a584e3a4e62ull
	}
};

} // namespace detail

} // namespace digestpp

#endif

