<?xml version="1.0" encoding="iso-8859-1" ?>
<!--
	Name: $RCSfile: librapple.xsl,v $
	Author: Alan Moran
	$Date: 2005/11/20 13:36:27 $
	$Revision: 1.1 $
	$Id: librapple.xsl,v 1.1 2005/11/20 13:36:27 a_j_moran Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.
-->
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 	xmlns:rpl="http://rapple.sourceforge.net/2005/xhtml"
 	xmlns:xhtml="http://www.w3.org/1999/xhtml"
 	exclude-result-prefixes="rpl"
 	version="1.0">

<xsl:include href="librapple.conf.xsl" />

<!--
	Variable: librapple_pageContext
	Description:
	A document may be assigned a page context if it posesses precisely one "meta" element that has
	a "name" attribute of value "rapple_pageContext".  A page context is used to draw attention to
	the significance of a particular page (e.g., to support the selective highlighting of
	menu items etc.).  This variable stores the page context of the input document or the value
	defined by the variable $librapple.page.context.default (see librapple.conf.xslt) if none (or
	more than one) is defined.
-->
<xsl:variable name="librapple_v_pageContext">
	<xsl:choose>
		<xsl:when test="count(/xhtml:html/xhtml:head/xhtml:meta[@name='rapple_pageContext']) = 1">
			<xsl:value-of select="/xhtml:html/xhtml:head/xhtml:meta[@name='rapple_pageContext']/@content" />
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$librapple.page.context.default" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<xsl:template name="librapple_generateMenu">
	<xsl:param name="menuFile" />
	<xsl:apply-templates select="document($menuFile)/xhtml:html/xhtml:body/*" mode="_librapple_classifyFocus" />
</xsl:template>

<!-- 
	Template: apply (mode "librapple_classifyFocus")
	Match: all elements and attributes
	Description:
	Match all elements within a document looking for those that possess a rpl:ctxt attribute.
	If this attribute is present its value is compared with that of the (global) $ctxt variable.
	If these match then a "class" attribute is added to the element whose value is as defined
	by the $librapple.css.class.infocus variable (see librapple.conf.xslt), otherwise the value
	of the variable $librapple.css.class.outfocus is used.  If the "class" attribute is already
	present then no action is taken.
-->
<xsl:template match="node()" mode="_librapple_classifyFocus">
	<xsl:copy>
		<xsl:apply-templates select="@href | @src" mode="_librapple_copyAttr" />
		<xsl:copy-of select="@*[not(name() = 'src' or name() = 'href')]" />
		<!-- no action to be taken if rpl:ctxt does not exist or if "class" attribute already exists -->
		<xsl:if test="@rpl:menuCtxt and not(@class)">
   			<xsl:attribute name="class">
				<!-- assign the appropriate focus -->
	   			<xsl:choose>
   					<xsl:when test="@rpl:menuCtxt = $librapple_v_pageContext">
   						<xsl:value-of select="$librapple.css.class.infocus"/>
   			 		</xsl:when>
	   				<xsl:otherwise>
   						<xsl:value-of select="$librapple.css.class.outfocus"/>
    				</xsl:otherwise>
   				</xsl:choose>
      		</xsl:attribute>
		</xsl:if>
   	  	<xsl:apply-templates select="node()" mode="_librapple_classifyFocus"/>
   	</xsl:copy> 
</xsl:template>

<xsl:template match="@href | @src" mode="_librapple_copyAttr">
	<xsl:attribute name="{name()}">
		<xsl:call-template name="librapple_replace">
			<xsl:with-param name="node" select="." />
			<xsl:with-param name="src" select="'{$host}'" />
			<xsl:with-param name="dest" select="$host" />
		</xsl:call-template>
	</xsl:attribute>
</xsl:template>

<!--
	Template: name ("librapple_replace")
	Description:
	Searches the nodeset indicated by the $node parameter and replaces all instances of strings
	that match $src with $dest.
-->
<xsl:template name="librapple_replace">
	<xsl:param name="node" />
	<xsl:param name="src" />
	<xsl:param name="dest" />
	<xsl:choose>
		<xsl:when test="$src and contains($node, $src)">
			<xsl:value-of select="substring-before($node, $src)" />
			<xsl:value-of select="$dest" />
			<xsl:call-template name="librapple_replace">
				<xsl:with-param name="node" select="substring-after($node, $src)" />
				<xsl:with-param name="src" select="$src" />
				<xsl:with-param name="dest" select="$dest" />
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$node" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>

