/*
   Name: $RCSfile: mod_db.c,v $
   Author: Alan Moran
   $Date: 2005/09/27 18:08:42 $
   $Revision: 1.3 $
   $Id: mod_db.c,v 1.3 2005/09/27 18:08:42 a_j_moran Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/**
   @file

   @brief Functions to support the init module.

   The tidy module performs all necessary actions required to implement
   the module interface.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include "globals.h"
#include "mod_db.h"

rpl_str_t 	rpl_db_base_dir;

#ifdef HAVE_MYSQL
static rpl_c_str_t mod_db_init = "DELETE FROM RPL_WEBASSETS WHERE 1=1";
static rpl_c_str_t mod_db_audit = "INSERT INTO RPL_WEBASSETS(filename, rel_dir, submitter, dts, mime_type, tidy_status, xslt_status) "
									"VALUES ('%s','%s','%s', NOW(), '%s', '%s', '%s')";
#endif

/**
   Configure the tidy module.

   @param fns pointer to module interface to be configured.
 */
void
rpl_mod_db_configure(rpl_mod_fns *fns)
{
	fns->init = rpl_mod_db_init;
	fns->process = rpl_mod_db_process;
	fns->cleanup = rpl_mod_db_cleanup;
	rpl_db_base_dir = rpl_wk_get_webdir();
	fns->basedir = rpl_db_base_dir;
}

/**
   Perform registry initialization.
 */
rpl_wk_status 
rpl_mod_db_init()
{
	rpl_wk_status status = RPL_WK_OK;
#ifdef HAVE_MYSQL
	rpl_db_connect();
	rpl_wa_db_init();
	/* delete existing entries in the web asset table */
	rpl_db_query(mod_db_init);
#endif
	
	return status; 
}

/**
   @param filename name of file to be registered.
   @param st_buf stat of file.
 */
rpl_wk_status 
rpl_mod_db_process(rpl_c_str_t filename, struct stat statbuf)
{
	rpl_wk_status status = RPL_WK_OK;
#ifdef HAVE_MYSQL
	rpl_str_t msg, parsed_query, mime_type, fn, rdp, fp, key;
	rpl_reg_item item;
	int length;

    assert((filename != NULL) && (statbuf != NULL));

	msg = rpl_str_concat(rpl_message_get("WK_PROCESSING", RPL_EOM), "mysql ", filename, RPL_STR_EOC);
	rpl_log_info(msg);
	rpl_me_free(msg);

	if(S_ISREG(statbuf.st_mode))
	{
		/* extract key information */
		if(rpl_fs_resolve_paths(filename, rpl_db_base_dir, &rdp, &fp))
			return RPL_WK_ERR;
		key = rpl_reg_create_key(rdp, fp);

		/* search for asset in registry and audit meta-data */		
		item = rpl_reg_search(key);	

		length = strlen((rpl_c_str_t)rpl_wa_get_filename(*item)) 
					+ strlen((rpl_c_str_t)rpl_wa_get_rel_dir(*item)) 
					+ strlen((rpl_c_str_t)rpl_wa_get_mime_type(*item)) 
					+ strlen((rpl_c_str_t)rpl_wa_get_contributor(*item)) 
					+ strlen((rpl_c_str_t)rpl_wa_get_tidy_stat_desc(*item)) 
					+ strlen((rpl_c_str_t)rpl_wa_get_tmpl_stat_desc(*item)) 
					+ strlen(webassets_insert) 
					+ 20;
		parsed_query = (rpl_str_t)rpl_me_malloc(length);
		sprintf(parsed_query, webassets_insert,
				rpl_db_escape_string(rpl_wa_get_filename(*item)),
				rpl_db_escape_string(rpl_wa_get_rel_dir(*item)),
				rpl_db_escape_string(rpl_wa_get_contributor(*item)),
				rpl_db_escape_string(rpl_wa_get_mime_type(*item)),
				rpl_db_escape_string(rpl_wa_get_tidy_stat_desc(*item)),
				rpl_db_escape_string(rpl_wa_get_tmpl_stat_desc(*item)));

		rpl_db_query(parsed_query);	
		rpl_me_free(parsed_query);
	} 
#endif

	return status; 
}

/**
   Release resources held during processing. 
 */
rpl_wk_status 
rpl_mod_db_cleanup()
{
	rpl_wk_status status = RPL_WK_OK;

	rpl_me_free(rpl_db_base_dir);
#ifdef HAVE_MYSQL
	rpl_db_disconnect();
#endif

	return status;
}

