/*
   Name: $RCSfile: mod_index.h,v $
   Author: Alan Moran
   $Date: 2005/09/16 21:31:54 $
   $Revision: 1.1 $
   $Id: mod_index.h,v 1.1 2005/09/16 21:31:54 a_j_moran Exp $

   Description:
   Function prototypes and macros to support the index module.
   This interface was formerly known as catalog and the change to index
   took place at R1.5.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_MOD_INDEX_H
#define INCLUDE_MOD_INDEX_H

BEGIN_C_DECLS

#include "workflow.h"

#define RPL_INDEX_INDEXNM    "index.html"
/* the doctype seems to cause uri schema problems with some processors (e.g., Sablot) so for
   now it is being suppressed in tidy output and other generated content
#define RPL_INDEX_HTML_DTD    "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN'"\
                        "'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>"
*/
#define RPL_INDEX_HTML_ST_1   "<html xmlns='http://www.w3.org/1999/xhtml'><head><title>"
#define RPL_INDEX_HTML_ST_2   "</title></head><body><h1>"
#define RPL_INDEX_HTML_ST_3   "</h1><br /><ul>"
#define RPL_INDEX_HTML_END    "</ul></body></html>"

void 				rpl_mod_index_configure(rpl_mod_fns *fns);
rpl_wk_status 		rpl_mod_index_init(void);
rpl_wk_status 		rpl_mod_index_process(rpl_c_str_t filename, struct stat statbuf);
rpl_wk_status 		rpl_mod_index_cleanup(void);
void 				rpl_mod_index_configure(rpl_mod_fns *fns);


END_C_DECLS

#endif
