/*
   Name: $RCSfile: mod_link.h,v $
   Author: Alan Moran
   $Date: 2005/10/25 13:57:48 $
   $Revision: 1.1 $
   $Id: mod_link.h,v 1.1 2005/10/25 13:57:48 a_j_moran Exp $

   Description:
   Function prototypes and macros to support the link checker module.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_MOD_LINK_H
#define INCLUDE_MOD_LINK_H

BEGIN_C_DECLS

#ifndef XSLT_FILE
#define XSLT_FILE "linkCheckReport.xsl"
#endif

#define RPL_MOD_LINK_HDR "<linkReport>\n"
#define RPL_MOD_LINK_TRL "</linkReport>\n"
#define RPL_MOD_LINK_FILE_ENTRY_1 "\t<file name=\""
#define RPL_MOD_LINK_FILE_ENTRY_2 "\" >\n"
#define RPL_MOD_LINK_FILE_ENTRY_3 "\t</file>\n"
#define RPL_MOD_LINK_ERROR "\t\t<error element=\"%s\" attribute=\"%s\" line=\"%d\" column=\"%d\">%s</error>"


#define RPL_MOD_LINK_SABLOT_DATA "data"
#define RPL_MOD_LINK_SABLOT_XSLT "sheet"
#define RPL_MOD_LINK_SABLOT_ARG_OUT "arg:/out"
#define RPL_MOD_LINK_SABLOT_ARG_DATA "arg:/data"
#define RPL_MOD_LINK_SABLOT_ARG_XSLT "arg:/sheet"

void 				rpl_mod_link_configure(rpl_mod_fns *fns);
rpl_wk_status 		rpl_mod_link_init(void);
rpl_wk_status 		rpl_mod_link_process(rpl_c_str_t filename, struct stat statbuf);
rpl_wk_status 		rpl_mod_link_cleanup(void);

END_C_DECLS

#endif
