/*
   Name: $RCSfile: registry.h,v $
   Author: Alan Moran
   $Date: 2005/11/13 20:57:21 $
   $Revision: 1.2 $
   $Id: registry.h,v 1.2 2005/11/13 20:57:21 a_j_moran Exp $

   Description:
   Function prototypes and macros to support the web asset registry.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/** \file registry.h */

#ifndef INCLUDE_REGISTRY_H
#define INCLUDE_REGISTRY_H

BEGIN_C_DECLS

/**
   Registry node type (red or black) used to classify nodes in RB BST 
   implementation of 2-3-5 top-down tree.
*/
typedef enum _rpl_reg_color {
    RPL_REG_BLACK = 0,
    RPL_REG_RED, 
} rpl_reg_color;

/**
   Keys in the registry are usually filenames (relative to the website
   base directory). 
 */
typedef rpl_str_t  				rpl_reg_key;
typedef struct _rpl_web_asset * rpl_reg_item;
typedef struct rpl_reg_node_s *rpl_reg_link;
typedef void (*rpl_reg_tr_fp)(struct _rpl_web_asset *);

/**
   Registry node structure 
 */
typedef struct rpl_reg_node_s {
	rpl_reg_item       item;
	rpl_reg_link       left;
	rpl_reg_link       right;
	unsigned long      count;
    rpl_reg_color      color;
} rpl_reg_node;

extern rpl_web_asset RPL_REG_WA_NULL;

void 			rpl_reg_init(void);
rpl_str_t       rpl_reg_create_key(rpl_str_t rel_dir, rpl_str_t file);
void 			rpl_reg_insert(rpl_reg_item item);
rpl_reg_item 	rpl_reg_search(rpl_reg_key key);
unsigned long 	rpl_reg_count(void);
void 			rpl_reg_traverse(rpl_reg_tr_fp fn);
void 			rpl_reg_report(rpl_reg_item item);

END_C_DECLS

#endif
