/*
   Name: $RCSfile: str_list.h,v $
   Author: Nelson Loyola
   $Date: 2005/08/05 21:33:20 $
   $Revision: 1.1 $
   $Id: str_list.h,v 1.1 2005/08/05 21:33:20 nloyola Exp $

   Description:
   Function prototypes and macros to support linked lists of strings.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/**
   \file

   \brief Definitions used by string linked lists.
 */

#ifndef INCLUDE_STR_LIST_H
#define INCLUDE_STR_LIST_H

BEGIN_C_DECLS

#include "list.h"
#include "strutil.h"

/**
   The node in a string linked list
*/
typedef struct
{
    rpl_list_node node;
    rpl_str_t     str;
} rpl_str_list_node;

rpl_str_list_node * rpl_str_list_create_node (rpl_str_t str);
void rpl_str_list_destroy_node (rpl_str_list_node * node_p);
void rpl_str_list_destroy (rpl_list * list_p);

END_C_DECLS

#endif /* INCLUDE_STR_LIST_H */
