// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Lhx.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.lhxmodel {
  public class Lhx_3_2_2 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("lhxmodel.Lhx:3.2.2", null);

    public Lhx_3_2_2(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Lhx_3_2_2(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Lhx_3_2_2 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Lhx_3_2_2(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public const int ERR_NOT_SUPPORTED = 2;

    public class ParamCfg : ICloneable {
      public object Clone() {
        ParamCfg copy = new ParamCfg();
        copy.min = this.min;
        copy.max = this.max;
        copy.decdigits = this.decdigits;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["min"] = this.min;
        json["max"] = this.max;
        json["decdigits"] = this.decdigits;
        return json;
      }

      public static ParamCfg Decode(LightJson.JsonObject json, Agent agent) {
        ParamCfg inst = new ParamCfg();
        inst.min = (double)json["min"];
        inst.max = (double)json["max"];
        inst.decdigits = (int)json["decdigits"];
        return inst;
      }

      public double min = 0.0;
      public double max = 0.0;
      public int decdigits = 0;
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.model = this.model;
        copy.version = this.version;
        copy.setpointWaterValveCfg = this.setpointWaterValveCfg;
        copy.setpointVentilatorsCfg = this.setpointVentilatorsCfg;
        copy.defaultFanSpeedCfg = this.defaultFanSpeedCfg;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["model"] = this.model;
        json["version"] = this.version;
        json["setpointWaterValveCfg"] = this.setpointWaterValveCfg.Encode();
        json["setpointVentilatorsCfg"] = this.setpointVentilatorsCfg.Encode();
        json["defaultFanSpeedCfg"] = this.defaultFanSpeedCfg.Encode();
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.model = (string)json["model"];
        inst.version = (string)json["version"];
        inst.setpointWaterValveCfg = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg.Decode(json["setpointWaterValveCfg"], agent);
        inst.setpointVentilatorsCfg = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg.Decode(json["setpointVentilatorsCfg"], agent);
        inst.defaultFanSpeedCfg = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg.Decode(json["defaultFanSpeedCfg"], agent);
        return inst;
      }

      public string model = "";
      public string version = "";
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg setpointWaterValveCfg = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg();
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg setpointVentilatorsCfg = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg();
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg defaultFanSpeedCfg = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.ParamCfg();
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.setpointWaterValve = this.setpointWaterValve;
        copy.setpointVentilators = this.setpointVentilators;
        copy.defaultFanSpeed = this.defaultFanSpeed;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["setpointWaterValve"] = this.setpointWaterValve;
        json["setpointVentilators"] = this.setpointVentilators;
        json["defaultFanSpeed"] = this.defaultFanSpeed;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.setpointWaterValve = (double)json["setpointWaterValve"];
        inst.setpointVentilators = (double)json["setpointVentilators"];
        inst.defaultFanSpeed = (double)json["defaultFanSpeed"];
        return inst;
      }

      public double setpointWaterValve = 0.0;
      public double setpointVentilators = 0.0;
      public double defaultFanSpeed = 0.0;
    }

    public class AlertStatus : ICloneable {
      public object Clone() {
        AlertStatus copy = new AlertStatus();
        copy.sensorFailure = this.sensorFailure;
        copy.fanFailure = this.fanFailure;
        copy.powerSupplyFailure = this.powerSupplyFailure;
        copy.thresholdAirOutlet = this.thresholdAirOutlet;
        copy.thresholdAirInlet = this.thresholdAirInlet;
        copy.thresholdWaterInlet = this.thresholdWaterInlet;
        copy.doorOpened = this.doorOpened;
        copy.maximumCoolingRequest = this.maximumCoolingRequest;
        copy.emergencyCooling = this.emergencyCooling;
        copy.waterLeak = this.waterLeak;
        copy.thresholdHumidity = this.thresholdHumidity;
        copy.externalWaterCoolingFailure = this.externalWaterCoolingFailure;
        copy.thresholdWaterOutlet = this.thresholdWaterOutlet;
        copy.stBusError = this.stBusError;
        copy.condenserPumpFailure = this.condenserPumpFailure;
        copy.baseElectronicsFailure = this.baseElectronicsFailure;
        copy.voltageLow = this.voltageLow;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["sensorFailure"] = new JsonArray(this.sensorFailure.Select(
          _value => (JsonValue)(_value)));
        json["fanFailure"] = new JsonArray(this.fanFailure.Select(
          _value => (JsonValue)(_value)));
        json["powerSupplyFailure"] = new JsonArray(this.powerSupplyFailure.Select(
          _value => (JsonValue)(_value)));
        json["thresholdAirOutlet"] = this.thresholdAirOutlet;
        json["thresholdAirInlet"] = this.thresholdAirInlet;
        json["thresholdWaterInlet"] = this.thresholdWaterInlet;
        json["doorOpened"] = this.doorOpened;
        json["maximumCoolingRequest"] = this.maximumCoolingRequest;
        json["emergencyCooling"] = this.emergencyCooling;
        json["waterLeak"] = this.waterLeak;
        json["thresholdHumidity"] = this.thresholdHumidity;
        json["externalWaterCoolingFailure"] = this.externalWaterCoolingFailure;
        json["thresholdWaterOutlet"] = this.thresholdWaterOutlet;
        json["stBusError"] = this.stBusError;
        json["condenserPumpFailure"] = this.condenserPumpFailure;
        json["baseElectronicsFailure"] = this.baseElectronicsFailure;
        json["voltageLow"] = this.voltageLow;
        return json;
      }

      public static AlertStatus Decode(LightJson.JsonObject json, Agent agent) {
        AlertStatus inst = new AlertStatus();
        inst.sensorFailure = new System.Collections.Generic.List<bool>(json["sensorFailure"].AsJsonArray.Select(
          _value => (bool)_value));
        inst.fanFailure = new System.Collections.Generic.List<bool>(json["fanFailure"].AsJsonArray.Select(
          _value => (bool)_value));
        inst.powerSupplyFailure = new System.Collections.Generic.List<bool>(json["powerSupplyFailure"].AsJsonArray.Select(
          _value => (bool)_value));
        inst.thresholdAirOutlet = (bool)json["thresholdAirOutlet"];
        inst.thresholdAirInlet = (bool)json["thresholdAirInlet"];
        inst.thresholdWaterInlet = (bool)json["thresholdWaterInlet"];
        inst.doorOpened = (bool)json["doorOpened"];
        inst.maximumCoolingRequest = (bool)json["maximumCoolingRequest"];
        inst.emergencyCooling = (bool)json["emergencyCooling"];
        inst.waterLeak = (bool)json["waterLeak"];
        inst.thresholdHumidity = (bool)json["thresholdHumidity"];
        inst.externalWaterCoolingFailure = (bool)json["externalWaterCoolingFailure"];
        inst.thresholdWaterOutlet = (bool)json["thresholdWaterOutlet"];
        inst.stBusError = (bool)json["stBusError"];
        inst.condenserPumpFailure = (bool)json["condenserPumpFailure"];
        inst.baseElectronicsFailure = (bool)json["baseElectronicsFailure"];
        inst.voltageLow = (bool)json["voltageLow"];
        return inst;
      }

      public System.Collections.Generic.IEnumerable<bool> sensorFailure = new System.Collections.Generic.List<bool>();
      public System.Collections.Generic.IEnumerable<bool> fanFailure = new System.Collections.Generic.List<bool>();
      public System.Collections.Generic.IEnumerable<bool> powerSupplyFailure = new System.Collections.Generic.List<bool>();
      public bool thresholdAirOutlet = false;
      public bool thresholdAirInlet = false;
      public bool thresholdWaterInlet = false;
      public bool doorOpened = false;
      public bool maximumCoolingRequest = false;
      public bool emergencyCooling = false;
      public bool waterLeak = false;
      public bool thresholdHumidity = false;
      public bool externalWaterCoolingFailure = false;
      public bool thresholdWaterOutlet = false;
      public bool stBusError = false;
      public bool condenserPumpFailure = false;
      public bool baseElectronicsFailure = false;
      public bool voltageLow = false;
    }

    public class OpState : ICloneable {
      public object Clone() {
        OpState copy = new OpState();
        copy.on = this.on;
        copy.alertStatus = this.alertStatus;
        copy.operatingHoursLhx = this.operatingHoursLhx;
        copy.operatingHoursFan = this.operatingHoursFan;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["on"] = this.on;
        json["alertStatus"] = this.alertStatus.Encode();
        json["operatingHoursLhx"] = this.operatingHoursLhx;
        json["operatingHoursFan"] = new JsonArray(this.operatingHoursFan.Select(
          _value => (JsonValue)(_value)));
        return json;
      }

      public static OpState Decode(LightJson.JsonObject json, Agent agent) {
        OpState inst = new OpState();
        inst.on = (bool)json["on"];
        inst.alertStatus = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus.Decode(json["alertStatus"], agent);
        inst.operatingHoursLhx = (int)json["operatingHoursLhx"];
        inst.operatingHoursFan = new System.Collections.Generic.List<int>(json["operatingHoursFan"].AsJsonArray.Select(
          _value => (int)_value));
        return inst;
      }

      public bool on = false;
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus alertStatus = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus();
      public int operatingHoursLhx = 0;
      public System.Collections.Generic.IEnumerable<int> operatingHoursFan = new System.Collections.Generic.List<int>();
    }

    public class Capabilities : ICloneable {
      public object Clone() {
        Capabilities copy = new Capabilities();
        copy.alerts = this.alerts;
        copy.features = this.features;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["alerts"] = this.alerts.Encode();
        json["features"] = new JsonArray(this.features.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
        })));
        return json;
      }

      public static Capabilities Decode(LightJson.JsonObject json, Agent agent) {
        Capabilities inst = new Capabilities();
        inst.alerts = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus.Decode(json["alerts"], agent);
        inst.features = DictionaryHelper.Create(json["features"].AsJsonArray.Select(
          _value => new System.Collections.Generic.KeyValuePair<string, bool>(_value["key"], (bool)_value["value"])));
        return inst;
      }

      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus alerts = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.AlertStatus();
      public System.Collections.Generic.IDictionary<string, bool> features = new System.Collections.Generic.Dictionary<string, bool>();
    }

    public class OpStateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("lhxmodel.Lhx_3_2_2.OpStateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState oldState = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState();
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState newState = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState();
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("lhxmodel.Lhx_3_2_2.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings oldSettings = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings();
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings newSettings = new Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings();
    }

    public class GetCapabilitiesResult {
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Capabilities _ret_;
    }

    public GetCapabilitiesResult getCapabilities() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCapabilities", _parameters);
      var _ret = new GetCapabilitiesResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Capabilities.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getCapabilities(AsyncRpcResponse<GetCapabilitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCapabilities(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCapabilities(AsyncRpcResponse<GetCapabilitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCapabilities", _parameters,
        _result => {
          try {
            var _ret = new GetCapabilitiesResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Capabilities.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.lhxmodel.Sensor_4_0_1> _ret_;
    }

    public GetSensorsResult getSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensors", _parameters);
      var _ret = new GetSensorsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Sensor_4_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.lhxmodel.Sensor_4_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensors", _parameters,
        _result => {
          try {
            var _ret = new GetSensorsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Sensor_4_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.lhxmodel.Sensor_4_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetOpStateResult {
      public Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState _ret_;
    }

    public GetOpStateResult getOpState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getOpState", _parameters);
      var _ret = new GetOpStateResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getOpState(AsyncRpcResponse<GetOpStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getOpState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getOpState(AsyncRpcResponse<GetOpStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getOpState", _parameters,
        _result => {
          try {
            var _ret = new GetOpStateResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Lhx_3_2_2.OpState.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPowerStateResult {
      public int _ret_;
    }

    public SetPowerStateResult setPowerState(Com.Raritan.Idl.sensors.Sensor_4_0_1.OnOffState state) {
      var _parameters = new LightJson.JsonObject();
      _parameters["state"] = (int)state;

      var _result = RpcCall("setPowerState", _parameters);
      var _ret = new SetPowerStateResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPowerState(Com.Raritan.Idl.sensors.Sensor_4_0_1.OnOffState state, AsyncRpcResponse<SetPowerStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPowerState(state, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPowerState(Com.Raritan.Idl.sensors.Sensor_4_0_1.OnOffState state, AsyncRpcResponse<SetPowerStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["state"] = (int)state;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPowerState", _parameters,
        _result => {
          try {
            var _ret = new SetPowerStateResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetParametersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1> _ret_;
    }

    public GetParametersResult getParameters() {
      JsonObject _parameters = null;
      var _result = RpcCall("getParameters", _parameters);
      var _ret = new GetParametersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.lhxmodel.Parameter_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getParameters(AsyncRpcResponse<GetParametersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getParameters(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getParameters(AsyncRpcResponse<GetParametersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getParameters", _parameters,
        _result => {
          try {
            var _ret = new GetParametersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.lhxmodel.Parameter_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetActualValuesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1> _ret_;
    }

    public GetActualValuesResult getActualValues() {
      JsonObject _parameters = null;
      var _result = RpcCall("getActualValues", _parameters);
      var _ret = new GetActualValuesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.lhxmodel.Parameter_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getActualValues(AsyncRpcResponse<GetActualValuesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getActualValues(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getActualValues(AsyncRpcResponse<GetActualValuesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getActualValues", _parameters,
        _result => {
          try {
            var _ret = new GetActualValuesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.lhxmodel.Parameter_2_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.lhxmodel.Parameter_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetMaximumCoolingRequestResult {
      public int _ret_;
    }

    public SetMaximumCoolingRequestResult setMaximumCoolingRequest(bool requested) {
      var _parameters = new LightJson.JsonObject();
      _parameters["requested"] = requested;

      var _result = RpcCall("setMaximumCoolingRequest", _parameters);
      var _ret = new SetMaximumCoolingRequestResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setMaximumCoolingRequest(bool requested, AsyncRpcResponse<SetMaximumCoolingRequestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setMaximumCoolingRequest(requested, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setMaximumCoolingRequest(bool requested, AsyncRpcResponse<SetMaximumCoolingRequestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["requested"] = requested;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setMaximumCoolingRequest", _parameters,
        _result => {
          try {
            var _ret = new SetMaximumCoolingRequestResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AcknowledgeAlertStatusResult {
      public int _ret_;
    }

    public AcknowledgeAlertStatusResult acknowledgeAlertStatus() {
      JsonObject _parameters = null;
      var _result = RpcCall("acknowledgeAlertStatus", _parameters);
      var _ret = new AcknowledgeAlertStatusResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest acknowledgeAlertStatus(AsyncRpcResponse<AcknowledgeAlertStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return acknowledgeAlertStatus(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest acknowledgeAlertStatus(AsyncRpcResponse<AcknowledgeAlertStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("acknowledgeAlertStatus", _parameters,
        _result => {
          try {
            var _ret = new AcknowledgeAlertStatusResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
