![RawTherapee logo](http://rawtherapee.com/images/logos/rawtherapee_logo_discuss.png)

RawTherapee is a powerful, cross-platform raw photo processing program, released as [libre software](https://en.wikipedia.org/wiki/Free_software) under the [GNU General Public License Version 3](https://opensource.org/licenses/gpl-3.0.html). It is written mostly in C++ using a [GTK+](http://www.gtk.org/) front-end. It uses a patched version of [dcraw](http://www.cybercom.net/~dcoffin/dcraw/) for reading raw files, with an in-house solution which adds the highest quality support for certain camera models unsupported by dcraw and enhances the accuracy of certain raw files already supported by dcraw. It is notable for the advanced control it gives the user over the demosaicing and development process.

## Target audience

RawTherapee is designed for developing raw files from a broad range of digital cameras, as well as [HDR DNG](https://helpx.adobe.com/photoshop/digital-negative.html) files and non-raw image formats ([JPEG](https://en.wikipedia.org/wiki/JPEG), [TIFF](https://en.wikipedia.org/wiki/Tagged_Image_File_Format) and [PNG](https://en.wikipedia.org/wiki/Portable_Network_Graphics)). The target audience ranges from enthusiast newcomers who wish to broaden their understanding of how digital imaging works to semi-professional photographers. Knowledge in color science is not compulsory, but it is recommended that you are eager to learn and ready to read our documentation ([RawPedia](http://rawpedia.rawtherapee.com/)) as well as look up basic concepts which lie outside the scope of RawPedia, such as [color balance](https://en.wikipedia.org/wiki/Color_balance), elsewhere.

Of course, professionals may use RawTherapee too while enjoying complete freedom, but will probably lack some peripheral features such as [Digital Asset Management](https://en.wikipedia.org/wiki/Digital_asset_management), printing, uploading, etc. RawTherapee is not aimed at being an inclusive all-in-one program, and the [open-source community](https://en.wikipedia.org/wiki/Open-source_movement) is sufficiently developed by now to offer all those peripheral features in other specialized software.

## Links

Website:
http://rawtherapee.com/

Forum:
https://discuss.pixls.us/c/software/rawtherapee

Features:
http://rawpedia.rawtherapee.com/Features

Official documentation:
http://rawpedia.rawtherapee.com/

Download RawTherapee:
http://rawtherapee.com/downloads

Download source code tarballs:
http://rawtherapee.com/shared/source/

## Compilation, branches and Git
Refer to RawPedia for a detailed explanation of how to get the necessary dependencies and how to compile RawTherapee.

Linux:
http://rawpedia.rawtherapee.com/Linux

Windows:
http://rawpedia.rawtherapee.com/Windows

macOS:
http://rawpedia.rawtherapee.com/macOS
