#!/usr/bin/env python

# Scrobbler_Musicbrainz.py
# Copyright (c) 2005 Alex Revo
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


HAVE_ID3LIB = 0

import os.path
try:
    import eyeD3
    HAVE_ID3LIB = 1
except:
    print("Unable to import eyeD3; Musicbrainz support for mp3 will be disabled.")

from Debug import Debug


class MB(Debug):
    def __init__(self):
        pass


    def getSignature(self, filename): 
        mbid = ""

        if (not os.path.isfile(filename)):
            return

        (path, ext) = os.path.splitext(filename)

        try:
            if (ext.lower() == '.mp3' and HAVE_ID3LIB):
                mbid = self.__id3mbid(filename)
            #elif (ext.lower() == '.ogg'):
            #    pass
            #else:
            #    self.debug("Unsupported file extension.")
        except:
            pass

        if (mbid):
            self.debug("MBID: %s" % mbid)

        return(mbid)


    def __id3mbid(self, filename):
        tag = eyeD3.Tag()
        tag.link(filename)

        unique_file_ids = tag.getUniqueFileIDs()
        if unique_file_ids:
            return unique_file_ids[0].id

