/******************************************************************************
*		       							      *
* gnome/conf.h (part of rcalc)					       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* Class to manage the configuration of the GNOME user interface.
*/

#ifndef __RC_GNOMEUI_CFG_H__
#define __RC_GNOMEUI_CFG_H__

#include <glib.h>


typedef struct _RcGnomeUiCfg RcGnomeUiCfg;
typedef enum
{
	RC_SCROLLBAR_LEFT,
	RC_SCROLLBAR_RIGHT,
	RC_SCROLLBAR_HIDDEN,
	_RC_NUMBER_OF_SCROLLBAR_POSES
}
RcScrollbarPos;
typedef enum
{
	RC_COLOUR_FOREGROUND,
	RC_COLOUR_BACKGROUND,
	RC_COLOUR_PROMPT,
	RC_COLOUR_ERROR,
	_RC_NUMBER_OF_COLOURS
}
RcColour;

RcGnomeUiCfg*	rcg_conf_new			( void );
void		rcg_conf_delete			( RcGnomeUiCfg	     *cfg );

void		rcg_conf_load_state		( RcGnomeUiCfg	     *cfg );
void		rcg_conf_save_state		( const	RcGnomeUiCfg *cfg );

RcScrollbarPos	rcg_conf_get_scrollbar_pos	( const	RcGnomeUiCfg *cfg );
void		rcg_conf_set_scrollbar_pos	( RcGnomeUiCfg	     *cfg,
						  RcScrollbarPos      pos );
guint		rcg_conf_get_scrollback		( const	RcGnomeUiCfg *cfg );
void		rcg_conf_set_scrollback		( RcGnomeUiCfg	     *cfg,
						  guint		      lines );
gboolean	rcg_conf_get_scroll_on_key	( const RcGnomeUiCfg *cfg );
void		rcg_conf_set_scroll_on_key	( RcGnomeUiCfg	     *cfg,
						  gboolean	      state );
gboolean	rcg_conf_get_scroll_on_out	( const RcGnomeUiCfg *cfg );
void		rcg_conf_set_scroll_on_out	( RcGnomeUiCfg       *cfg,
						  gboolean	      state );
gboolean	rcg_conf_get_blink		( const RcGnomeUiCfg *cfg );
void		rcg_conf_set_blink		( RcGnomeUiCfg	     *cfg,
						  gboolean	      state );
gboolean	rcg_conf_get_bell		( const RcGnomeUiCfg *cfg );
void		rcg_conf_set_bell		( RcGnomeUiCfg	     *cfg,
						  gboolean	      state );
const gchar*	rcg_conf_get_font_name		( const RcGnomeUiCfg *cfg );
void		rcg_conf_set_font_name		( RcGnomeUiCfg	     *cfg,
						  const gchar	     *font );
const gushort*	rcg_conf_get_colour		( const RcGnomeUiCfg *cfg,
						  RcColour	      colour );
void		rcg_conf_set_colour		( RcGnomeUiCfg	     *cfg,
						  RcColour	      colour,
						  const gushort	     *rgb );


#endif /* __RC_GNOMEUI_CFG_H__ */
