/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include "preferences.h"

#include <string.h>
#include <gtk/gtk.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/gnome-color-picker.h>
#include <glade/glade-xml.h>
#include <gconf/gconf-client.h>

#include <engine/engine.h>
#include <engine/debug.h>

extern RcEngine *RC_engine;

static void
rca_prefs_response_cb (GtkDialog *dialog, gint response, gpointer gdata);

static void
rca_prefs_rb_rad_cb (GtkWidget *widget, gpointer gdata);
static void
rca_prefs_rb_deg_cb (GtkWidget *widget, gpointer gdata);

void
rcalc_applet_display_error (const gchar *error_message)
{
	   GtkWidget *dialog;

	   dialog = gtk_message_dialog_new (NULL,
								 GTK_DIALOG_DESTROY_WITH_PARENT,
								 GTK_MESSAGE_ERROR,
								 GTK_BUTTONS_CLOSE,
								 error_message);
	   gtk_dialog_run (GTK_DIALOG (dialog));
	   gtk_widget_destroy (dialog);
}

static void
rca_prefs_response_cb (GtkDialog *dialog, gint response, gpointer gdata)
{
  GError *error = NULL;
  MCData *mc;

  mc = (MCData *) gdata;

  if (response == GTK_RESPONSE_HELP) {
  error = NULL;
  gnome_help_display (PACKAGE, "rcalc-applet-prefs", &error);

  if (error) {
				    if (error->code == GNOME_HELP_ERROR_INTERNAL) {
						  /*cpufreq_applet_display_error ("Sorry, a internal error has been ocurred "
												  "with the rcalc applet help");*/
				    } else {
						  /*cpufreq_applet_display_error ("Sorry, the document can not be found");*/
				    }
				    
				    g_error_free (error);
			 }
  }
     
   else {
			 gchar *angle_unit;
       gtk_widget_destroy (mc->prefs);
			 mc->prefs = NULL;       
       
       rc_engine_set_angleunit( RC_engine, mc->preferences.angle_unit );
       if (mc->preferences.angle_unit == RC_ANGLE_RADIANS)
         angle_unit = g_strdup("rad");
       else 
         angle_unit = g_strdup("deg");
       
       panel_applet_gconf_set_string (PANEL_APPLET (mc->applet),
        "angle_unit", angle_unit, &error);
        
        if (error)
          rcalc_applet_display_error(error->message);
                
       g_free(angle_unit);
	   }
}

static void
rca_prefs_rb_rad_cb (GtkWidget *widget, gpointer gdata)
{
  MCData *mc;

  mc = (MCData *) gdata;
  mc->preferences.angle_unit = RC_ANGLE_RADIANS;
}

static void
rca_prefs_rb_deg_cb (GtkWidget *widget, gpointer gdata)
{
  MCData *mc;

  mc = (MCData *) gdata;
  mc->preferences.angle_unit = RC_ANGLE_DEGREES;
}


void
rca_show_preferences (BonoboUIComponent *uic,
				MCData            *mc,
				const char        *verbname)
{
  GladeXML  *xml;
  GtkWidget *rb_rad, *rb_deg;

  if (mc->prefs) { /* the dialog already exist, only show it */
			 gtk_window_present (GTK_WINDOW (mc->prefs));
			 return;
	   }

  xml = glade_xml_new (DATADIR"/rcalc-applet/rcalc-preferences.glade",
      "prefs_dialog", NULL);
    
  g_assert (xml);
  
  mc->prefs = glade_xml_get_widget (xml, "prefs_dialog");
  rb_deg = glade_xml_get_widget (xml, "radiobutton1");;
  rb_rad = glade_xml_get_widget (xml, "radiobutton2");;
  g_assert (rb_rad);
  g_assert (rb_deg);             
  g_object_unref (G_OBJECT (xml));
    
  gtk_window_set_screen (GTK_WINDOW (mc->prefs),
      gtk_widget_get_screen (GTK_WIDGET (mc)));
  
  g_signal_connect (G_OBJECT (mc->prefs), "response",
    G_CALLBACK (rca_prefs_response_cb),
    (gpointer) mc);

  g_signal_connect (G_OBJECT (rb_rad), "clicked",
    G_CALLBACK (rca_prefs_rb_rad_cb),
    (gpointer) mc);

  g_signal_connect (G_OBJECT (rb_deg), "clicked",
    G_CALLBACK (rca_prefs_rb_deg_cb),
    (gpointer) mc);
        
  g_signal_connect (G_OBJECT (mc->prefs), "destroy",
      G_CALLBACK (gtk_widget_destroy),
      NULL);
  
  if (mc->preferences.angle_unit == RC_ANGLE_RADIANS)
    gtk_button_clicked (GTK_BUTTON(rb_rad));
  else 
    gtk_button_clicked (GTK_BUTTON(rb_deg));
    
  gtk_widget_show (mc->prefs);
}

void
rca_load_preferences (MCData *mc)
{
  g_return_if_fail (mc != NULL);
  g_return_if_fail (PANEL_IS_APPLET (mc->applet));

  mc->prefs = NULL;

	mc->preferences.normal_size_x = MC_DEFAULT_NORMAL_SIZE_X;
	mc->preferences.normal_size_y = MC_DEFAULT_NORMAL_SIZE_Y;
}
