#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

gchar RCUI_save_state (GtkListStore *list_store)
{
	int i=0;
  gboolean valid;
  GtkTreeIter iter;
  gchar *name=NULL, *in_expr=NULL, *expr=NULL, *value=NULL;
  gboolean run;
  gchar *key = NULL;

	gnome_config_clean_section( "/" PACKAGE "/RCUI/" );
	gnome_config_push_prefix(   "/" PACKAGE "/RCUI/" );
	
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter);
  
  while (valid)
  {
    gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, 
      NAME_COLUMN, &name, EXPR_COLUMN, &expr,
      RUN_COLUMN, &run, VALUE_COLUMN, &value,
      INPUT_COLUMN, &in_expr, -1);      
      
    key = g_strdup_printf( "line[%d].name", i  );
		gnome_config_set_string( key, name );
    g_free (key);
    
    key = g_strdup_printf( "line[%d].expr", i  );
		gnome_config_set_string( key, expr );
    g_free (key);

    key = g_strdup_printf( "line[%d].value", i  );
		gnome_config_set_string( key, value );
    g_free (key);
    
    key = g_strdup_printf( "line[%d].run", i  );
		gnome_config_set_bool( key, run );
    g_free (key);

    key = g_strdup_printf( "line[%d].in_expr", i  );
		gnome_config_set_string( key, in_expr );
    g_free (key);
      
    valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
    i++;
    if (value) g_free (value);
    if (expr) g_free (expr);
    if (in_expr) g_free (in_expr);
    if (name) g_free (name);
  }
  
  gnome_config_set_int( "num_lines", i );
  
  return 1;
}

gchar RCUI_load_state (GtkListStore *list_store)
{
  int i=0;
  GtkTreeIter iter;
  gchar *name=NULL, *in_expr=NULL, *expr=NULL, *value=NULL;
  gboolean run;
  gchar *key = NULL;
  gint nlines;

  gnome_config_push_prefix( "/" PACKAGE "/RCUI/" );
  
  nlines = gnome_config_get_int( "num_lines=0" );
  
  for( i=0; i < nlines; i++ )
	{
    key = g_strdup_printf( "line[%d].name=%s", i, "<error>" );
		name = gnome_config_get_string( key );
		g_free (key);
    
    key = g_strdup_printf( "line[%d].expr=%s", i, "<error>" );
		expr = gnome_config_get_string( key );
		g_free (key);
    
    key = g_strdup_printf( "line[%d].value=%s", i, "<error>" );
		value = gnome_config_get_string( key );
		g_free (key);

    key = g_strdup_printf( "line[%d].in_expr=%s", i, "<error>" );
		in_expr = gnome_config_get_string( key );
		g_free (key);

    key = g_strdup_printf( "line[%d].run=%s", i, "TRUE" );
		run = gnome_config_get_bool( key );
		g_free (key);
    
    gtk_list_store_append (list_store, &iter);
  
    gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, name,
                    EXPR_COLUMN, expr,
                    VALUE_COLUMN, value,
                    RUN_COLUMN, run,
		                INPUT_COLUMN, in_expr,
                    -1);
                    
    /*RCUI_add_to_history (ui_stores.history, in_expr);*/
    
    if (value) g_free (value);
    if (expr) g_free (expr);
    if (in_expr) g_free (in_expr);
    if (name) g_free (name);
  }
  
  if (nlines > 0) { 
    RCUI_update_state_all (list_store);
    RCUI_update_varw_lists();
  }
  
  return 1;
}

gchar RCUI_save_state_to_file (GtkListStore *list_store, gchar *filename)
{
  FILE *to_file;
  int i=0;
  gboolean valid;
  GtkTreeIter iter;
  gchar *name=NULL, *in_expr=NULL, *expr=NULL, *value=NULL;
  gboolean run;
  
  to_file = fopen(filename, "w");

  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter);
  
  while (valid)
  {
    gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, 
      NAME_COLUMN, &name, EXPR_COLUMN, &expr,
      VALUE_COLUMN, &value, RUN_COLUMN, &run, INPUT_COLUMN, &in_expr, -1);      
          
    fprintf(to_file, "line[%d].name=%s\n", i, name);
    fprintf(to_file, "line[%d].expr=%s\n", i, expr);
    fprintf(to_file, "line[%d].value=%s\n", i, value);
    fprintf(to_file, "line[%d].run=%d\n", i, run == TRUE ? 1 : 0);
    fprintf(to_file, "line[%d].in_expr=%s\n", i, in_expr);

    valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
    i++;
    if (value) g_free (value);
    if (expr) g_free (expr);
    if (in_expr) g_free (in_expr);
    if (name) g_free (name);
    
  }
  
  fprintf(to_file, "num_lines=%d\n", i);
  return 1;
}

gchar RCUI_load_state_from_file (GtkListStore *list_store, gchar *filename)
{
  int i=0;
  GtkTreeIter iter;
  gchar *name=NULL, *in_expr=NULL, *expr=NULL, *value=NULL;
  gint intrun=0;
  gboolean run;
  gchar *key = NULL;
  gint nlines=-1;
  FILE *from_file;
  
  RCUI_clean_state (list_store);
  
  from_file = fopen (filename, "r");
  
  nlines = text_config_get_int( from_file, "num_lines=" );
  if (nlines <0) return 0;
  
  for( i=0; i < nlines; i++ )
	{
    key = g_strdup_printf( "line[%d].name=", i );
		name = text_config_get_string( from_file, key );
		g_free (key);
    
    key = g_strdup_printf( "line[%d].expr=", i );
		expr = text_config_get_string( from_file, key );
		g_free (key);
    
    key = g_strdup_printf( "line[%d].value=", i );
		value = text_config_get_string( from_file, key );
		g_free (key);

    key = g_strdup_printf( "line[%d].in_expr=", i );
		in_expr = text_config_get_string( from_file, key );
		g_free (key);

    key = g_strdup_printf( "line[%d].run=", i );
		intrun = text_config_get_int( from_file, key );
		g_free (key);
    
    if (intrun) run = TRUE; else run=FALSE;
    
    gtk_list_store_append (list_store, &iter);
  
    gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, name,
                    EXPR_COLUMN, expr,
                    VALUE_COLUMN, value,
                    RUN_COLUMN, run,
		                INPUT_COLUMN, in_expr,
                    -1);
    
    /*RCUI_add_to_history (ui_stores.history, in_expr);*/
                    
    if (value) g_free (value);
    if (expr) g_free (expr);
    if (in_expr) g_free (in_expr);
    if (name) g_free (name);
  }
  
  if (nlines > 0) { 
    RCUI_update_state_all (list_store);
    RCUI_update_varw_lists();
  }
  return 1;
}
