/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef DNSMANAGERWIDGET_H
#define DNSMANAGERWIDGET_H

#include <QWidget>
#include "ui_dnsmanagerwidget.h"
#include "rdsdnsmodel.h"
#include <RdsDnsManager>
#include <RdsEntitySortModel>
#include <QItemSelectionModel>
#include <RdsEntityWidget>

class RdsDnsModel;

/**
	@author Chris Vickery <chris@resara.com>
 */
class DnsManagerWidget : public QWidget, private Ui::DnsManagerWidget
{
	Q_OBJECT

public:
	DnsManagerWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~DnsManagerWidget();

public slots:
	void inputChanged(QString id, QString type);
	void outputsChanged(QStringList outputs);

protected slots:
	void addDomain();
	void addOrigin();
	void addRecord();
	void on_DeleteButton_clicked();
	void showSystemObjects(bool show);
	void contextMenu(const QPoint & pos);
	void on_ReloadButton_clicked();
	void onModelLoaded();
	bool save();

private:
	RdsDnsModel *_model;
	RdsEntitySortModel *_sort;
	RdsDnsManager *_manager;
	QItemSelectionModel *_selection;
	RdsEntityWidget *_edit;
	QString _input;
	QAction *_adddomainaction;
	QAction *_addoriginaction;
	QAction *_addrecordaction;
	QAction *_removeaction;
	QAction *_showsystemaction;
};

#endif

