/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTWIDGET_H
#define LISTWIDGET_H

#include <QWidget>
#include "ui_listwidget.h"
#include <QRegExp>
#include <QRegExpValidator>

class ListWidget : public QWidget, private Ui::ListWidget
{
	Q_OBJECT
public:
	Q_PROPERTY(QString listString READ listString WRITE setListString);
	Q_PROPERTY(QStringList list READ list WRITE setList);
	
	ListWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~ListWidget();

	QString listString() const;
	void setListString(const QString &newlist);
	QStringList list() const;
	void setList(const QStringList &newlist);
	void setSeperator(const QRegExp& regex, QString text);
	void setWeakValidator(const QRegExp &regex);
	void setStrongValidator(const QRegExp &regex);
	void setIcon(const QPixmap &icon);
	void setErrorText(const QString &errtext);
	void setUpDownArrows(bool enabled);
	
signals:
	void changed();
	
protected slots:
	void on_AddButton_clicked();
	void on_RemoveButton_clicked();
	void itemEdited();
	void on_UpButton_clicked();
	void on_DownButton_clicked();
	
private:
	QRegExp _seperator;
	QString _seperatortext;
	QRegExpValidator _strongvalidator;
	QPixmap _icon;
	QString _errtext;
};

#endif

