/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef PASSWORDPOLICYWIDGET_H
#define PASSWORDPOLICYWIDGET_H

#include <QWidget>
#include "ui_passwordpolicywidget.h"
#include <ReturnValue>

class PasswordPolicyWidget : public QWidget, private Ui::PasswordPolicyWidget
{
	Q_OBJECT

public:
	PasswordPolicyWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~PasswordPolicyWidget();

protected slots:
	void load();
	void loadReturned(uint id, ReturnValue ret);
	void save();
	void saveReturned(uint id, ReturnValue ret);
	void on_ApplyButton_clicked();
	void on_DiscardButton_clicked();
	void dataChanged();

private:
	bool _complex;
	int _mindays;
	int _maxdays;
	int _minlength;
	int _historylength;
};

#endif

