/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef SHAREEDITWIDGET_H
#define SHAREEDITWIDGET_H

#include <QWidget>
#include "rdsentitywidget.h"
#include "ui_shareeditwidget.h"
#include <RdsShareManager>

class ShareEditWidget : public RdsEntityWidget, private Ui::ShareEditWidget
{
	Q_OBJECT

public:
	ShareEditWidget(RdsShareManager *manager, QWidget* parent = 0);
	~ShareEditWidget();

protected slots:
	void entityRenamed(QString oldid, QString newid);
	void on_BrowseButton_clicked();

protected:
	ReturnValue getData();
	bool setData(QString id, QVariantMap fields);
	bool endSetData();
	void entityUpdated(QString id);

private:
	RdsShareManager *_sharemgr;
};

#endif

