/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "usereditwidget.h"
#include <RdsUser>
#include <QDebug>
#include <QMessageBox>
#include <QHostInfo>
#include <RdsEntityManager>
#include <RdsGroup>
#include "changepassworddialog.h"
#include "selectiondialog.h"
#include "browsedialog.h"
#include <RdsClient>
#include <RdsNtAcl>
#include <RdsSid>


UserEditWidget::UserEditWidget(RdsEntityManager *manager, QWidget* parent)
		: RdsEntityWidget(manager, parent), Ui::Form()
{
	setupUi(this);
	ProfileBrowseButton->setIcon(QPixmap(findRdsIcon("icons/16x16/folder.png")));
	HomeBrowseButton->setIcon(QPixmap(findRdsIcon("icons/16x16/folder.png")));
	setApplyButton(ApplyButton);
	setDiscardButton(DiscardButton);

	//General tab
	addWidget("userName", UserName, NoMulti, "^[0-9a-zA-Z][^\\\\\\[\\]:;|=+?<>*\"]*$", "The user name must not contain any of these characters ([ ] : ; | = + ? < > * \\ \").");
	addWidget("cn", FullName, NoMulti, "^[0-9a-zA-Z][^+\\;,=]*$", "The full name must not contain any of these characters (+ \\ ; , =).");
	addWidget("description", Description, NoMulti);
	addWidget("disabled", Disabled);
	addWidget("locked", Locked);
	addWidget("mustChangePassword", MustChangePassword);
	addWidget("cannotChangePassword", CannotChangePassword);
	addWidget("passwordNeverExpires", PasswordNeverExpires);

	//Group Tab
	addWidget("groups", GroupList, "groups", SIGNAL(changed()), NoMulti, QStringList());
	addWidget("primaryGroup", PrimaryGroup, "dn", SIGNAL(changed()), RdsEntityWidget::None, "");

	//Contact tab
	addWidget("firstName", FirstName, NoMulti);
	addWidget("initials", Initials, NoMulti);
	addWidget("lastName", LastName);
	addWidget("displayName", DisplayName, NoMulti);
	addWidget("street", Street);
	addWidget("city", City);
	addWidget("postalCode", Zip);
	addWidget("state", State);
	addWidget("country", Country);
	addWidget("homeNumber", HomeNumber, NoMulti);
	addWidget("mobileNumber", MobileNumber, NoMulti);
	addWidget("email", Email);
	addWidget("title", Title);
	addWidget("office", Office);
	addWidget("department", Department);
	addWidget("aliases", Aliases, "list", SIGNAL(changed()));
	Aliases->setErrorText("You must specify a valid email address.");
	Aliases->setWeakValidator(QRegExp("[a-zA-Z0-9._%+-@]*"));
	Aliases->setStrongValidator(QRegExp("^[a-zA-Z0-9._%+-]*@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$"));
	Aliases->setUpDownArrows(false);

	//Profile tab
	addWidget("profilePath", ProfilePath);
	addWidget("logonScript", LogonScript);
	addWidget("homeDrive", HomeDrive);
	addWidget("homePath", HomeDirectory);

	//Countries
	addCountry("Afghanistan", "AF");
	addCountry("Albania", "AL");
	addCountry("Algeria", "DZ");
	addCountry("Andorra", "AD");
	addCountry("Angola", "AO");
	addCountry("Anguilla", "AI");
	addCountry("Antigua and Barbuda", "AG");
	addCountry("Argentina", "AR");
	addCountry("ARIPO", "AP");
	addCountry("Armenia", "AM");
	addCountry("Aruba", "AW");
	addCountry("Australia", "AU");
	addCountry("Austria", "AT");
	addCountry("Azerbaijan", "AZ");
	addCountry("Bahamas", "BS");
	addCountry("Bahrain", "BH");
	addCountry("Bangladesh", "BD");
	addCountry("Barbados", "BB");
	addCountry("BBM and BBDM", "BX");
	addCountry("Belarus", "BY");
	addCountry("Belgium", "BE");
	addCountry("Belize", "BZ");
	addCountry("Benin", "BJ");
	addCountry("Bermuda", "BM");
	addCountry("Bhutan", "BT");
	addCountry("Bolivia", "BO");
	addCountry("Bosnia and Herzegovina", "BA");
	addCountry("Botswana", "BW");
	addCountry("Bouvet Island", "BV");
	addCountry("Brazil", "BR");
	addCountry("British Virgin Islands", "VG");
	addCountry("Burundi", "BI");
	addCountry("Brunei Darussalam", "BN");
	addCountry("Bulgaria", "BG");
	addCountry("Burkina Faso", "BF");
	addCountry("Burma", "BU");
	addCountry("Cameroon", "CM");
	addCountry("Canada", "CA");
	addCountry("Cape Verde", "CV");
	addCountry("Cayman Islands", "KY");
	addCountry("Central African Republic", "CF");
	addCountry("Chad", "TD");
	addCountry("Chile", "CL");
	addCountry("China", "CN");
	addCountry("Colombia", "CO");
	addCountry("Comoros", "KM");
	addCountry("Congo", "CG");
	addCountry("Cook Islands", "CK");
	addCountry("Costa Rica", "CR");
	addCountry("Cote d'Ivoire", "CI");
	addCountry("Croatia", "HR");
	addCountry("Cuba", "CU");
	addCountry("Cyprus", "CY");
	addCountry("Czech Republic", "CZ");
	addCountry("Czechoslovakia", "CS");
	addCountry("Denmark", "DK");
	addCountry("Djibouti", "DJ");
	addCountry("Dominica", "DM");
	addCountry("Dominican Republic", "DO");
	addCountry("EAPO", "EA");
	addCountry("East Germany", "DD");
	addCountry("East Timor", "TP");
	addCountry("Ecuador", "EC");
	addCountry("Egypt", "EG");
	addCountry("El Salvador", "SV");
	addCountry("EPO", "EP");
	addCountry("Equatorial Guinea", "GQ");
	addCountry("Estonia", "EE");
	addCountry("Ethiopia", "ET");
	addCountry("Falkland Island", "FK");
	addCountry("Faroe Islands", "FO");
	addCountry("Fiji", "FJ");
	addCountry("Finland", "FI");
	addCountry("France", "FR");
	addCountry("Gabon", "GA");
	addCountry("Gambia", "GM");
	addCountry("Greenland", "GL");
	addCountry("Georgia", "GE");
	addCountry("Germany", "DE");
	addCountry("Ghana", "GH");
	addCountry("Gibraltar", "GI");
	addCountry("Greece", "GR");
	addCountry("Grenada", "GD");
	addCountry("Guatemala", "GT");
	addCountry("Guinea", "GN");
	addCountry("Guinea-Bissau", "GW");
	addCountry("Guyana", "GY");
	addCountry("Haiti", "HT");
	addCountry("Honduras", "HN");
	addCountry("Hong Kong", "HK");
	addCountry("Hungary", "HU");
	addCountry("Iceland", "IS");
	addCountry("IIB", "IB");
	addCountry("India", "IN");
	addCountry("Indonesia", "ID");
	addCountry("Iran", "IR");
	addCountry("Iraq", "IQ");
	addCountry("Ireland", "IE");
	addCountry("Israel", "IL");
	addCountry("Italy", "IT");
	addCountry("Jamaica", "JM");
	addCountry("Japan", "JP");
	addCountry("Jordan", "JO");
	addCountry("Kampuchea", "KH");
	addCountry("Kazakhstan", "KZ");
	addCountry("Kenya", "KE");
	addCountry("Kiribati", "KI");
	addCountry("Kuwait", "KW");
	addCountry("Kyrgyzstan", "KG");
	addCountry("Laos", "LA");
	addCountry("Lebanon", "LB");
	addCountry("Lesotho", "LS");
	addCountry("Liberia", "LR");
	addCountry("Libya", "LY");
	addCountry("Liechtenstein", "LI");
	addCountry("Lithuania", "LT");
	addCountry("Luxembourg", "LU");
	addCountry("Macao", "MO");
	addCountry("Macedonia", "MK");
	addCountry("Madagascar", "MG");
	addCountry("Malawi", "MW");
	addCountry("Malaysia", "MY");
	addCountry("Maldives", "MV");
	addCountry("Mali", "ML");
	addCountry("Malta", "MT");
	addCountry("Marshall Islands", "MH");
	addCountry("Mauritania", "MR");
	addCountry("Mauritius", "MU");
	addCountry("Mexico", "MX");
	addCountry("Micronesia", "FM");
	addCountry("Moldova", "MD");
	addCountry("Monaco", "MC");
	addCountry("Mongolia", "MN");
	addCountry("Montserrat", "MS");
	addCountry("Morocco", "MA");
	addCountry("Mozambique", "MZ");
	addCountry("Myanmar", "MM");
	addCountry("Namibia", "NA");
	addCountry("Nauru", "NR");
	addCountry("Nepal", "NP");
	addCountry("Netherlands(Holland)", "NL");
	addCountry("Netherlands Antilles", "AN");
	addCountry("New Zealand", "NZ");
	addCountry("Nicaragua", "NI");
	addCountry("Niger", "NE");
	addCountry("Nigeria", "NG");
	addCountry("North Korea", "KP");
	addCountry("Norway", "NO");
	addCountry("Northern Mariana Islands", "MP");
	addCountry("OAPI", "OA");
	addCountry("OHIM", "EM");
	addCountry("Oman", "OM");
	addCountry("Other Country", "XX");
	addCountry("Other Country in Africa", "X6");
	addCountry("Other Country in Asia", "X1");
	addCountry("Other Country in Europe", "X4");
	addCountry("Other Country in North America", "X2");
	addCountry("Other Country In Oceania", "X5");
	addCountry("Other Country in South America", "X3");
	addCountry("Pakistan", "PK");
	addCountry("Panama", "PA");
	addCountry("Papua New Guinea", "PG");
	addCountry("Paraguay", "PY");
	addCountry("Peru", "PE");
	addCountry("Philippines", "PH");
	addCountry("Poland", "PL");
	addCountry("Portugal", "PT");
	addCountry("Qatar", "QA");
	addCountry("Republic of Yemen", "YD");
	addCountry("Rhodesia", "RH");
	addCountry("Romania", "RO");
	addCountry("Russian Federation", "RU");
	addCountry("Rwanda", "RW");
	addCountry("Saint Helena", "SH");
	addCountry("Saint Kitts and Nevis", "KN");
	addCountry("Saint Lucia", "LC");
	addCountry("Saint Vincent and the Grenadines", "VC");
	addCountry("Samoa", "WS");
	addCountry("San Marino", "SM");
	addCountry("Sao Tome and Principe", "ST");
	addCountry("Saudi Arabia", "SA");
	addCountry("Senegal", "SN");
	addCountry("Seychelles", "SC");
	addCountry("Sierra Leone", "SL");
	addCountry("Singapore", "SG");
	addCountry("Slovakia", "SK");
	addCountry("Slovenia", "SI");
	addCountry("Solomon Islands", "SB");
	addCountry("Somalia", "SO");
	addCountry("South Africa", "ZA");
	addCountry("South Georgia and The South Sandwich Islands", "GS");
	addCountry("South Korea", "KR");
	addCountry("Spain", "ES");
	addCountry("Sri Lanka", "LK");
	addCountry("Sudan", "SD");
	addCountry("Suriname", "SR");
	addCountry("Swaziland", "SZ");
	addCountry("Sweden", "SE");
	addCountry("Switzerland", "CH");
	addCountry("Syria", "SY");
	addCountry("Taiwan", "TW");
	addCountry("Tajikistan", "TJ");
	addCountry("Tanzania", "TZ");
	addCountry("Thailand", "TH");
	addCountry("Togo", "TG");
	addCountry("Tonga", "TO");
	addCountry("Trinidad and Tobago", "TT");
	addCountry("Tunisia", "TN");
	addCountry("Turkey", "TR");
	addCountry("Turkmenistan", "TM");
	addCountry("Turks and Caicos Islands", "TC");
	addCountry("Tuvalu", "TV");
	addCountry("Uganda", "UG");
	addCountry("Ukraine", "UA");
	addCountry("United Arab Emirates", "AE");
	addCountry("United Kingdom", "GB");
	addCountry("United States of America", "US");
	addCountry("Uruguay", "UY");
	addCountry("Soviet Union", "SU");
	addCountry("Uzbekistan", "UZ");
	addCountry("Vanuatu", "VU");
	addCountry("Vatican City", "VA");
	addCountry("Venezuela", "VE");
	addCountry("Vietnam", "VN");
	addCountry("Volta", "HV");
	addCountry("Western Sahara", "EH");
	addCountry("WIPO", "WO");
	addCountry("Yemen", "YE");
	addCountry("Yugoslavia", "YU");
	addCountry("Zaire", "ZR");
	addCountry("Zambia", "ZM");
	addCountry("Zimbabwe", "ZW");

	QObject::connect(manager, SIGNAL(entityRenamed(QString, QString)), this, SLOT(entityRenamed(QString, QString)));
}

UserEditWidget::~UserEditWidget()
{
}

#define GET_DATA(name,function) ret = function; \
	if(ret.isError() && !ret.errString().endsWith("attribute does not exist")) err = ret; \
	fields[name] = ret

#define GET_FLAG(name,flag) \
	if((flags & flag) != 0) \
		fields[name] = true; \
	else \
		fields[name] = false;

ReturnValue UserEditWidget::getData()
{
	QVariantMap fields;
	RdsUser user(input());

	if (input() == "") return(ReturnValue(1, "Invalid User"));

	//qDebug() << "User:" << input();

	ReturnValue err = true;
	ReturnValue ret;

	GET_DATA("flags", user.flags());
	if (ret.isError())
	{
		qWarning() << "Failed to fetch flags!";
	}
	//qDebug() << "Got Flags:" << ret;
	int flags = fields["flags"].value<RdsUser::UserStates>();
	//qDebug() << "flags:" << flags;

	GET_FLAG("locked", RdsUser::Locked);
	Locked->setEnabled(fields["locked"].toBool());
	GET_FLAG("disabled", RdsUser::Disabled);
	GET_FLAG("mustChangePassword", RdsUser::MustChangePassword);
	GET_FLAG("cannotChangePassword", RdsUser::CannotChangePassword);
	GET_FLAG("passwordNeverExpires", RdsUser::PasswordNeverExpires);
	GET_FLAG("useReversibleEncryption", RdsUser::UseReversibleEncryption);
	GET_FLAG("smartCardRequired", RdsUser::SmartCardRequired);
	GET_FLAG("useDesPassword", RdsUser::UseDesPassword);
	GET_FLAG("notDelegated", RdsUser::NotDelegated);
	GET_FLAG("noPreAuth", RdsUser::NoPreAuth);

	GET_DATA("displayName", user.displayName());
	GET_DATA("primaryGroup", user.primaryGroup());
	GET_DATA("cn", user.cn());
	GET_DATA("groups", user.groups());
	QStringList tmp = fields["groups"].toStringList();
	tmp.sort();
	fields["groups"] = tmp;
	GET_DATA("userName", user.userName());
	GET_DATA("description", user.description());
	GET_DATA("firstName", user.firstName());
	GET_DATA("initials", user.initials());
	GET_DATA("lastName", user.lastName());
	GET_DATA("office", user.office());
	GET_DATA("phoneNumber", user.phoneNumber());
	GET_DATA("email", user.email());
	GET_DATA("aliases", user.emailAliases());
	GET_DATA("street", user.street());
	fields["street"] = fields["street"].toString().replace("\r", ""); //remove \r from \r\n
	GET_DATA("city", user.city());
	GET_DATA("state", user.state());
	GET_DATA("country", user.country());
	QString country = fields["country"].toString();
	if (_abbrtocountry.keys().contains(country)) fields["country"] = _abbrtocountry[country];
	GET_DATA("postalCode", user.postalCode());
	GET_DATA("homeDrive", user.homeDrive());
	if (fields["homeDrive"].toString() == "") fields["homeDrive"] = "None";
	GET_DATA("homePath", user.homePath());
	GET_DATA("profilePath", user.profilePath());
	GET_DATA("logonScript", user.logonScript());
	GET_DATA("mobileNumber", user.mobileNumber());
	GET_DATA("homeNumber", user.homeNumber());
	GET_DATA("title", user.title());
	GET_DATA("department", user.department());
	GET_DATA("company", user.company());

	if (err.isError())
	{
		QMessageBox msg(QMessageBox::Warning, "Error", "There was an error opening this user: " + ret.errString(), QMessageBox::Ok);
		QAbstractButton *editbutton = msg.addButton("Edit Anyway", QMessageBox::RejectRole);
		msg.exec();
		if (msg.clickedButton() == editbutton)
		{
			if (QMessageBox::warning(this, "Warning", "Editing a user in this state may be dangerous. Continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
			{
				return(fields);
			}
		}
		return(err);
	}


	return(fields);
};

#define SET_FLAG(field,flag) \
	if(name == field) \
	{ \
		if(value.toBool()) \
			flags |= flag; \
		else \
			flags &= ~flag;  \
	} \
	 
#define SET_FIELD(field,function) if (name == field) \
	{ \
		ret = function; \
		if (ret.isError()) err = ret; \
	}

#define SET_FIELD_STRING(field,function) \
	SET_FIELD(field,user.function(value.toString()));

#define SET_FIELD_STRINGLIST(field,function) \
	SET_FIELD(field,user.function(value.toStringList()));
	
bool UserEditWidget::setData(QString id, QVariantMap fields)
{
	RdsUser user(id);
	QString cn = user.cn().toString();

	RdsFileManager fmgr;
	ReturnValue ret = fmgr.init();
	if(ret.isError())
	{
		QMessageBox::critical(this,"Error", "Failed to get file manager object: " + ret.errString());
		return(false);
	}
	
	ReturnValue err = true;

	ret = user.flags();
	int flags = 0;
	if (ret.isError())
	{
		flags = -1;
		err = ret;
	}
	else
	{
		flags = ret.value<RdsUser::UserStates>();
	}

	int oldflags = flags;

	foreach(QString name, fields.keys())
	{
		QVariant value = fields[name];

		SET_FLAG("locked", RdsUser::Locked);
		SET_FLAG("disabled", RdsUser::Disabled);
		SET_FLAG("mustChangePassword", RdsUser::MustChangePassword);
		SET_FLAG("cannotChangePassword", RdsUser::CannotChangePassword);
		SET_FLAG("passwordNeverExpires", RdsUser::PasswordNeverExpires);
		SET_FLAG("useReversibleEncryption", RdsUser::UseReversibleEncryption);
		SET_FLAG("smartCardRequired", RdsUser::SmartCardRequired);
		SET_FLAG("useDesPassword", RdsUser::UseDesPassword);
		SET_FLAG("notDelegated", RdsUser::NotDelegated);
		SET_FLAG("noPreAuth", RdsUser::NoPreAuth);

		SET_FIELD_STRING("userName", setUserName);
		SET_FIELD_STRING("description", setDescription);
		SET_FIELD_STRING("firstName", setFirstName);
		SET_FIELD_STRING("initials", setInitials);
		SET_FIELD_STRING("lastName", setLastName);
		SET_FIELD_STRING("displayName", setDisplayName);
		SET_FIELD_STRING("street", setStreet);
		SET_FIELD_STRING("city", setCity);
		SET_FIELD_STRING("postalCode", setPostalCode);
		SET_FIELD_STRING("state", setState);
		SET_FIELD_STRING("homeNumber", setHomeNumber);
		SET_FIELD_STRING("mobileNumber", setMobileNumber);
		SET_FIELD_STRING("title", setTitle);
		SET_FIELD_STRING("office", setOffice);
		SET_FIELD_STRING("department", setDepartment);
		SET_FIELD_STRING("logonScript", setLogonScript);

		if (name == "email")
		{
			QString email = value.toString();
			email = email.replace("%USERNAME%", cn);
			if(email.startsWith("@")) email = cn + email;
			email = email.replace(" ","_");
			ret = user.setEmail(email);
			if (ret.isError()) err = ret;
		}
		
		if (name == "aliases")
		{
			QStringList aliases;
			
			foreach(QString email, value.toStringList())
			{
				email = email.replace("%USERNAME%",cn);
				if(email.startsWith("@")) email = cn + email;
				email = email.replace(" ","_");
				
				aliases << email;
			}
			
			ret = user.setEmailAliases(aliases);
			if (ret.isError()) err = ret;
		}
		
		if (name == "profilePath")
		{
			ReturnValue ret = RdsUser(id).userName();
			if (!ret.isError())
			{
				QString username = ret.toString();
				ret = rdsClient()->hostname();
				if (!ret.isError())
				{
					QString profilepath = value.toString();
					profilepath = profilepath.replace("%USERNAME%", username, Qt::CaseInsensitive);
					profilepath = profilepath.replace("%SERVER%", ret.toString(), Qt::CaseInsensitive);
					if((profilepath.count("\\") >= 1) && (!profilepath.endsWith("\\")))
					{
						profilepath += "\\";
					}
					value = profilepath;
					SET_FIELD_STRING("profilePath", setProfilePath);
				}
				else
				{
					qWarning() << "Failed to look up hostname:" << ret;
					err = ret;
				}
			}
			else
			{
				err = ret;
			}
		}
		else if (name == "homePath")
		{
			ReturnValue ret = RdsUser(id).userName();
			if (!ret.isError())
			{
				QString username = ret.toString();
				ret = rdsClient()->hostname();
				if (!ret.isError())
				{
					QString homepath = value.toString();
					homepath = homepath.replace("%USERNAME%", username, Qt::CaseInsensitive);
					homepath = homepath.replace("%SERVER%", ret.toString(), Qt::CaseInsensitive);
					if((homepath.count("\\") >= 1) && (homepath.endsWith("\\")))
					{
						homepath = homepath.left(homepath.size()-1);
					}
					value = homepath;
					
					QString path = value.toString().replace("\\","/");
					path = path.replace("//" + ret.toString(), "@SHARE");
					
					SET_FIELD_STRING("homePath", setHomePath);
					
					//qDebug() << "PATH:" << path;
					
					ret = fmgr.isDirectory(path);
					if(!ret.isError())
					{
						if(!ret.toBool())
						{
							ret = fmgr.createDirectory(path, true);
							if(ret.isError())
							{
								qWarning() << "Failed to create home directory:" << ret;
							}
							
							ret = fmgr.ntPermissions(path);
							if(ret.isError())
							{
								qWarning() << "Failed to get permissions for:" << path << ret;
							}
							else
							{
								RdsNtAcl acl = ret.value<RdsNtAcl>();
								ret = user.sid();
								if(ret.isError())
								{
									qWarning() << "Failed to get sid for user" << ret;
								}
								else
								{
									RdsAce ace;
									ace.setSid(ret.value<RdsSid>());
									ace.setFlags(RdsAce::FileInherit | RdsAce::FolderInherit);
									ace.setAccess(RdsAce::StandardAll | RdsAce::FileAll);
									acl.dacl() << ace;
									
									ret = fmgr.setNtPermissions(path, acl);
									if(ret.isError())
									{
										qWarning() << "Failed to set permissions for path" << path << ret;
									}
								}
								
							}
						}
					}
					else qWarning() << "Failed to check home directory:" << ret;
				}
				else
				{
					qWarning() << "Failed to look up hostname:" << ret;
					err = ret;
				}
			}
			else
			{
				err = ret;
			}
		}
		else if (name == "groups")
		{
			//qDebug() << "Changing Groups:" << value.toStringList();
			ret = user.groups();
			if (!ret.isError())
			{
				QStringList newgroups = value.toStringList();
				QStringList oldgroups = ret.toStringList();

				//Add new groups
				foreach(QString group, newgroups)
				{
					if (!oldgroups.contains(group))
					{
						ret = user.joinGroup(group);
						//qDebug() << "Joining Group:" << group;
						if (ret.isError()) err = ret;
					}
				}

				foreach(QString group, oldgroups)
				{
					if (!newgroups.contains(group))
					{
						ret = user.leaveGroup(group);
						//qDebug() << "Leaving Group:" << group;
						if (ret.isError()) err = ret;
					}
				}
			}
			else
			{
				err = ret;
			}

		}

		SET_FIELD_STRING("primaryGroup", setPrimaryGroup);



		if (name == "homeDrive")
		{
			if (value.toString() == "None") value = "";
			ret = user.setHomeDrive(value.toString());
			if (ret.isError()) err = ret;
		}

		if (name == "country")
		{
			if (_countrytoabbr.contains(value.toString()))
			{
				value = _countrytoabbr[value.toString()];
			}
			//qDebug() << "setting country" << value;
			ret = user.setCountry(value.toString());
			if (ret.isError()) err = ret;
		}

		if (name == "cn")
		{
			//qDebug() << "setting cn" << value;
			ret = user.setCn(value.toString());
			if (ret.isError())
			{
				err = ret;
			}
			else
			{
				QString dn = ret.toString();

				QStringList outlist = outputs();
				for (int i = 0; i < outlist.size(); i++)
				{
					if (outlist[i] == id) outlist[i] = dn;
				}

				setInput(dn);
				setOutputs(outlist);

				manager()->renameEntity(id, dn);
			}
		}
	}

//qDebug() << oldflags << flags;
	if ((oldflags != -1) && (oldflags != flags))
	{
		//qDebug() << "SETTING FLAGS" << flags;
		ret = user.setFlags(RdsUser::UserStates(flags));
		if (ret.isError()) err = ret;
	}

	if (err.isError())
	{
		qWarning() << "Failed to save user:" << id << err.errString();
		return(false);
	}
	else return(true);
};

void UserEditWidget::entityRenamed(QString oldid, QString newid)
{
	if (oldid != input()) return;

	RdsUser user(newid);
	ReturnValue ret = user.cn();
	if (ret.isError()) return;

	QString cn = ret.toString();

	QStringList outlist = outputs();
	for (int i = 0; i < outlist.size(); i++)
	{
		if (outlist[i] == input()) outlist[i] = newid;
	}

	setInput(newid);
	setOutputs(outlist);

	setField("cn", cn);
}

void UserEditWidget::on_ChangePassword_clicked()
{
	ChangePasswordDialog dialog(outputs(), this);
	dialog.exec();
}

void UserEditWidget::entityUpdated(QString id)
{
	if (id != input()) return;

	if (unsavedChanges())
	{
		if (QMessageBox::question(this, "User Changed",
		                          "Another user has made changes to the item you are editing. Would you like to overwrite your changes?",
		                          QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
		{
			RdsEntityWidget::entityUpdated(id);
		}
	}
	else
	{
		RdsEntityWidget::entityUpdated(id);
	}
}

void UserEditWidget::addCountry(QString name, QString abbr)
{
	_countrytoabbr[name] = abbr;
	_abbrtocountry[abbr] = name;
	Country->addItem(name);
}

void UserEditWidget::on_MustChangePassword_toggled(bool state)
{
	if (state)
	{
		//qDebug() << "MUST CHANGE PASSWORD!";
		CannotChangePassword->setChecked(false);
		fieldChanged(CannotChangePassword);
	}
}

void UserEditWidget::on_CannotChangePassword_toggled(bool state)
{
	if (state)
	{
		//qDebug() << "CANNOT CHANGE PASSWORD!";
		MustChangePassword->setChecked(false);
		fieldChanged(MustChangePassword);
	}
}

void UserEditWidget::setOutputs(QStringList outputs)
{
	if (outputs.size() > 1)
		ChangePassword->setText("Change Passwords");
	else
		ChangePassword->setText("Change Password");
	RdsEntityWidget::setOutputs(outputs);
}

void UserEditWidget::on_ProfileBrowseButton_clicked()
{
	BrowseDialog dialog(BrowseDialog::Shares);

	if (dialog.exec())
	{
		if (dialog.path() == "") return;
		ReturnValue ret = rdsClient()->hostname();
		if (ret.isError())
		{
			QMessageBox::critical(this, "Error", "Failed to look up hostname: " + ret.errString());
			return;
		}

		QString path = dialog.path();
		path = path.replace("@SHARE/", "\\\\" + ret.toString() + "\\");
		path = path.replace("/", "\\");

		ProfilePath->setText(path);
		fieldChanged(ProfilePath);
	}
}

void UserEditWidget::on_HomeBrowseButton_clicked()
{
	BrowseDialog dialog(BrowseDialog::Shares);

	if (dialog.exec())
	{
		if (dialog.path() == "") return;
		ReturnValue ret = rdsClient()->hostname();
		if (ret.isError())
		{
			QMessageBox::critical(this, "Error", "Failed to look up hostname: " + ret.errString());
			return;
		}

		QString path = dialog.path();
		path = path.replace("@SHARE/", "\\\\" + ret.toString() + "\\");
		path = path.replace("/", "\\");

		HomeDirectory->setText(path);
		fieldChanged(HomeDirectory);
	}
}

