/***************************************************************************
 *   Copyright (C) 2009 by Chris Vickery   *
 *   chris@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QtTest>
#include <QDebug>
#include "rdstest.h"
#include <ReturnValue>
#include <RdsClient>
#include <QSettings>
#include <RdsUtils>
#include <RdsLdapSession>

int main(int argc, char** argv)
{
	QCoreApplication app(argc, argv);
	bool socket = true;

	QString service = getenv("RDS_SERVICE");
	if (service == "") service = "Rds";

	QString host = getenv("RDS_SERVER");
	if (host == "")
		host = "localhost";
	else
		socket = false;

	int port = 0;
	QString tmp = getenv("RDS_PORT");
	if (tmp.toInt() != 0) port = tmp.toInt();
	if (port == 0)
		port = 10123;
	else
		socket = false;

	QSettings settings("/etc/rds.conf", QSettings::IniFormat);
	QString user = settings.value("adminuser").toString();
	QString pass = settings.value("adminpw").toString();

	qDebug() << user << pass << host << port << service << socket;

	RdsClient client;
	QString url;
	if (socket)
	{
		url = QString("socket:///var/run/rdsd.socket:%3").arg(service);
	}
	else
		url = QString("tcp://%1:%2@%3:%4/%5").arg(user).arg(pass).arg(host).arg(port).arg(service);
	ReturnValue ret = client.connect(url);
	if (ret.isError())
	{
		qCritical() << "Failed to connect to server:" << ret.errString();
		return(1);
	}

	RdsClient::setGlobalInstance(&client);

	ret = client.ldapSession();
	if (ret.isError())
	{
		qCritical() << "Failed to retrieve LDAP session." << ret.errString();
		return(1);
	}

	RdsLdapSession ldap;
	ldap = ret;
	RdsLdapSession::setGlobalSession(&ldap);

	ret = RdsUtils::init();

	if (ret.isError())
	{
		qCritical() << "Failed to get domain data:" << ret.errString();
		return(1);
	}

	RdsTest::runTests();
	return(0);
}
